/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CidrLogService {
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)CidrLogService.class.getPackage().getName());
    @NotNull
    private final Cache<StackTail, Object> myStackCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    public static void logOnce(@NotNull Level level, @NonNls @NotNull String message2) {
        if (level == null) {
            CidrLogService.j(0);
        }
        if (message2 == null) {
            CidrLogService.j(1);
        }
        CidrLogService.logOnce(LOG, level, message2);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String message2) {
        if (logger == null) {
            CidrLogService.j(2);
        }
        if (level == null) {
            CidrLogService.j(3);
        }
        if (message2 == null) {
            CidrLogService.j(4);
        }
        CidrLogService.j().j(logger, level, message2);
    }

    public static void logOnce(@NotNull Level level, @NonNls @Nullable String message2, @NotNull Throwable ex) {
        if (level == null) {
            CidrLogService.j(5);
        }
        if (ex == null) {
            CidrLogService.j(6);
        }
        CidrLogService.logOnce(LOG, level, message2, ex);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @Nullable String message2, @NotNull Throwable ex) {
        if (logger == null) {
            CidrLogService.j(7);
        }
        if (level == null) {
            CidrLogService.j(8);
        }
        if (ex == null) {
            CidrLogService.j(9);
        }
        CidrLogService.j().j(logger, level, message2, ex);
    }

    @NotNull
    private static CidrLogService j() {
        CidrLogService cidrLogService = (CidrLogService)ApplicationManager.getApplication().getService(CidrLogService.class);
        if (cidrLogService == null) {
            CidrLogService.j(10);
        }
        return cidrLogService;
    }

    private void j(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String string) {
        StackTail stackTail;
        Object object;
        if (logger == null) {
            CidrLogService.j(11);
        }
        if (level == null) {
            CidrLogService.j(12);
        }
        if (string == null) {
            CidrLogService.j(13);
        }
        if ((object = this.myStackCache.getIfPresent((Object)(stackTail = new StackTail(string)))) == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(string);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(string);
            } else if (level.equals(Level.INFO)) {
                logger.warn(string);
            }
        }
    }

    private void j(@NotNull Logger logger, @NotNull Level level, @Nullable String string, @NotNull Throwable throwable) {
        StackTail stackTail;
        Object object;
        if (logger == null) {
            CidrLogService.j(14);
        }
        if (level == null) {
            CidrLogService.j(15);
        }
        if (throwable == null) {
            CidrLogService.j(16);
        }
        if ((object = this.myStackCache.getIfPresent((Object)(stackTail = new StackTail(string, throwable)))) == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(string != null ? string : throwable.getMessage(), throwable);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(string != null ? string : throwable.getMessage(), throwable);
            }
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrLogService";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrLogService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logOnce";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logMessageOnce";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logExceptionOnce";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    private static class StackTail {
        private static final int TAIL_SIZE = 5;
        @Nullable
        private final String myMessage;
        private final StackTraceElement @NotNull [] myStackTrace;
        private final int myHashCode;

        StackTail(@NotNull String message2) {
            if (message2 == null) {
                StackTail.j(0);
            }
            this.myMessage = message2;
            this.myStackTrace = new StackTraceElement[0];
            this.myHashCode = StackTail.j(this.myMessage, this.myStackTrace);
        }

        StackTail(@Nullable String message2, @NotNull Throwable thr) {
            if (thr == null) {
                StackTail.j(1);
            }
            this.myMessage = message2;
            StackTraceElement[] stackTraceElementArray = thr.getStackTrace();
            int n2 = Math.min(stackTraceElementArray.length, 5);
            this.myStackTrace = new StackTraceElement[n2];
            System.arraycopy(stackTraceElementArray, 0, this.myStackTrace, 0, n2);
            this.myHashCode = StackTail.j(this.myMessage, this.myStackTrace);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackTail)) {
                return false;
            }
            StackTail stackTail = (StackTail)obj;
            if (!Objects.equals(this.myMessage, stackTail.myMessage)) {
                return false;
            }
            if (this.myStackTrace.length != stackTail.myStackTrace.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.myStackTrace.length; ++i2) {
                if (this.myStackTrace[i2].equals(stackTail.myStackTrace[i2])) continue;
                return false;
            }
            return true;
        }

        private static int j(@Nullable String string, StackTraceElement @NotNull [] stackTraceElementArray) {
            if (stackTraceElementArray == null) {
                StackTail.j(2);
            }
            int n2 = Objects.hash(string);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                n2 ^= stackTraceElement.hashCode();
            }
            return n2;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackTrace";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/CidrLogService$StackTail";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateHashCode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

