/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.util.system.CpuArch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArchitectureType
extends Enum<ArchitectureType> {
    public static final /* enum */ ArchitectureType I386 = new ArchitectureType(32, 3, 332, "i386", "i486", "i586", "i686", "x86");
    public static final /* enum */ ArchitectureType X86_64 = new ArchitectureType(64, 62, 34404, "x86_64", "x64", "amd64");
    public static final /* enum */ ArchitectureType ARM = new ArchitectureType(32, 40, 448, "arm", "xscale", "arm64_32");
    public static final /* enum */ ArchitectureType ARM64 = new ArchitectureType(64, 183, 43620, "arm64", "armv8", "aarch64");
    public static final /* enum */ ArchitectureType MIPS = new ArchitectureType(32, 8, null, "mips");
    public static final /* enum */ ArchitectureType MIPS64 = new ArchitectureType(64, 8, null, "mips64");
    public static final /* enum */ ArchitectureType PPC = new ArchitectureType(32, 20, null, "ppc", "powerpc");
    public static final /* enum */ ArchitectureType PPC64 = new ArchitectureType(64, 21, null, "powerpc64", "ppc970-64");
    public static final /* enum */ ArchitectureType SPARC = new ArchitectureType(32, 2, null, "sparc");
    public static final /* enum */ ArchitectureType SPARCV9 = new ArchitectureType(64, 43, null, "sparcv9");
    public static final /* enum */ ArchitectureType RISCV32 = new ArchitectureType(32, 243, 20530, "riscv32");
    public static final /* enum */ ArchitectureType RISCV64 = new ArchitectureType(64, 243, 20580, "riscv64");
    public static final /* enum */ ArchitectureType UNKNOWN = new ArchitectureType(0, null, null, "unknown");
    private final byte myBits;
    private final String @NotNull [] myIdPrefixArray;
    private final short myElfMachineCode;
    private final short myPeMachineCode;
    private static final /* synthetic */ ArchitectureType[] $VALUES;

    public static ArchitectureType[] values() {
        return (ArchitectureType[])$VALUES.clone();
    }

    public static ArchitectureType valueOf(String name) {
        return Enum.valueOf(ArchitectureType.class, name);
    }

    private ArchitectureType(@Nullable int bits, @NotNull Integer elfMachineCode, Integer peMachineCode, String ... idPrefix) {
        if (idPrefix == null) {
            ArchitectureType.j(0);
        }
        this.myElfMachineCode = elfMachineCode != null ? elfMachineCode.shortValue() : (short)0;
        short s10 = this.myPeMachineCode = peMachineCode != null ? peMachineCode.shortValue() : (short)0;
        if (idPrefix.length == 0) {
            throw new IllegalArgumentException("Missing architecture name");
        }
        this.myBits = (byte)bits;
        this.myIdPrefixArray = idPrefix;
    }

    @NotNull
    public String getId() {
        String string = this.myIdPrefixArray[0];
        if (string == null) {
            ArchitectureType.j(1);
        }
        return string;
    }

    public int getBits() {
        return this.myBits;
    }

    @NotNull
    public static ArchitectureType forArchitecture(@Nullable String arch) {
        ArchitectureType architectureType = UNKNOWN;
        if (arch != null) {
            int n2 = 0;
            for (ArchitectureType architectureType2 : ArchitectureType.values()) {
                for (String string : architectureType2.myIdPrefixArray) {
                    if (n2 >= string.length() || !arch.startsWith(string)) continue;
                    n2 = string.length();
                    architectureType = architectureType2;
                    if (n2 != arch.length()) continue;
                    ArchitectureType architectureType3 = architectureType;
                    if (architectureType3 == null) {
                        ArchitectureType.j(2);
                    }
                    return architectureType3;
                }
            }
        }
        ArchitectureType architectureType4 = architectureType;
        if (architectureType4 == null) {
            ArchitectureType.j(3);
        }
        return architectureType4;
    }

    @NotNull
    public static ArchitectureType forVmCpuArch(@NotNull CpuArch cpuArch) {
        if (cpuArch == null) {
            ArchitectureType.j(4);
        }
        ArchitectureType architectureType = switch (cpuArch) {
            default -> throw new IncompatibleClassChangeError();
            case CpuArch.X86 -> I386;
            case CpuArch.X86_64 -> X86_64;
            case CpuArch.ARM32 -> ARM;
            case CpuArch.ARM64 -> ARM64;
            case CpuArch.OTHER, CpuArch.UNKNOWN -> UNKNOWN;
        };
        if (architectureType == null) {
            ArchitectureType.j(5);
        }
        return architectureType;
    }

    @NotNull
    public static ArchitectureType forPeMachineType(short peCode) {
        for (ArchitectureType architectureType : ArchitectureType.values()) {
            if (architectureType.myPeMachineCode != peCode) continue;
            ArchitectureType architectureType2 = architectureType;
            if (architectureType2 == null) {
                ArchitectureType.j(6);
            }
            return architectureType2;
        }
        ArchitectureType architectureType = UNKNOWN;
        if (architectureType == null) {
            ArchitectureType.j(7);
        }
        return architectureType;
    }

    @NotNull
    public static ArchitectureType forElfMachineType(short elfCode) {
        for (ArchitectureType architectureType : ArchitectureType.values()) {
            if (architectureType.myElfMachineCode != elfCode) continue;
            ArchitectureType architectureType2 = architectureType;
            if (architectureType2 == null) {
                ArchitectureType.j(8);
            }
            return architectureType2;
        }
        ArchitectureType architectureType = UNKNOWN;
        if (architectureType == null) {
            ArchitectureType.j(9);
        }
        return architectureType;
    }

    private static /* synthetic */ ArchitectureType[] j() {
        return new ArchitectureType[]{I386, X86_64, ARM, ARM64, MIPS, MIPS64, PPC, PPC64, SPARC, SPARCV9, RISCV32, RISCV64, UNKNOWN};
    }

    static {
        $VALUES = ArchitectureType.j();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ArchitectureType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuArch";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ArchitectureType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forArchitecture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forVmCpuArch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forPeMachineType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forElfMachineType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forVmCpuArch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

