/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.jetbrains.cidr.xcode.Xcode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppleScript {
    @NonNls
    private static final String SPLIT_SCRIPT = "to splitString(aString, delimiter)\n set retVal to {}\n set prevDelimiter to AppleScript's text item delimiters\n set AppleScript's text item delimiters to {delimiter}\n set retVal to every text item of aString\n set AppleScript's text item delimiters to prevDelimiter\n return retVal\nend splitString\n";

    private AppleScript() {
    }

    public static void execute(@NonNls String script, boolean inProcess) throws IdeScriptException {
        if (inProcess) {
            IdeScriptEngine ideScriptEngine = IdeScriptEngineManager.getInstance().getEngineByName("AppleScript", null);
            if (ideScriptEngine == null) {
                throw new IdeScriptException("Cannot find AppleScript engine");
            }
            ideScriptEngine.eval(script);
        } else {
            try {
                Runtime runtime = Runtime.getRuntime();
                @NonNls String[] stringArray = new String[]{ExecUtil.getOsascriptPath(), "-e", script};
                runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                throw new IdeScriptException((Throwable)iOException);
            }
        }
    }

    public static void tell(@NonNls String app, @NonNls String action2, boolean inProcess) throws IdeScriptException {
        AppleScript.execute("tell application \"" + app + "\"\n " + action2 + "\nend tell", inProcess);
    }

    public static void tellWhenRunning(@NonNls String action2, @NonNls String app, boolean inProcess) throws IdeScriptException {
        AppleScript.execute("set i to 0\nrepeat\n if isRunning(\"" + app + "\") then\n  tell application \"" + app + "\"\n   " + action2 + "\n  end tell\n  exit repeat\n end if\n set i to (i + 1)\n if i = 200 then exit repeat\n delay 0.1\nend repeat\n" + AppleScript.j(), inProcess);
    }

    private static String j() {
        return "on isRunning(appName)\n  tell application \"System Events\" to set appNameIsRunning to exists (processes where name is appName)\n  return appNameIsRunning\nend ApplicationIsRunning\n";
    }

    public static void kill(@NonNls String appNamePattern, boolean inProcess) throws IdeScriptException {
        AppleScript.kill(appNamePattern, inProcess, false);
    }

    public static void kill(@NonNls String appNamePattern, boolean inProcess, boolean dashNine) throws IdeScriptException {
        AppleScript.execute("to splitString(aString, delimiter)\n set retVal to {}\n set prevDelimiter to AppleScript's text item delimiters\n set AppleScript's text item delimiters to {delimiter}\n set retVal to every text item of aString\n set AppleScript's text item delimiters to prevDelimiter\n return retVal\nend splitString\nset appName to \"" + appNamePattern + "\"\nset pidsString to (do shell script \"ps ax | awk '{print $1, $5}' | grep \" & (quoted form of appName) & \" | awk '{print $1}'\")\nset pids to splitString(pidsString, \"\\r\")\n" + AppleScript.j("pids", "each", "if each is not \"\" then \ntry\ndo shell script (\"kill " + (dashNine ? "-9" : "") + " \" & each)\nend try\nend if"), inProcess);
    }

    public static void openFileInXcode(@NotNull String filePathToOpen, @Nullable File projectFile) throws IdeScriptException, IOException {
        if (filePathToOpen == null) {
            AppleScript.j(0);
        }
        String string = Xcode.getInstance().getApplicationFilePath();
        String string2 = projectFile == null ? "missing value" : "\"" + projectFile.getPath() + "\"";
        String string3 = projectFile == null ? "missing value" : "\"" + projectFile.getName() + "\"";
        Object object = "";
        double d2 = 3000.0;
        if (projectFile != null) {
            FileTime fileTime = Files.readAttributes(projectFile.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
            long l2 = Math.max(System.currentTimeMillis() - fileTime.toMillis(), 0L);
            if ((double)l2 < d2) {
                double d3 = d2 - (double)l2;
                object = "  if my isRunning(\"Xcode\")\n    delay " + Math.ceil(d3 / 100.0) / 10.0 + "\n  end if\n";
            }
        }
        AppleScript.execute("on hasDocument(filePath)\n  tell application \"" + string + "\"\n    repeat with openedDocument in documents\n      set openedFilePath to path of openedDocument\n      if filePath is equal to openedFilePath then\n        return true\n      end if\n    end repeat\n  end tell\n  \n  return false\nend hasDocument\n\n" + AppleScript.j() + "\nset projFilePath to " + string2 + "\nset projFileName to " + string3 + "\nset filePath to \"" + filePathToOpen + "\"\nset isProjFileDefined to (projFilePath is not missing value)\n\ntell application \"" + string + "\"\n" + (String)object + "\n  if isProjFileDefined then\n    if not my hasDocument(projFilePath) then\n      open projFilePath\n        activate\n        \n        set workspaceDocument to workspace document projFileName\n        repeat 40 times\n          if loaded of workspaceDocument is true then\n            exit repeat\n          end if\n          delay 0.5\n        end repeat\n    end if\n    \n    activate\n  end if\n  \n  open filePath\n  \n  if not isProjFileDefined then\n    activate\n  end if\nend tell", false);
    }

    public static void main(String[] args) throws IdeScriptException {
        AppleScript.kill("iPhone Simulator", false);
    }

    @NonNls
    private static String j(@NonNls String string, @NonNls String string2, @NonNls String string3) {
        return "repeat with " + string2 + " in " + string + "\n " + string3 + "\nend repeat\n";
    }

    private static /* synthetic */ void j(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePathToOpen", "com/jetbrains/cidr/AppleScript", "openFileInXcode"));
    }
}

