/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.apple.sdk;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.apple.sdk.AppleSdkManagerBase;
import com.jetbrains.cidr.ArchitectureType;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArchitectureValue
implements Comparable<ArchitectureValue> {
    public static final ArchitectureValue i386 = new ArchitectureValue("i386");
    public static final ArchitectureValue x86_64 = new ArchitectureValue("x86_64");
    public static final ArchitectureValue arm64 = new ArchitectureValue("arm64");
    public static final ArchitectureValue HOST_ARCH = CpuArch.isArm64() ? arm64 : x86_64;
    public static final ImmutableSet<ArchitectureValue> KNOWN_HOST_ARCHS = ImmutableSet.of((Object)i386, (Object)x86_64, (Object)arm64);
    private static final List<@NlsSafe String> SORTED_ARCHS = ContainerUtil.newLinkedList((Object[])new String[]{"armv7k", "armv7s", "armv7", "arm64_32", "arm64", "i386", "x86_64"});
    @NotNull
    private final String myId;

    @Contract(pure=true)
    public ArchitectureValue(@NotNull @NlsSafe String id) {
        if (id == null) {
            ArchitectureValue.j(0);
        }
        this.myId = id;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ArchitectureValue create(@Nullable String id) {
        return id != null ? new ArchitectureValue(id) : null;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ArchitectureValue.j(1);
        }
        return string;
    }

    @NotNull
    public ArchitectureType getType() {
        ArchitectureType architectureType = ArchitectureType.forArchitecture(this.myId);
        if (architectureType == null) {
            ArchitectureValue.j(2);
        }
        return architectureType;
    }

    public int getBits() {
        return this.getType().getBits();
    }

    @NlsSafe
    public String toString() {
        return this.myId;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ArchitectureValue architectureValue = (ArchitectureValue)o2;
        return this.myId.equals(architectureValue.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @Override
    public int compareTo(@NotNull ArchitectureValue o2) {
        if (o2 == null) {
            ArchitectureValue.j(3);
        }
        return Integer.compare(ArchitectureValue.j(this.myId), ArchitectureValue.j(o2.myId));
    }

    private static int j(@NotNull String string) {
        int n2;
        if (string == null) {
            ArchitectureValue.j(4);
        }
        if ((n2 = SORTED_ARCHS.indexOf(string)) == -1) {
            AppleSdkManagerBase.LOG.warn("Unknown architecture: " + string);
        }
        return n2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/apple/sdk/ArchitectureValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/apple/sdk/ArchitectureValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArchWeight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

