/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WebResourcesPaths", storages={@Storage(value="webResources.xml")})
public final class WebResourcesPathsConfiguration
implements PersistentStateComponent<State> {
    private State myState;
    private final Project myProject;

    public WebResourcesPathsConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            WebResourcesPathsConfiguration.j(0);
        }
        this.myState = new State();
        this.myProject = project2;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.j("idea_temp_RemoteResourceRootsList");
            this.j("idea_temp_LocalResourceRootsList");
        }, this.myProject.getDisposed());
    }

    private void j(String string) {
        VirtualFile virtualFile2 = this.myProject.getBaseDir();
        if (virtualFile2 == null) {
            return;
        }
        final VirtualFile virtualFile3 = virtualFile2.findChild(string);
        if (virtualFile3 != null) {
            try {
                String string2 = VfsUtilCore.loadText((VirtualFile)virtualFile3);
                List<String> list = Arrays.asList(string2.split("\n"));
                MultiMap multiMap = new MultiMap();
                multiMap.put((Object)virtualFile2.getUrl(), list);
                this.setResourceRoots((MultiMap<String, String>)multiMap);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            virtualFile3.delete((Object)this);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static WebResourcesPathsConfiguration getInstance(Project project2) {
        return (WebResourcesPathsConfiguration)project2.getService(WebResourcesPathsConfiguration.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        VirtualFile[] virtualFileArray;
        if (state == null) {
            WebResourcesPathsConfiguration.j(1);
        }
        this.myState = state;
        if (this.myState.myResourceRoots != null && !this.myState.myResourceRoots.isEmpty() && (virtualFileArray = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).length == 1) {
            ContentEntryData contentEntryData = new ContentEntryData();
            contentEntryData.resourceRoots.addAll(this.myState.myResourceRoots);
            this.myState.contentEntries.put(virtualFileArray[0].getUrl(), contentEntryData);
        }
        assert (this.myState.myResourceRoots != null);
        this.myState.myResourceRoots.clear();
    }

    @NotNull
    public List<VirtualFile> getResourceDirectories() {
        Map<String, ContentEntryData> map = this.myState.contentEntries;
        if (map.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                WebResourcesPathsConfiguration.j(2);
            }
            return list;
        }
        SmartList smartList = new SmartList();
        for (ContentEntryData contentEntryData : map.values()) {
            for (String string : contentEntryData.resourceRoots) {
                ContainerUtil.addIfNotNull((Collection)smartList, (Object)VirtualFileManager.getInstance().findFileByUrl(string));
            }
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            WebResourcesPathsConfiguration.j(3);
        }
        return smartList2;
    }

    public boolean hasResourceRootPath(String path) {
        Map<String, ContentEntryData> map = this.myState.contentEntries;
        if (map.isEmpty()) {
            return false;
        }
        for (ContentEntryData contentEntryData : map.values()) {
            if (!contentEntryData.resourceRoots.contains(path)) continue;
            return true;
        }
        return false;
    }

    public MultiMap<String, String> getResourceRoots() {
        MultiMap multiMap = new MultiMap();
        for (Map.Entry<String, ContentEntryData> entry2 : this.myState.contentEntries.entrySet()) {
            multiMap.put((Object)entry2.getKey(), entry2.getValue().resourceRoots);
        }
        return multiMap;
    }

    public void setResourceRoots(MultiMap<String, String> roots) {
        this.myState.contentEntries.clear();
        for (String string : roots.keySet()) {
            ContentEntryData contentEntryData = new ContentEntryData();
            contentEntryData.resourceRoots.addAll(roots.get((Object)string));
            this.myState.contentEntries.put(string, contentEntryData);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {}, RootsChangeRescanningInfo.NO_RESCAN_NEEDED)));
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/resourceRoots/WebResourcesPathsConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/resourceRoots/WebResourcesPathsConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectories";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class State {
        @XCollection(propertyElementName="resourceRoots", elementName="path")
        public List<String> myResourceRoots = new SmartList();
        @XMap(keyAttributeName="url")
        public Map<String, ContentEntryData> contentEntries = new HashMap<String, ContentEntryData>();
    }

    @Tag(value="entryData")
    public static class ContentEntryData {
        @XCollection(style=XCollection.Style.v2, elementName="path")
        public List<String> resourceRoots = new SmartList();
    }
}

