/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

abstract class MarkResourceRootActionBase
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(MarkResourceRootActionBase.class);
    private final boolean myMark;

    MarkResourceRootActionBase(boolean mark, @NotNull Supplier<String> text) {
        if (text == null) {
            MarkResourceRootActionBase.j(0);
        }
        super(text);
        this.myMark = mark;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            MarkResourceRootActionBase.j(1);
        }
        boolean bl = this.j(e2);
        e2.getPresentation().setEnabledAndVisible(bl);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            MarkResourceRootActionBase.j(2);
        }
        Project project2 = Objects.requireNonNull(e2.getProject());
        VirtualFile[] virtualFileArray = Objects.requireNonNull((VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        WebResourcesPathsConfiguration webResourcesPathsConfiguration = Objects.requireNonNull(WebResourcesPathsConfiguration.getInstance(project2));
        MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
        for (VirtualFile virtualFile2 : virtualFileArray) {
            VirtualFile virtualFile3 = Objects.requireNonNull(projectFileIndex.getContentRootForFile(virtualFile2, false));
            if (this.myMark) {
                multiMap.putValue((Object)virtualFile3.getUrl(), (Object)virtualFile2.getUrl());
                continue;
            }
            multiMap.remove((Object)virtualFile3.getUrl(), (Object)virtualFile2.getUrl());
        }
        webResourcesPathsConfiguration.setResourceRoots(multiMap);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MarkResourceRootActionBase.j(3);
        }
        return actionUpdateThread;
    }

    private boolean j(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            MarkResourceRootActionBase.j(4);
        }
        Project project2 = anActionEvent.getProject();
        Object[] objectArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || ArrayUtil.isEmpty((Object[])objectArray)) {
            return false;
        }
        WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project2);
        if (webResourcesPathsConfiguration == null) {
            LOG.warn("Can not get configuration for " + project2);
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        for (Object object : objectArray) {
            if (!object.isDirectory()) {
                return false;
            }
            if (!projectFileIndex.isInContent((VirtualFile)object)) {
                return false;
            }
            VirtualFile virtualFile2 = projectFileIndex.getContentRootForFile((VirtualFile)object, false);
            if (virtualFile2 == null) {
                return false;
            }
            MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
            Collection collection = multiMap.get((Object)virtualFile2.getUrl());
            if (this.myMark != collection.contains(object.getUrl())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/resourceRoots/MarkResourceRootActionBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/resourceRoots/MarkResourceRootActionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canMark";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

