/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ui.ScriptingLibrariesPanel;
import javax.swing.JComponent;

public abstract class LangScriptingContextConfigurable
implements Configurable {
    private final ScriptingLibrariesPanel myPanel;
    private final ScriptingLibraryManager myLibManager;

    public LangScriptingContextConfigurable(Project project2, LangScriptingContextProvider provider) {
        this.myLibManager = provider.getLibraryManager(project2);
        this.myPanel = new ScriptingLibrariesPanel(provider, project2, this.myLibManager);
    }

    public JComponent createComponent() {
        return this.myPanel.getPanel();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myPanel.apply();
            this.myLibManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
        });
        this.myPanel.resetTable();
    }

    public void reset() {
        this.myLibManager.reset();
        this.myPanel.resetTable();
    }
}

