/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticInfo;
import com.intellij.platform.lsp.impl.highlighting.LspAnnotatorKt;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "j", "diagnosticInfos", "", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticInfo;", "elementRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1360#2:80\n1446#2,2:81\n1603#2,9:83\n1855#2:92\n1856#2:94\n1612#2:95\n1448#2,3:96\n1045#2:99\n1#3:93\n*S KotlinDebug\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n*L\n39#1:80\n39#1:81,2\n41#1:83,9\n41#1:92\n41#1:94\n41#1:95\n39#1:96,3\n46#1:99\n41#1:93\n*E\n"})
public final class LspAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile2 = element.getContainingFile().getVirtualFile();
        if (virtualFile2 == null || virtualFile2 instanceof VirtualFileWindow) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        List list = (List)holder.getCurrentAnnotationSession().getUserData(LspAnnotatorKt.access$getLSP_DIAGNOSTIC_INFOS$p());
        if (list == null) {
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project2).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t10 : iterable2) {
                List list2;
                Object object = (LspServerImpl)t10;
                boolean bl3 = false;
                if (((LspServerImpl)object).getDescriptor().getLspDiagnosticsSupport() == null) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    Iterable iterable3 = ((LspServerImpl)object).getDiagnosticsAndQuickFixes(virtualFile2);
                    boolean bl4 = false;
                    Iterable iterable4 = iterable3;
                    Collection collection2 = new ArrayList();
                    boolean bl5 = false;
                    Iterable iterable5 = iterable4;
                    boolean bl6 = false;
                    Iterator iterator = iterable5.iterator();
                    while (iterator.hasNext()) {
                        DiagnosticInfo diagnosticInfo;
                        TextRange textRange;
                        LspDiagnosticsSupport lspDiagnosticsSupport;
                        Object t11;
                        Object t12 = t11 = iterator.next();
                        boolean bl7 = false;
                        DiagnosticAndQuickFixes diagnosticAndQuickFixes = (DiagnosticAndQuickFixes)t12;
                        boolean bl8 = false;
                        Range range = diagnosticAndQuickFixes.getDiagnostic().getRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                        if ((Lsp4jUtilKt.getRangeInDocument(document2, range) == null ? null : new DiagnosticInfo(lspDiagnosticsSupport, diagnosticAndQuickFixes.getDiagnostic(), textRange, diagnosticAndQuickFixes.getQuickFixes())) == null) continue;
                        diagnosticInfo = diagnosticInfo;
                        boolean bl9 = false;
                        collection2.add(diagnosticInfo);
                    }
                    list2 = (List)collection2;
                }
                object = list2;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            iterable = (List)collection;
            bl = false;
            list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    DiagnosticInfo diagnosticInfo = (DiagnosticInfo)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(diagnosticInfo.getTextRange().getStartOffset());
                    diagnosticInfo = (DiagnosticInfo)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(diagnosticInfo.getTextRange().getStartOffset()));
                }
            }));
            holder.getCurrentAnnotationSession().putUserData(LspAnnotatorKt.access$getLSP_DIAGNOSTIC_INFOS$p(), (Object)list);
        }
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.j(list, textRange, holder);
    }

    private final void j(List<DiagnosticInfo> list, TextRange textRange, AnnotationHolder annotationHolder) {
        if (list.isEmpty()) {
            return;
        }
        int n2 = CollectionsKt.binarySearch$default(list, (int)0, (int)0, (Function1)((Function1)new Function1<DiagnosticInfo, Integer>(textRange){
            final /* synthetic */ TextRange $elementRange;
            {
                this.$elementRange = $elementRange;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull DiagnosticInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getTextRange().getStartOffset() < this.$elementRange.getStartOffset() ? -1 : 1;
            }
        }), (int)3, null);
        if ((n2 = Math.max(0, -n2 - 1)) >= list.size()) {
            return;
        }
        DiagnosticInfo diagnosticInfo = list.get(n2);
        while (diagnosticInfo != null && diagnosticInfo.getTextRange().getStartOffset() < textRange.getEndOffset()) {
            ProgressManager.checkCanceled();
            if (textRange.contains(diagnosticInfo.getTextRange())) {
                list.remove(n2);
                diagnosticInfo.getDiagnosticsSupport().createAnnotation(annotationHolder, diagnosticInfo.getDiagnostic(), diagnosticInfo.getTextRange(), diagnosticInfo.getQuickFixes());
            } else {
                ++n2;
            }
            diagnosticInfo = n2 < list.size() ? list.get(n2) : null;
        }
    }
}

