/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspBundle;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.intellij.platform.lsp.api.customization.LspIntentionAction;
import com.intellij.platform.lsp.impl.LspDynamicCapabilities;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerNotificationsHandlerImpl;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.LogTraceParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\u00062\u0006\u0010\b\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020 H\u0016J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\"0\u00062\u0006\u0010\b\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001aH\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\b\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\fH\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u00020:H\u0016J\u0014\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u000b0\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl;", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "applyEdit", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/ApplyWorkspaceEditResponse;", "params", "Lorg/eclipse/lsp4j/ApplyWorkspaceEditParams;", "configuration", "", "", "Lorg/eclipse/lsp4j/ConfigurationParams;", "createProgress", "Ljava/lang/Void;", "Lorg/eclipse/lsp4j/WorkDoneProgressCreateParams;", "j", "Lorg/eclipse/lsp4j/MessageActionItem;", "message", "", "type", "Lcom/intellij/notification/NotificationType;", "notificationGroup", "actionItems", "j", "Lorg/eclipse/lsp4j/MessageParams;", "logMessage", "", "logTrace", "Lorg/eclipse/lsp4j/LogTraceParams;", "notifyProgress", "Lorg/eclipse/lsp4j/ProgressParams;", "j", "Lorg/eclipse/lsp4j/ShowDocumentResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "", "selection", "Lorg/eclipse/lsp4j/Range;", "publishDiagnostics", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "refreshCodeLenses", "refreshDiagnostics", "refreshInlayHints", "refreshInlineValues", "refreshSemanticTokens", "registerCapability", "Lorg/eclipse/lsp4j/RegistrationParams;", "showDocument", "Lorg/eclipse/lsp4j/ShowDocumentParams;", "showMessage", "showMessageRequest", "Lorg/eclipse/lsp4j/ShowMessageRequestParams;", "telemetryEvent", "object", "unregisterCapability", "Lorg/eclipse/lsp4j/UnregistrationParams;", "workspaceFolders", "Lorg/eclipse/lsp4j/WorkspaceFolder;", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspServerNotificationsHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerNotificationsHandlerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1855#2,2:239\n1855#2,2:241\n1549#2:247\n1620#2,3:248\n1855#2,2:251\n11065#3:243\n11400#3,3:244\n1#4:253\n*S KotlinDebug\n*F\n+ 1 LspServerNotificationsHandlerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl\n*L\n60#1:239,2\n65#1:241,2\n138#1:247\n138#1:248,3\n203#1:251,2\n130#1:243\n130#1:244,3\n*E\n"})
public final class LspServerNotificationsHandlerImpl
implements LspServerNotificationsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    public static final String SHOW_MESSAGE_NOTIFICATION_GROUP = "LSP window/showMessage";
    @NotNull
    private static final String LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP = "LSP window/logMessage: errors, warnings";
    @NotNull
    private static final String LOG_INFO_TRACE_NOTIFICATION_GROUP = "LSP window/logMessage: info, log; $/logTrace";

    public LspServerNotificationsHandlerImpl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
    }

    @Override
    @NotNull
    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(@NotNull ApplyWorkspaceEditParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        CompletableFuture<ApplyWorkspaceEditResponse> completableFuture = new CompletableFuture<ApplyWorkspaceEditResponse>();
        ReadAction.nonBlocking(() -> LspServerNotificationsHandlerImpl.j(this, params2)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerNotificationsHandlerImpl.j((Function1)new Function1<LspIntentionAction, Unit>(params2, this, completableFuture){
            final /* synthetic */ ApplyWorkspaceEditParams $params;
            final /* synthetic */ LspServerNotificationsHandlerImpl this$0;
            final /* synthetic */ CompletableFuture<ApplyWorkspaceEditResponse> $future;
            {
                this.$params = $params;
                this.this$0 = $receiver;
                this.$future = $future;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(LspIntentionAction intentionAction) {
                try {
                    if (intentionAction != null) {
                        String string = this.$params.getLabel();
                        if (string == null) {
                            Object[] objectArray = new Object[]{LspServerNotificationsHandlerImpl.access$getLspServer$p(this.this$0).getDescriptor().getPresentableName()};
                            string = LspBundle.INSTANCE.message("code.change.from.server", objectArray);
                        }
                        String string2 = string;
                        WriteCommandAction.runWriteCommandAction((Project)LspServerNotificationsHandlerImpl.access$getLspServer$p(this.this$0).getProject(), (String)string2, null, () -> applyEdit.2.j(intentionAction), (PsiFile[])new PsiFile[0]);
                        this.$future.complete(new ApplyWorkspaceEditResponse(true));
                    }
                }
                finally {
                    if (!this.$future.isDone()) {
                        this.$future.complete(new ApplyWorkspaceEditResponse(false));
                    }
                }
            }

            private static final void j(LspIntentionAction lspIntentionAction) {
                lspIntentionAction.invoke(null);
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> registerCapability(@NotNull RegistrationParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        List list = params2.getRegistrations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegistrations(...)");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t10 : iterable) {
            Registration registration = (Registration)t10;
            boolean bl2 = false;
            LspDynamicCapabilities lspDynamicCapabilities = this.lspServer.getDynamicCapabilities$intellij_platform_lsp_impl();
            Intrinsics.checkNotNull((Object)registration);
            lspDynamicCapabilities.registerCapability(registration);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> unregisterCapability(@NotNull UnregistrationParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        List list = params2.getUnregisterations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnregisterations(...)");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t10 : iterable) {
            Unregistration unregistration = (Unregistration)t10;
            boolean bl2 = false;
            LspDynamicCapabilities lspDynamicCapabilities = this.lspServer.getDynamicCapabilities$intellij_platform_lsp_impl();
            Intrinsics.checkNotNull((Object)unregistration);
            lspDynamicCapabilities.unregisterCapability(unregistration);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    public void telemetryEvent(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
    }

    @Override
    public void publishDiagnostics(@NotNull PublishDiagnosticsParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (!this.lspServer.getProject().isDisposed()) {
            this.lspServer.diagnosticsReceived$intellij_platform_lsp_impl(params2);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<ShowDocumentResult> showDocument(@NotNull ShowDocumentParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        String string = params2.getUri();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.startsWith$default((String)string, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"https://", (boolean)false, (int)2, null)) {
            BrowserUtil.browse((String)string, (Project)this.lspServer.getProject());
            CompletableFuture<ShowDocumentResult> completableFuture = CompletableFuture.completedFuture(new ShowDocumentResult(true));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        VirtualFile virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            return this.j(virtualFile3, !Intrinsics.areEqual((Object)params2.getTakeFocus(), (Object)false), params2.getSelection());
        }
        CompletableFuture<ShowDocumentResult> completableFuture = CompletableFuture.completedFuture(new ShowDocumentResult(false));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<ShowDocumentResult> j(VirtualFile virtualFile2, boolean bl, Range range) {
        CompletableFuture<ShowDocumentResult> completableFuture = new CompletableFuture<ShowDocumentResult>();
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(virtualFile2, this, range, bl, completableFuture){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ LspServerNotificationsHandlerImpl this$0;
            final /* synthetic */ Range $selection;
            final /* synthetic */ boolean $focusEditor;
            final /* synthetic */ CompletableFuture<ShowDocumentResult> $future;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                this.$selection = $selection;
                this.$focusEditor = $focusEditor;
                this.$future = $future;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    if (this.$file.isValid()) {
                        Document document;
                        Project project2 = LspServerNotificationsHandlerImpl.access$getLspServer$p(this.this$0).getProject();
                        if (this.$selection != null && (document = FileDocumentManager.getInstance().getDocument(this.$file)) != null) {
                            Position position = this.$selection.getStart();
                            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                            Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
                            Position position2 = this.$selection.getEnd();
                            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
                            Integer n3 = Lsp4jUtilKt.getOffsetInDocument(document, position2);
                            if (n2 != null && n3 != null) {
                                Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.$file, n2.intValue()), this.$focusEditor);
                                Object object = editor;
                                if (object != null) {
                                    Editor editor2;
                                    Editor editor3 = editor2 = object;
                                    boolean bl = false;
                                    object = !Intrinsics.areEqual((Object)n2, (Object)n3) ? editor2 : null;
                                    if (object != null && (object = object.getSelectionModel()) != null) {
                                        object.setSelection(n2.intValue(), n3.intValue());
                                    }
                                }
                                this.$future.complete(new ShowDocumentResult(editor != null));
                                return;
                            }
                        }
                        this.$future.complete(new ShowDocumentResult((document = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.$file), this.$focusEditor)) != null));
                    }
                }
                finally {
                    if (!this.$future.isDone()) {
                        this.$future.complete(new ShowDocumentResult(false));
                    }
                }
            }
        }), (int)1, null);
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<List<WorkspaceFolder>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        VirtualFile[] virtualFileArray = this.lspServer.getDescriptor().getRoots();
        boolean bl = false;
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        Collection collection = new ArrayList(virtualFileArray.length);
        boolean bl2 = false;
        int n2 = virtualFileArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile2 = virtualFileArray2[i2];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new WorkspaceFolder(this.lspServer.getDescriptor().getFileUri(virtualFile3), virtualFile3.getName()));
        }
        CompletableFuture<List<WorkspaceFolder>> completableFuture = CompletableFuture.completedFuture((List)collection);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<Object>> configuration(@NotNull ConfigurationParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<List<Object>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        List list = params2.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            ConfigurationItem configurationItem = (ConfigurationItem)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            LspServerDescriptor lspServerDescriptor = this.lspServer.getDescriptor();
            Intrinsics.checkNotNull((Object)configurationItem);
            collection2.add(lspServerDescriptor.getWorkspaceConfiguration(configurationItem));
        }
        CompletableFuture<List<Object>> completableFuture = CompletableFuture.completedFuture((List)collection);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> createProgress(@NotNull WorkDoneProgressCreateParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    public void notifyProgress(@NotNull ProgressParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshSemanticTokens() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshCodeLenses() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshInlayHints() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshInlineValues() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshDiagnostics() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<MessageActionItem> showMessageRequest(@NotNull ShowMessageRequestParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        List list = params2.getActions();
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/showMessageRequest: " + params2.getMessage() + ": " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)showMessageRequest.1.INSTANCE, (int)31, null) : null));
        String string = params2.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return this.j(string, this.j((MessageParams)params2), SHOW_MESSAGE_NOTIFICATION_GROUP, params2.getActions());
    }

    @Override
    public void showMessage(@NotNull MessageParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/showMessage: " + params2.getMessage());
        String string = params2.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        LspServerNotificationsHandlerImpl.doNotify$default(this, string, this.j(params2), SHOW_MESSAGE_NOTIFICATION_GROUP, null, 8, null);
    }

    @Override
    public void logMessage(@NotNull MessageParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/logMessage " + params2.getType() + ": " + params2.getMessage());
        if (params2.getType() == MessageType.Error || params2.getType() == MessageType.Warning) {
            String string = params2.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            LspServerNotificationsHandlerImpl.doNotify$default(this, string, this.j(params2), LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP, null, 8, null);
        } else {
            String string = params2.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            LspServerNotificationsHandlerImpl.doNotify$default(this, string, NotificationType.INFORMATION, LOG_INFO_TRACE_NOTIFICATION_GROUP, null, 8, null);
        }
    }

    @Override
    public void logTrace(@NotNull LogTraceParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        String string = params2.getVerbose() != null ? params2.getMessage() + "\n" + params2.getVerbose() : params2.getMessage();
        Intrinsics.checkNotNull((Object)string);
        LspServerNotificationsHandlerImpl.doNotify$default(this, string, NotificationType.INFORMATION, LOG_INFO_TRACE_NOTIFICATION_GROUP, null, 8, null);
    }

    private final NotificationType j(MessageParams messageParams) {
        MessageType messageType = messageParams.getType();
        Intrinsics.checkNotNull((Object)messageType);
        return switch (WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1 -> NotificationType.ERROR;
            case 2 -> NotificationType.WARNING;
            case 3, 4 -> NotificationType.INFORMATION;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final CompletableFuture<MessageActionItem> j(@NlsSafe String string, NotificationType notificationType, String string2, List<? extends MessageActionItem> list) {
        Notification notification;
        CompletableFuture<MessageActionItem> completableFuture = new CompletableFuture<MessageActionItem>();
        String string3 = this.lspServer.getDescriptor().getPresentableName() + ": " + string;
        Notification notification2 = notification = NotificationGroupManager.getInstance().getNotificationGroup(string2).createNotification(string3, notificationType);
        boolean bl = false;
        List<? extends MessageActionItem> list2 = list;
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl2 = false;
            for (Object t10 : iterable) {
                String string4;
                MessageActionItem messageActionItem = (MessageActionItem)t10;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)messageActionItem.getTitle(), (String)"getTitle(...)");
                notification2.addAction(new AnAction(string4, notification2, completableFuture, messageActionItem){
                    final /* synthetic */ Notification $notification;
                    final /* synthetic */ CompletableFuture<MessageActionItem> $result;
                    final /* synthetic */ MessageActionItem $actionItem;
                    {
                        this.$notification = $notification;
                        this.$result = $result;
                        this.$actionItem = $actionItem;
                        super($actionLabel);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e2) {
                        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                        this.$notification.expire();
                        this.$result.complete(this.$actionItem);
                    }
                });
            }
        }
        notification.notify(this.lspServer.getProject());
        return completableFuture;
    }

    static /* synthetic */ CompletableFuture doNotify$default(LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, String string, NotificationType notificationType, String string2, List list, int n2, Object object) {
        if ((n2 & 8) != 0) {
            list = null;
        }
        return lspServerNotificationsHandlerImpl.j(string, notificationType, string2, list);
    }

    private static final LspIntentionAction j(LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, ApplyWorkspaceEditParams applyWorkspaceEditParams) {
        Intrinsics.checkNotNullParameter((Object)lspServerNotificationsHandlerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)applyWorkspaceEditParams, (String)"$params");
        Object object = new CodeAction("workspace/applyEdit");
        CodeAction codeAction = object;
        boolean bl = false;
        codeAction.setEdit(applyWorkspaceEditParams.getEdit());
        CodeAction codeAction2 = object;
        object = new LspIntentionAction(lspServerNotificationsHandlerImpl.lspServer, codeAction2);
        return ((LspIntentionAction)object).isAvailable() ? object : null;
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ LspServerImpl access$getLspServer$p(LspServerNotificationsHandlerImpl $this) {
        return $this.lspServer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl$Companion;", "", "()V", "LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP", "", "LOG_INFO_TRACE_NOTIFICATION_GROUP", "SHOW_MESSAGE_NOTIFICATION_GROUP", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Log.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

