/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.requests.LspClientNotification;
import com.intellij.platform.lsp.api.requests.LspRequest;
import com.intellij.platform.lsp.api.requests.LspRequestExecutor;
import com.intellij.platform.lsp.impl.LspRequestExecutorImpl;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.impl.completion.LspCompletionUtilKt;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0001OB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u00a2\u0006\u0002\u0010\u0013Jr\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122K\u0010\u0019\u001aG\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b( \u0012\u0004\u0012\u0002H\u00150\u001aH\u0003\u00a2\u0006\u0002\u0010!J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0002J6\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H'\u0018\u00010&\"\u0004\b\u0000\u0010'2\u001c\u0010(\u001a\u0018\u0012\b\u0012\u00060*j\u0002`+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0&0)H\u0002JL\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H'\u0018\u00010&\"\u0004\b\u0000\u0010'2\u001c\u0010(\u001a\u0018\u0012\b\u0012\u00060*j\u0002`+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0&0)2\u0014\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H'\u0012\u0004\u0012\u00020.0)H\u0002J\"\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0007J(\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0007J\u0010\u00102\u001a\u0002032\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0007J$\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0014\u00109\u001a\u00020.2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030&H\u0002J%\u0010;\u001a\u00020.2\u0016\u0010(\u001a\u0012\u0012\b\u0012\u00060*j\u0002`+\u0012\u0004\u0012\u00020.0)H\u0000\u00a2\u0006\u0002\b<J\u0010\u0010;\u001a\u00020.2\u0006\u0010=\u001a\u00020>H\u0017J6\u0010?\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u001c\u0010(\u001a\u0018\u0012\b\u0012\u00060*j\u0002`+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0&0)H\u0080@\u00a2\u0006\u0004\b@\u0010AJ>\u0010B\u001a\u00020.\"\u0004\b\u0000\u0010'\"\u0004\b\u0001\u0010C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002HC0E2\u0014\u0010F\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001HC\u0012\u0004\u0012\u00020.0)H\u0017JG\u0010G\u001a\u00020.\"\u0004\b\u0000\u0010'2\u001c\u0010(\u001a\u0018\u0012\b\u0012\u00060*j\u0002`+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0&0)2\u0014\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H'\u0012\u0004\u0012\u00020.0)H\u0000\u00a2\u0006\u0002\bHJ/\u0010I\u001a\u0004\u0018\u0001HC\"\u0004\b\u0000\u0010'\"\u0004\b\u0001\u0010C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002HC0EH\u0017\u00a2\u0006\u0002\u0010JJ?\u0010I\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u001c\u0010(\u001a\u0018\u0012\b\u0012\u00060*j\u0002`+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0&0)H\u0001\u00a2\u0006\u0004\bK\u0010LJ\r\u0010M\u001a\u00020.H\u0000\u00a2\u0006\u0002\bNR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "Lcom/intellij/platform/lsp/api/requests/LspRequestExecutor;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "hoverResultCache", "Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "j", "T", "future", "Ljava/util/concurrent/Future;", "cancelOnPCE", "", "debugName", "", "timeoutMs", "", "(Ljava/util/concurrent/Future;ZLjava/lang/String;I)Ljava/lang/Object;", "j", "Lsp4jParams", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "lsp4jParamsCreator", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "hostFile", "Lcom/intellij/openapi/editor/Document;", "hostDocument", "hostOffset", "(Lcom/intellij/openapi/vfs/VirtualFile;ILkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "j", "Lorg/eclipse/lsp4j/CompletionParams;", "isAutoPopup", "j", "Ljava/util/concurrent/CompletableFuture;", "Lsp4jResponse", "lsp4jSender", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "j", "lsp4jResponseConsumer", "", "getCompletionList", "Lorg/eclipse/lsp4j/CompletionList;", "getCompletionListAsync", "getDocumentIdentifier", "Lorg/eclipse/lsp4j/TextDocumentIdentifier;", "getElementDefinitions", "", "Lorg/eclipse/lsp4j/LocationLink;", "getHoverInformation", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "j", "lsp4jResponseFuture", "sendNotification", "sendNotification$intellij_platform_lsp_impl", "notification", "Lcom/intellij/platform/lsp/api/requests/LspClientNotification;", "sendRequest", "sendRequest$intellij_platform_lsp_impl", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequestAsync", "Result", "lspRequest", "Lcom/intellij/platform/lsp/api/requests/LspRequest;", "resultConsumer", "sendRequestAsyncButWaitForResponseWithCheckCanceled", "sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl", "sendRequestSync", "(Lcom/intellij/platform/lsp/api/requests/LspRequest;)Ljava/lang/Object;", "sendRequestSync$intellij_platform_lsp_impl", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "shutdownNow", "shutdownNow$intellij_platform_lsp_impl", "HoverResultCache", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,385:1\n1#2:386\n1549#3:387\n1620#3,3:388\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n*L\n297#1:387\n297#1:388,3\n*E\n"})
public final class LspRequestExecutorImpl
implements LspRequestExecutor {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final HoverResultCache hoverResultCache;

    public LspRequestExecutorImpl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("LSP Executor: " + this.lspServer.getDescriptor()), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executorService = executorService;
        this.hoverResultCache = new HoverResultCache();
    }

    @Override
    @Deprecated(message="Use LspServer.getDocumentIdentifier")
    @NotNull
    public TextDocumentIdentifier getDocumentIdentifier(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.lspServer.getDocumentIdentifier(file2);
    }

    @Override
    @Deprecated(message="Use LspServer.sendNotification", replaceWith=@ReplaceWith(expression="lspServer.sendNotification { it.foo(params) }", imports={}))
    public void sendNotification(@NotNull LspClientNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.sendNotification$intellij_platform_lsp_impl((Function1<? super LanguageServer, Unit>)((Function1)new Function1<LanguageServer, Unit>(notification){
            final /* synthetic */ LspClientNotification $notification;
            {
                this.$notification = $notification;
                super(1);
            }

            public final void invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$notification.sendNotification();
            }
        }));
    }

    @Override
    @Deprecated(message="Use LspServer.sendRequest")
    public <Lsp4jResponse, Result> void sendRequestAsync(@NotNull LspRequest<Lsp4jResponse, Result> lspRequest, @NotNull Function1<? super Result, Unit> resultConsumer) {
        Intrinsics.checkNotNullParameter(lspRequest, (String)"lspRequest");
        Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
        this.j((Function1)new Function1<LanguageServer, CompletableFuture<Lsp4jResponse>>(lspRequest){
            final /* synthetic */ LspRequest<Lsp4jResponse, Result> $lspRequest;
            {
                this.$lspRequest = $lspRequest;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Lsp4jResponse> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$lspRequest.sendRequest();
            }
        }, (Function1)new Function1<Lsp4jResponse, Unit>(resultConsumer, lspRequest){
            final /* synthetic */ Function1<Result, Unit> $resultConsumer;
            final /* synthetic */ LspRequest<Lsp4jResponse, Result> $lspRequest;
            {
                this.$resultConsumer = $resultConsumer;
                this.$lspRequest = $lspRequest;
                super(1);
            }

            public final void invoke(@Nullable Lsp4jResponse lsp4jResponse2) {
                Object v22;
                Function1<Result, Unit> function1 = this.$resultConsumer;
                Lsp4jResponse Lsp4jResponse = lsp4jResponse2;
                if (Lsp4jResponse != null) {
                    Lsp4jResponse Lsp4jResponse2 = Lsp4jResponse;
                    LspRequest<Lsp4jResponse, Result> lspRequest = this.$lspRequest;
                    Lsp4jResponse Lsp4jResponse3 = Lsp4jResponse2;
                    Function1<Result, Unit> function12 = function1;
                    boolean bl = false;
                    v22 = lspRequest.preprocessResponse(Lsp4jResponse3);
                    function1 = function12;
                } else {
                    v22 = null;
                }
                function1.invoke(v22);
            }
        });
    }

    @Override
    @Deprecated(message="Use LspServer.sendRequest")
    @RequiresBackgroundThread
    @Nullable
    public <Lsp4jResponse, Result> Result sendRequestSync(@NotNull LspRequest<Lsp4jResponse, Result> lspRequest) {
        Result Result2;
        Object object;
        Intrinsics.checkNotNullParameter(lspRequest, (String)"lspRequest");
        Object object2 = object = LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, new Function1<LanguageServer, CompletableFuture<Lsp4jResponse>>(lspRequest){
            final /* synthetic */ LspRequest<Lsp4jResponse, Result> $lspRequest;
            {
                this.$lspRequest = $lspRequest;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Lsp4jResponse> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$lspRequest.sendRequest();
            }
        }, 1, null);
        if (object2 != null) {
            Object object3 = object2;
            boolean bl = false;
            Result2 = lspRequest.preprocessResponse(object3);
        } else {
            Result2 = null;
        }
        return Result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendNotification$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, Unit> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.j(lsp4jSender, this));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final <Lsp4jResponse> Object sendRequest$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Continuation<? super Lsp4jResponse> $completion) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.j(lsp4jSender);
        if (completableFuture == null) {
            return null;
        }
        CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
        return FutureKt.await((CompletionStage)completableFuture2, $completion);
    }

    @RequiresBackgroundThread
    @Nullable
    public final <Lsp4jResponse> Lsp4jResponse sendRequestSync$intellij_platform_lsp_impl(int timeoutMs, @NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender) {
        Lsp4jResponse Lsp4jResponse;
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        CompletableFuture<Lsp4jResponse> completableFuture = this.j(lsp4jSender);
        if (completableFuture != null) {
            CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl = false;
            Future future2 = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Lsp4jResponse = (Lsp4jResponse)this.j(future2, true, string, timeoutMs);
        } else {
            Lsp4jResponse = null;
        }
        return Lsp4jResponse;
    }

    public static /* synthetic */ Object sendRequestSync$intellij_platform_lsp_impl$default(LspRequestExecutorImpl lspRequestExecutorImpl, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 10000;
        }
        return lspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl(n2, function1);
    }

    public final <Lsp4jResponse> void sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Function1<? super Lsp4jResponse, Unit> lsp4jResponseConsumer) {
        block0: {
            Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
            Intrinsics.checkNotNullParameter(lsp4jResponseConsumer, (String)"lsp4jResponseConsumer");
            CompletableFuture<? super Lsp4jResponse> completableFuture = this.j(lsp4jSender, lsp4jResponseConsumer);
            if (completableFuture == null) break block0;
            CompletableFuture<? super Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl = false;
            Future future2 = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.j(future2, false, string, 10000);
        }
    }

    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> j(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1, Function1<? super Lsp4jResponse, Unit> function12) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.j(function1);
        if (completableFuture == null) {
            function12.invoke(null);
            return null;
        }
        completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.w((Function2)new Function2<Lsp4jResponse, Throwable, Unit>(function12){
            final /* synthetic */ Function1<Lsp4jResponse, Unit> $lsp4jResponseConsumer;
            {
                this.$lsp4jResponseConsumer = $lsp4jResponseConsumer;
                super(2);
            }

            public final void invoke(@Nullable Lsp4jResponse result2, @Nullable Throwable throwable) {
                this.$lsp4jResponseConsumer.invoke(result2);
            }
        }, arg_0, arg_1));
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> j(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1) {
        if (this.lspServer.getState() != LspServerState.Running) {
            this.lspServer.logDebug$intellij_platform_lsp_impl("Server not initialized yet, skipping request " + function1.getClass().getName());
            return null;
        }
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            block5: {
                boolean bl = false;
                if (!this.executorService.isShutdown()) break block5;
                CompletableFuture<Lsp4jResponse> completableFuture = null;
                return completableFuture;
            }
            CompletableFuture completableFuture = new CompletableFuture();
            this.executorService.execute(() -> LspRequestExecutorImpl.j(function1, this, completableFuture));
            CompletableFuture completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(CompletableFuture<?> completableFuture) {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.N(completableFuture));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @RequiresBackgroundThread
    private final <T> T j(Future<T> future2, boolean bl, String string, int n2) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < (long)n2) {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException processCanceledException) {
                if (bl) {
                    future2.cancel(true);
                }
                throw processCanceledException;
            }
            try {
                return future2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException executionException) {
                LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this.lspServer, "Error response from server: " + executionException.getCause(), null, 2, null);
                return null;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("No response from the server in " + n2 + "ms for: " + string);
        future2.cancel(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownNow$intellij_platform_lsp_impl() {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            List<Runnable> list = this.executorService.shutdownNow();
        }
        this.hoverResultCache.clearCache();
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private final <Lsp4jParams> Lsp4jParams j(VirtualFile virtualFile2, int n2, Function3<? super VirtualFile, ? super Document, ? super Integer, ? extends Lsp4jParams> function3) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            Lsp4jParams Lsp4jParams;
            Lsp4jParams Lsp4jParams2 = Lsp4jParams = null;
            boolean bl = false;
            this.lspServer.logError$intellij_platform_lsp_impl("No document for file " + virtualFile2);
            return Lsp4jParams;
        }
        Document document2 = document;
        VirtualFileWindow virtualFileWindow = virtualFile2 instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile2 : null;
        if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
            virtualFileWindow = virtualFile2;
        }
        VirtualFileWindow virtualFileWindow2 = virtualFileWindow;
        Intrinsics.checkNotNull((Object)virtualFileWindow2);
        VirtualFileWindow virtualFileWindow3 = virtualFileWindow2;
        DocumentWindow documentWindow = document2 instanceof DocumentWindow ? (DocumentWindow)document2 : null;
        if (documentWindow == null || (documentWindow = documentWindow.getDelegate()) == null) {
            documentWindow = document2;
        }
        virtualFileWindow2 = documentWindow;
        DocumentWindow documentWindow2 = document2 instanceof DocumentWindow ? (DocumentWindow)document2 : null;
        int n3 = documentWindow2 != null ? documentWindow2.injectedToHost(n2) : n2;
        return (Lsp4jParams)function3.invoke((Object)virtualFileWindow3, (Object)virtualFileWindow2, (Object)n3);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final CompletionList getCompletionList(@NotNull VirtualFile file2, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CompletionParams completionParams = this.j(file2, offset, isAutoPopup);
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, (Function1)new Function1<LanguageServer, CompletableFuture<Either<List<CompletionItem>, CompletionList>>>(completionParams){
            final /* synthetic */ CompletionParams $params;
            {
                this.$params = $params;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Either<List<CompletionItem>, CompletionList>> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFuture completableFuture = it.getTextDocumentService().completion(this.$params);
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
                return completableFuture;
            }
        }, 1, null);
        if (either == null) {
            return null;
        }
        Either either2 = either;
        return LspCompletionUtilKt.asCompletionList((Either<List<CompletionItem>, CompletionList>)either2);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final CompletableFuture<CompletionList> getCompletionListAsync(@NotNull VirtualFile file2, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CompletionParams completionParams = this.j(file2, offset, isAutoPopup);
        CompletableFuture<Object> completableFuture = this.j((Function1)new Function1<LanguageServer, CompletableFuture<Either<List<CompletionItem>, CompletionList>>>(completionParams){
            final /* synthetic */ CompletionParams $params;
            {
                this.$params = $params;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Either<List<CompletionItem>, CompletionList>> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFuture completableFuture = it.getTextDocumentService().completion(this.$params);
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
                return completableFuture;
            }
        });
        if (completableFuture == null) {
            completableFuture = CompletableFuture.completedFuture(null);
        }
        CompletableFuture completableFuture2 = completableFuture;
        CompletionStage completionStage = completableFuture2.thenApply(arg_0 -> LspRequestExecutorImpl.j(getCompletionListAsync.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final CompletionParams j(VirtualFile virtualFile2, int n2, boolean bl) {
        return (CompletionParams)this.j(virtualFile2, n2, (Function3)new Function3<VirtualFile, Document, Integer, CompletionParams>(this, bl){
            final /* synthetic */ LspRequestExecutorImpl this$0;
            final /* synthetic */ boolean $isAutoPopup;
            {
                this.this$0 = $receiver;
                this.$isAutoPopup = $isAutoPopup;
                super(3);
            }

            @NotNull
            public final CompletionParams invoke(@NotNull VirtualFile hostFile, @NotNull Document hostDocument, int hostOffset) {
                Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
                Intrinsics.checkNotNullParameter((Object)hostDocument, (String)"hostDocument");
                return LspCompletionUtilKt.createCompletionParams(LspRequestExecutorImpl.access$getLspServer$p(this.this$0), hostFile, hostDocument, hostOffset, this.$isAutoPopup);
            }
        });
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final List<LocationLink> getElementDefinitions(@NotNull VirtualFile file2, int offset) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        DefinitionParams definitionParams = (DefinitionParams)this.j(file2, offset, (Function3)new Function3<VirtualFile, Document, Integer, DefinitionParams>(this){
            final /* synthetic */ LspRequestExecutorImpl this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final DefinitionParams invoke(@NotNull VirtualFile hostFile, @NotNull Document hostDocument, int hostOffset) {
                Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
                Intrinsics.checkNotNullParameter((Object)hostDocument, (String)"hostDocument");
                return new DefinitionParams(LspRequestExecutorImpl.access$getLspServer$p(this.this$0).getDocumentIdentifier(hostFile), Lsp4jUtilKt.getLsp4jPosition(hostDocument, hostOffset));
            }
        });
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, (Function1)new Function1<LanguageServer, CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>>>(definitionParams){
            final /* synthetic */ DefinitionParams $params;
            {
                this.$params = $params;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFuture completableFuture = it.getTextDocumentService().definition(this.$params);
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"definition(...)");
                return completableFuture;
            }
        }, 1, null);
        if (either == null) {
            return CollectionsKt.emptyList();
        }
        Either either2 = either;
        if (either2.isRight()) {
            Object object = either2.getRight();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
            list = CollectionsKt.distinct((Iterable)((Iterable)object));
        } else {
            Object object = either2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t10 : iterable2) {
                Location location = (Location)t10;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new LocationLink(location.getUri(), location.getRange(), location.getRange()));
            }
            list = CollectionsKt.distinct((Iterable)((List)collection));
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file2, int offset, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.hoverResultCache.getHoverInformation(file2, offset, timeoutMs);
    }

    public static /* synthetic */ TextRangeAndMarkupContent getHoverInformation$default(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile2, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 10000;
        }
        return lspRequestExecutorImpl.getHoverInformation(virtualFile2, n2, n3);
    }

    private static final void j(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$lsp4jSender");
        Intrinsics.checkNotNullParameter((Object)lspRequestExecutorImpl, (String)"this$0");
        function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer());
    }

    private static final void w(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        function2.invoke(object, object2);
    }

    private static final void N(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        function2.invoke(object, object2);
    }

    private static final void j(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        function2.invoke(object, object2);
    }

    private static final void j(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl, CompletableFuture completableFuture) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$lsp4jSender");
        Intrinsics.checkNotNullParameter((Object)lspRequestExecutorImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)completableFuture, (String)"$resultFuture");
        CompletableFuture completableFuture2 = (CompletableFuture)function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer());
        completableFuture2.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.N((Function2)new Function2<Lsp4jResponse, Throwable, Unit>(completableFuture){
            final /* synthetic */ CompletableFuture<Lsp4jResponse> $resultFuture;
            {
                this.$resultFuture = $resultFuture;
                super(2);
            }

            public final void invoke(@Nullable Lsp4jResponse lsp4jResponse2, @Nullable Throwable th2) {
                if (th2 == null) {
                    this.$resultFuture.complete(lsp4jResponse2);
                } else {
                    this.$resultFuture.completeExceptionally(th2);
                }
            }
        }, arg_0, arg_1));
        completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.j((Function2)new Function2<Lsp4jResponse, Throwable, Unit>(completableFuture, lspRequestExecutorImpl, completableFuture2){
            final /* synthetic */ CompletableFuture<Lsp4jResponse> $resultFuture;
            final /* synthetic */ LspRequestExecutorImpl this$0;
            final /* synthetic */ CompletableFuture<Lsp4jResponse> $lsp4jResponseFuture;
            {
                this.$resultFuture = $resultFuture;
                this.this$0 = $receiver;
                this.$lsp4jResponseFuture = $lsp4jResponseFuture;
                super(2);
            }

            public final void invoke(@Nullable Lsp4jResponse Lsp4jResponse, Throwable throwable) {
                if (this.$resultFuture.isCancelled()) {
                    LspRequestExecutorImpl.access$sendCancelRequest(this.this$0, this.$lsp4jResponseFuture);
                }
            }
        }, arg_0, arg_1));
    }

    private static final void N(CompletableFuture completableFuture) {
        Intrinsics.checkNotNullParameter((Object)completableFuture, (String)"$lsp4jResponseFuture");
        completableFuture.cancel(true);
    }

    private static final CompletionList j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (CompletionList)function1.invoke(object);
    }

    public static final /* synthetic */ void access$sendCancelRequest(LspRequestExecutorImpl $this, CompletableFuture lsp4jResponseFuture) {
        $this.j(lsp4jResponseFuture);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "", "(Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;)V", "lastFilePath", "", "lastPsiModificationCount", "", "lastResult", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "clearCache", "", "getHoverInformation", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "timeoutMs", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,385:1\n23#2:386\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n*L\n322#1:386\n*E\n"})
    private final class HoverResultCache {
        @Nullable
        private TextRangeAndMarkupContent lastResult;
        private long lastPsiModificationCount = -1L;
        @NotNull
        private String lastFilePath = "";

        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final synchronized TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file2, int offset, int timeoutMs) {
            TextRangeAndMarkupContent textRangeAndMarkupContent;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            ProgressManager.checkCanceled();
            if (file2 instanceof VirtualFileWindow) {
                HoverResultCache hoverResultCache = this;
                boolean bl = false;
                Logger logger = Logger.getInstance(HoverResultCache.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("VirtualFileWindow not expected here");
                return null;
            }
            Project project2 = LspRequestExecutorImpl.this.lspServer.getProject();
            TextRangeAndMarkupContent textRangeAndMarkupContent2 = this.lastResult;
            long l2 = PsiManager.getInstance((Project)project2).getModificationTracker().getModificationCount();
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            if (textRangeAndMarkupContent2 != null && this.lastPsiModificationCount == l2 && Intrinsics.areEqual((Object)this.lastFilePath, (Object)string2) && textRangeAndMarkupContent2.getTextRange().contains(offset)) {
                return textRangeAndMarkupContent2;
            }
            HoverParams hoverParams = (HoverParams)LspRequestExecutorImpl.this.j(file2, offset, (Function3)new Function3<VirtualFile, Document, Integer, HoverParams>(LspRequestExecutorImpl.this){
                final /* synthetic */ LspRequestExecutorImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                @NotNull
                public final HoverParams invoke(@NotNull VirtualFile hostFile, @NotNull Document hostDocument, int hostOffset) {
                    Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
                    Intrinsics.checkNotNullParameter((Object)hostDocument, (String)"hostDocument");
                    return new HoverParams(LspRequestExecutorImpl.access$getLspServer$p(this.this$0).getDocumentIdentifier(hostFile), Lsp4jUtilKt.getLsp4jPosition(hostDocument, hostOffset));
                }
            });
            Hover hover2 = (Hover)LspRequestExecutorImpl.this.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, (Function1)new Function1<LanguageServer, CompletableFuture<Hover>>(hoverParams){
                final /* synthetic */ HoverParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<Hover> invoke(@NotNull LanguageServer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    CompletableFuture completableFuture = it.getTextDocumentService().hover(this.$params);
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"hover(...)");
                    return completableFuture;
                }
            });
            if (hover2 == null) {
                return null;
            }
            Hover hover3 = hover2;
            this.lastResult = textRangeAndMarkupContent = TextRangeAndMarkupContent.Companion.fromHover$intellij_platform_lsp_impl(hover3, file2, offset);
            this.lastPsiModificationCount = l2;
            this.lastFilePath = string2;
            return textRangeAndMarkupContent;
        }

        public final void clearCache() {
            this.lastResult = null;
            this.lastPsiModificationCount = -1L;
            this.lastFilePath = "";
        }
    }
}

