/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "()V", "beforeDocumentSaving", "", "document", "Lcom/intellij/openapi/editor/Document;", "unsavedDocumentDropped", "intellij.platform.lsp.impl"})
public final class LspFileDocumentManagerListener
implements FileDocumentManagerListener {
    public void unsavedDocumentDropped(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.beforeDocumentSaving(document);
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!virtualFile3.isInLocalFileSystem()) {
            return;
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            if (FileEditorManager.getInstance((Project)project2).isFileOpen(virtualFile3)) continue;
            Intrinsics.checkNotNull((Object)project2);
            LspServerManagerImpl.Companion.getInstanceImpl(project2).scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl();
        }
    }
}

