/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspDidChangeUtil;
import com.intellij.platform.lsp.impl.LspDocumentListener;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/lsp/impl/LspDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "()V", "documentsToHandle", "", "Lcom/intellij/openapi/editor/Document;", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "j", "ChangedFilesData", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDocumentListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDocumentListener.kt\ncom/intellij/platform/lsp/impl/LspDocumentListener\n+ 2 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n331#2:173\n332#2:175\n333#2,2:177\n335#2:180\n331#2:182\n332#2:184\n333#2,2:186\n335#2:189\n13309#3:174\n13310#3:181\n13309#3:183\n13310#3:190\n1855#4:176\n1856#4:179\n1855#4:185\n1856#4:188\n*S KotlinDebug\n*F\n+ 1 LspDocumentListener.kt\ncom/intellij/platform/lsp/impl/LspDocumentListener\n*L\n44#1:173\n44#1:175\n44#1:177,2\n44#1:180\n78#1:182\n78#1:184\n78#1:186,2\n78#1:189\n44#1:174\n44#1:181\n78#1:183\n78#1:190\n44#1:176\n44#1:179\n78#1:185\n78#1:188\n*E\n"})
public final class LspDocumentListener
implements DocumentListener {
    @NotNull
    private final Set<Document> documentsToHandle;

    public LspDocumentListener() {
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.documentsToHandle = set;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile2 = LspDidChangeUtil.INSTANCE.getFileToHandle(event);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        LspServerManagerImpl.Companion companion = LspServerManagerImpl.Companion;
        boolean bl = false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = false;
        for (Object object : objectArray) {
            Project project2 = (Project)object;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)project2);
            Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project2));
            boolean bl4 = false;
            for (Object t10 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t10;
                boolean bl5 = false;
                if (lspServerImpl.getState() != LspServerState.Running) continue;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl6 = false;
                lspServerImpl2.fileEdited$intellij_platform_lsp_impl(virtualFile3, event);
                if (lspServerImpl2.getTextDocumentSyncKind$intellij_platform_lsp_impl() != TextDocumentSyncKind.Incremental || !lspServerImpl2.isFileOpened$intellij_platform_lsp_impl(virtualFile3)) continue;
                DidChangeTextDocumentParams didChangeTextDocumentParams = LspDidChangeUtil.INSTANCE.createIncrementalDidChangeParamsBeforeDocumentChange(lspServerImpl2, event, virtualFile3);
                lspServerImpl2.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)new Function1<LanguageServer, Unit>(didChangeTextDocumentParams){
                    final /* synthetic */ DidChangeTextDocumentParams $params;
                    {
                        this.$params = $params;
                        super(1);
                    }

                    public final void invoke(@NotNull LanguageServer it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getTextDocumentService().didChange(this.$params);
                    }
                }));
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (LspDidChangeUtil.INSTANCE.getFileToHandle(event) == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument())) {
            return;
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.documentsToHandle.add(document);
        this.j();
    }

    private final void j() {
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> LspDocumentListener.j(this)).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspDocumentListener.j((Function1)new Function1<ChangedFilesData, Unit>(this){
            final /* synthetic */ LspDocumentListener this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ChangedFilesData data2) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                LspDocumentListener.access$getDocumentsToHandle$p(this.this$0).removeAll((Collection)data2.getHandledDocuments());
                if (data2.getServersToSendDidOpen().isEmpty() && data2.getServersToSendDidChange().isEmpty()) {
                    return;
                }
                WriteAction.run(() -> scheduleEventsProcessing.2.j(data2));
            }

            private static final void j(ChangedFilesData changedFilesData) {
                boolean bl;
                Pair pair2;
                Intrinsics.checkNotNullParameter((Object)changedFilesData, (String)"$data");
                Iterable iterable = changedFilesData.getServersToSendDidOpen();
                boolean bl2 = false;
                for (T t10 : iterable) {
                    pair2 = (Pair)t10;
                    bl = false;
                    ((LspServerImpl)pair2.getFirst()).sendDidOpenRequest$intellij_platform_lsp_impl((VirtualFile)pair2.getSecond());
                }
                iterable = changedFilesData.getServersToSendDidChange();
                bl2 = false;
                for (T t10 : iterable) {
                    pair2 = (Pair)t10;
                    bl = false;
                    ((LspServerImpl)pair2.getFirst()).sendNotification((Function1<? super LanguageServer, Unit>)((Function1)new Function1<LanguageServer, Unit>((Pair<LspServerImpl, ? extends DidChangeTextDocumentParams>)pair2){
                        final /* synthetic */ Pair<LspServerImpl, DidChangeTextDocumentParams> $serverAndParams;
                        {
                            this.$serverAndParams = $serverAndParams;
                            super(1);
                        }

                        public final void invoke(@NotNull LanguageServer it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            it.getTextDocumentService().didChange((DidChangeTextDocumentParams)this.$serverAndParams.getSecond());
                        }
                    }));
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ChangedFilesData j(LspDocumentListener lspDocumentListener) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lspDocumentListener, (String)"this$0");
        ChangedFilesData changedFilesData = new ChangedFilesData();
        Object object = lspDocumentListener.documentsToHandle;
        synchronized (object) {
            bl = false;
            bl = changedFilesData.getHandledDocuments().addAll((Collection<Document>)lspDocumentListener.documentsToHandle);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        object = LspServerManagerImpl.Companion;
        bl = false;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = false;
        for (Object object2 : objectArray) {
            Project project2 = (Project)object2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)project2);
            Iterable iterable = LspServerManagerImpl.access$getLspServers$p(LspServerManagerImpl.Companion.getInstanceImpl(project2));
            boolean bl4 = false;
            for (Object t10 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t10;
                boolean bl5 = false;
                if (lspServerImpl.getState() != LspServerState.Running) continue;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl6 = false;
                for (Document document : changedFilesData.getHandledDocuments()) {
                    VirtualFile virtualFile2;
                    ProgressManager.checkCanceled();
                    if (!fileDocumentManager2.isDocumentUnsaved(document) || fileDocumentManager2.getFile(document) == null) continue;
                    Intrinsics.checkNotNull((Object)virtualFile2);
                    VirtualFile virtualFile3 = virtualFile2;
                    if (!virtualFile3.isInLocalFileSystem()) continue;
                    if (lspServerImpl2.isFileOpened$intellij_platform_lsp_impl(virtualFile3)) {
                        if (lspServerImpl2.getTextDocumentSyncKind$intellij_platform_lsp_impl() != TextDocumentSyncKind.Full) continue;
                        changedFilesData.getServersToSendDidChange().add((Pair<LspServerImpl, DidChangeTextDocumentParams>)TuplesKt.to((Object)lspServerImpl2, (Object)LspDidChangeUtil.INSTANCE.createFullDidChangeParams$intellij_platform_lsp_impl(lspServerImpl2, document, virtualFile3)));
                        continue;
                    }
                    if (!lspServerImpl2.isSupportedFile$intellij_platform_lsp_impl(virtualFile3)) continue;
                    changedFilesData.getServersToSendDidOpen().add((Pair<LspServerImpl, VirtualFile>)TuplesKt.to((Object)lspServerImpl2, (Object)virtualFile3));
                }
            }
        }
        return changedFilesData;
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ Set access$getDocumentsToHandle$p(LspDocumentListener $this) {
        return $this.documentsToHandle;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lsp/impl/LspDocumentListener$ChangedFilesData;", "", "()V", "handledDocuments", "", "Lcom/intellij/openapi/editor/Document;", "getHandledDocuments", "()Ljava/util/Set;", "serversToSendDidChange", "", "Lkotlin/Pair;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lorg/eclipse/lsp4j/DidChangeTextDocumentParams;", "getServersToSendDidChange", "()Ljava/util/Collection;", "serversToSendDidOpen", "Lcom/intellij/openapi/vfs/VirtualFile;", "getServersToSendDidOpen", "intellij.platform.lsp.impl"})
    private static final class ChangedFilesData {
        @NotNull
        private final Set<Document> handledDocuments = new HashSet();
        @NotNull
        private final Collection<Pair<LspServerImpl, DidChangeTextDocumentParams>> serversToSendDidChange = new ArrayList();
        @NotNull
        private final Collection<Pair<LspServerImpl, VirtualFile>> serversToSendDidOpen = new ArrayList();

        @NotNull
        public final Set<Document> getHandledDocuments() {
            return this.handledDocuments;
        }

        @NotNull
        public final Collection<Pair<LspServerImpl, DidChangeTextDocumentParams>> getServersToSendDidChange() {
            return this.serversToSendDidChange;
        }

        @NotNull
        public final Collection<Pair<LspServerImpl, VirtualFile>> getServersToSendDidOpen() {
            return this.serversToSendDidOpen;
        }
    }
}

