/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.impl.LspDiagnosticsCache;
import com.intellij.platform.lsp.impl.LspDiagnosticsCacheKt;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.quickFix.LspQuickFixSet;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001f\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u001e\u0010 \u001a\u00020\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/lsp/impl/LspDiagnosticsCache;", "", "()V", "filePathToPendingDocEdits", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/platform/lsp/impl/LspDiagnosticsCache$DocEdit;", "filePathToUri", "Lcom/intellij/util/containers/BidirectionalMap;", "uriToDiagnostics", "", "", "Lcom/intellij/platform/lsp/impl/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes;", "clearCache", "", "clearCache$intellij_platform_lsp_impl", "diagnosticsReceived", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "params", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "diagnosticsReceived$intellij_platform_lsp_impl", "fileEdited", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "fileEdited$intellij_platform_lsp_impl", "getDiagnostics", "getDiagnostics$intellij_platform_lsp_impl", "j", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnostic", "docEdit", "j", "diagnostics", "", "DiagnosticAndLazyQuickFixes", "DocEdit", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDiagnosticsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/LspDiagnosticsCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,169:1\n1#2:170\n1549#3:171\n1620#3,3:172\n23#4:175\n*S KotlinDebug\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/LspDiagnosticsCache\n*L\n61#1:171\n61#1:172,3\n70#1:175\n*E\n"})
public final class LspDiagnosticsCache {
    @NotNull
    private final Map<String, List<DiagnosticAndLazyQuickFixes>> uriToDiagnostics;
    @NotNull
    private final BidirectionalMap<String, String> filePathToUri;
    @NotNull
    private final MultiMap<String, DocEdit> filePathToPendingDocEdits;

    public LspDiagnosticsCache() {
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.uriToDiagnostics = map;
        this.filePathToUri = new BidirectionalMap();
        this.filePathToPendingDocEdits = new MultiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void diagnosticsReceived$intellij_platform_lsp_impl(@Nullable VirtualFile file2, @NotNull PublishDiagnosticsParams params2) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            Collection collection;
            boolean bl = false;
            if (params2.getDiagnostics().isEmpty()) {
                this.uriToDiagnostics.remove(params2.getUri());
                this.filePathToUri.removeValue((Object)params2.getUri());
                VirtualFile virtualFile2 = file2;
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl2 = false;
                    collection = this.filePathToPendingDocEdits.remove((Object)file2.getPath());
                } else {
                    collection = null;
                }
            } else {
                Object object = this.uriToDiagnostics;
                String string = params2.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
                String string2 = string;
                List list = params2.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDiagnostics(...)");
                Iterable iterable = list;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl4 = false;
                for (Object t10 : iterable2) {
                    Diagnostic diagnostic = (Diagnostic)t10;
                    Collection collection3 = collection2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)diagnostic);
                    collection3.add(new DiagnosticAndLazyQuickFixes(diagnostic));
                }
                iterable = (List)collection2;
                object.put((String)string2, (List<DiagnosticAndLazyQuickFixes>)iterable);
                if (file2 != null) {
                    ((Map)this.filePathToUri).put(file2.getPath(), params2.getUri());
                    collection = this.filePathToPendingDocEdits.remove((Object)file2.getPath());
                } else {
                    this.filePathToUri.removeValue((Object)params2.getUri());
                    object = this;
                    boolean bl6 = false;
                    Logger logger = Logger.getInstance(LspDiagnosticsCache.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Could not find file with diagnostics: " + params2.getUri());
                    collection = Unit.INSTANCE;
                }
            }
            Collection collection4 = collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fileEdited$intellij_platform_lsp_impl(@NotNull VirtualFile file2, @NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            boolean bl = false;
            if (this.filePathToUri.get((Object)file2.getPath()) != null) {
                int n2;
                int n3 = e2.getDocument().getLineNumber(e2.getOffset());
                int n4 = e2.getOffset() - e2.getDocument().getLineStartOffset(n3);
                int n5 = e2.getDocument().getLineNumber(e2.getOffset() + e2.getOldLength());
                int n6 = e2.getOffset() + e2.getOldLength() - e2.getDocument().getLineStartOffset(n5);
                int n7 = Strings.countChars((CharSequence)e2.getOldFragment(), (char)'\n');
                int n8 = Strings.countChars((CharSequence)e2.getNewFragment(), (char)'\n');
                int n9 = n8 - n7;
                int n10 = n5 + n9;
                if (n8 == 0) {
                    n2 = n4 + e2.getNewLength();
                } else {
                    int n11 = e2.getNewLength();
                    CharSequence charSequence = e2.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    n2 = n11 - StringsKt.lastIndexOf$default((CharSequence)charSequence, (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
                int n12 = n2;
                this.filePathToPendingDocEdits.putValue((Object)file2.getPath(), (Object)new DocEdit(new Position(n3, n4), new Position(n5, n6), new Position(n10, n12)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @NotNull
    public final List<DiagnosticAndLazyQuickFixes> getDiagnostics$intellij_platform_lsp_impl(@NotNull VirtualFile file2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            Collection collection;
            boolean bl = false;
            String string = (String)this.filePathToUri.get((Object)file2.getPath());
            if (string == null) {
                collection = CollectionsKt.emptyList();
            } else {
                Collection collection2;
                Collection collection3;
                List list2 = this.uriToDiagnostics.get(string);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List list3 = list2;
                Collection collection4 = collection3 = this.filePathToPendingDocEdits.remove((Object)file2.getPath());
                if (collection4 == null) {
                    v3 = CollectionsKt.emptyList();
                } else {
                    Intrinsics.checkNotNull((Object)collection4);
                    v3 = collection2 = collection3;
                }
                if (list3.isEmpty() || collection2.isEmpty()) {
                    collection = list3;
                } else {
                    collection3 = CollectionsKt.toMutableList((Collection)list3);
                    for (DocEdit docEdit : collection2) {
                        ProgressManager.checkCanceled();
                        Intrinsics.checkNotNull((Object)docEdit);
                        this.j((List<DiagnosticAndLazyQuickFixes>)collection3, docEdit);
                    }
                    this.uriToDiagnostics.put(string, (List<DiagnosticAndLazyQuickFixes>)collection3);
                    collection = collection3;
                }
            }
            list = collection;
        }
        return list;
    }

    private final void j(List<DiagnosticAndLazyQuickFixes> list, DocEdit docEdit) {
        ListIterator<DiagnosticAndLazyQuickFixes> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Diagnostic diagnostic = listIterator.next().getDiagnostic();
            Position position = docEdit.getStart();
            Position position2 = diagnostic.getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
            if (LspDiagnosticsCacheKt.access$compareTo(position, position2) > 0) continue;
            Position position3 = docEdit.getEndOld();
            Position position4 = diagnostic.getRange().getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getStart(...)");
            if (LspDiagnosticsCacheKt.access$compareTo(position3, position4) < 0) {
                listIterator.set(new DiagnosticAndLazyQuickFixes(this.j(diagnostic, docEdit)));
                continue;
            }
            listIterator.remove();
        }
    }

    private final Diagnostic j(Diagnostic diagnostic, DocEdit docEdit) {
        Diagnostic diagnostic2;
        int n2 = docEdit.getEndNew().getLine() - docEdit.getEndOld().getLine();
        int n3 = diagnostic.getRange().getStart().getLine() + n2;
        int n4 = diagnostic.getRange().getEnd().getLine() + n2;
        int n5 = n3 == docEdit.getEndNew().getLine() ? diagnostic.getRange().getStart().getCharacter() + docEdit.getEndNew().getCharacter() - docEdit.getEndOld().getCharacter() : diagnostic.getRange().getStart().getCharacter();
        int n6 = diagnostic.getRange().getEnd().getLine() == diagnostic.getRange().getStart().getLine() ? diagnostic.getRange().getEnd().getCharacter() + n5 - diagnostic.getRange().getStart().getCharacter() : diagnostic.getRange().getEnd().getCharacter();
        Diagnostic diagnostic3 = diagnostic2 = new Diagnostic();
        boolean bl = false;
        diagnostic3.setRange(new Range(new Position(n3, n5), new Position(n4, n6)));
        diagnostic3.setSeverity(diagnostic.getSeverity());
        diagnostic3.setCode(diagnostic.getCode());
        diagnostic3.setCodeDescription(diagnostic.getCodeDescription());
        diagnostic3.setSource(diagnostic.getSource());
        diagnostic3.setMessage(diagnostic.getMessage());
        diagnostic3.setTags(diagnostic.getTags());
        diagnostic3.setRelatedInformation(diagnostic.getRelatedInformation());
        diagnostic3.setData(diagnostic.getData());
        return diagnostic2;
    }

    public final void clearCache$intellij_platform_lsp_impl() {
        this.uriToDiagnostics.clear();
        this.filePathToUri.clear();
        this.filePathToPendingDocEdits.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/lsp/impl/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes;", "", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "(Lorg/eclipse/lsp4j/Diagnostic;)V", "getDiagnostic", "()Lorg/eclipse/lsp4j/Diagnostic;", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getQuickFixes", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspDiagnosticsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
    public static final class DiagnosticAndLazyQuickFixes {
        @NotNull
        private final Diagnostic diagnostic;
        @Nullable
        private List<? extends IntentionAction> quickFixes;

        public DiagnosticAndLazyQuickFixes(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @NotNull
        public final List<IntentionAction> getQuickFixes(@NotNull LspServerImpl lspServer, @NotNull VirtualFile file2) {
            block6: {
                block5: {
                    LspCodeActionsSupport lspCodeActionsSupport;
                    Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    List<IntentionAction> list = this.quickFixes;
                    if (list != null) {
                        List<IntentionAction> list2 = list;
                        boolean bl = false;
                        return list2;
                    }
                    LspCodeActionsSupport lspCodeActionsSupport2 = lspServer.getDescriptor().getLspCodeActionsSupport();
                    if (lspCodeActionsSupport2 == null) break block5;
                    LspCodeActionsSupport lspCodeActionsSupport3 = lspCodeActionsSupport = lspCodeActionsSupport2;
                    boolean bl = false;
                    lspCodeActionsSupport2 = lspCodeActionsSupport3.getQuickFixesSupport() ? lspCodeActionsSupport : null;
                    if (lspCodeActionsSupport2 != null) break block6;
                }
                return CollectionsKt.emptyList();
            }
            if (!lspServer.supportsCodeActions$intellij_platform_lsp_impl((Function1<? super List<String>, Boolean>)((Function1)getQuickFixes.3.INSTANCE))) {
                return CollectionsKt.emptyList();
            }
            List<IntentionAction> list = new LspQuickFixSet(lspServer, file2, this.diagnostic).getQuickFixes();
            boolean bl = false;
            this.quickFixes = list;
            return list;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lsp/impl/LspDiagnosticsCache$DocEdit;", "", "start", "Lorg/eclipse/lsp4j/Position;", "endOld", "endNew", "(Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;)V", "getEndNew", "()Lorg/eclipse/lsp4j/Position;", "getEndOld", "getStart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lsp.impl"})
    private static final class DocEdit {
        @NotNull
        private final Position start;
        @NotNull
        private final Position endOld;
        @NotNull
        private final Position endNew;

        public DocEdit(@NotNull Position start2, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            this.start = start2;
            this.endOld = endOld;
            this.endNew = endNew;
        }

        @NotNull
        public final Position getStart() {
            return this.start;
        }

        @NotNull
        public final Position getEndOld() {
            return this.endOld;
        }

        @NotNull
        public final Position getEndNew() {
            return this.endNew;
        }

        @NotNull
        public final Position component1() {
            return this.start;
        }

        @NotNull
        public final Position component2() {
            return this.endOld;
        }

        @NotNull
        public final Position component3() {
            return this.endNew;
        }

        @NotNull
        public final DocEdit copy(@NotNull Position start2, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            return new DocEdit(start2, endOld, endNew);
        }

        public static /* synthetic */ DocEdit copy$default(DocEdit docEdit, Position position, Position position2, Position position3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                position = docEdit.start;
            }
            if ((n2 & 2) != 0) {
                position2 = docEdit.endOld;
            }
            if ((n2 & 4) != 0) {
                position3 = docEdit.endNew;
            }
            return docEdit.copy(position, position2, position3);
        }

        @NotNull
        public String toString() {
            return "DocEdit(start=" + this.start + ", endOld=" + this.endOld + ", endNew=" + this.endNew + ")";
        }

        public int hashCode() {
            int n2 = this.start.hashCode();
            n2 = n2 * 31 + this.endOld.hashCode();
            n2 = n2 * 31 + this.endNew.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocEdit)) {
                return false;
            }
            DocEdit docEdit = (DocEdit)other;
            if (!Intrinsics.areEqual((Object)this.start, (Object)docEdit.start)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endOld, (Object)docEdit.endOld)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.endNew, (Object)docEdit.endNew);
        }
    }
}

