/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.lsWidget;

import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServicePopupSection;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.platform.lang.lsWidget.OpenSettingsAction;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.lsWidget.LspWidgetInternalService;
import com.intellij.platform.lsp.api.lsWidget.RestartLspServerAction;
import com.intellij.platform.lsp.api.lsWidget.StopLspServerAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)H\u0014J\b\u0010,\u001a\u00020*H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0018\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u0019\u0010\u001d\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u001b\u0010\u001f\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0019\u0010%\u001a\u00070\u0012\u00a2\u0006\u0002\b&8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "Lcom/intellij/platform/lang/lsWidget/LanguageServiceWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "settingsPageClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "(Lcom/intellij/platform/lsp/api/LspServer;Lcom/intellij/openapi/vfs/VirtualFile;Ljavax/swing/Icon;Ljava/lang/Class;)V", "isError", "", "()Z", "getLspServer", "()Lcom/intellij/platform/lsp/api/LspServer;", "rootPostfix", "", "Lcom/intellij/openapi/util/NlsSafe;", "getRootPostfix", "()Ljava/lang/String;", "serverLabel", "getServerLabel", "statusBarIcon", "getStatusBarIcon", "()Ljavax/swing/Icon;", "statusBarTooltip", "getStatusBarTooltip", "versionPostfix", "getVersionPostfix", "widgetActionLocation", "Lcom/intellij/platform/lang/lsWidget/LanguageServicePopupSection;", "getWidgetActionLocation", "()Lcom/intellij/platform/lang/lsWidget/LanguageServicePopupSection;", "widgetActionLocation$delegate", "Lkotlin/Lazy;", "widgetActionText", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "getWidgetActionText", "createAdditionalInlineActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createWidgetInlineActions", "createWidgetMainAction", "intellij.platform.lsp"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLspServerWidgetItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerWidgetItem.kt\ncom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public class LspServerWidgetItem
extends LanguageServiceWidgetItem {
    @NotNull
    private final LspServer lspServer;
    @NotNull
    private final Icon icon;
    @Nullable
    private final Class<? extends Configurable> settingsPageClass;
    @NotNull
    private final Icon statusBarIcon;
    private final boolean isError;
    @NotNull
    private final Lazy widgetActionLocation$delegate;

    public LspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile, @NotNull Icon icon, @Nullable Class<? extends Configurable> settingsPageClass) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.lspServer = lspServer;
        this.icon = icon;
        this.settingsPageClass = settingsPageClass;
        this.statusBarIcon = this.icon;
        this.isError = this.lspServer.getState() == LspServerState.ShutdownUnexpectedly;
        this.widgetActionLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageServicePopupSection>(currentFile, this){
            final /* synthetic */ VirtualFile $currentFile;
            final /* synthetic */ LspServerWidgetItem this$0;
            {
                this.$currentFile = $currentFile;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final LanguageServicePopupSection invoke() {
                LanguageServicePopupSection languageServicePopupSection;
                if (this.$currentFile != null && this.$currentFile.isInLocalFileSystem() && this.this$0.getLspServer().getDescriptor().isSupportedFile(this.$currentFile)) {
                    boolean bl;
                    block3: {
                        VirtualFile[] virtualFileArray = this.this$0.getLspServer().getDescriptor().getRoots();
                        VirtualFile virtualFile2 = this.$currentFile;
                        boolean bl2 = false;
                        int n2 = virtualFileArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            VirtualFile virtualFile3;
                            VirtualFile virtualFile4 = virtualFile3 = virtualFileArray[i2];
                            boolean bl3 = false;
                            if (!VfsUtil.isAncestor((VirtualFile)virtualFile4, (VirtualFile)virtualFile2, (boolean)true)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    if (bl && ProjectFileIndex.getInstance((Project)this.this$0.getLspServer().getProject()).isInContent(this.$currentFile)) {
                        languageServicePopupSection = LanguageServicePopupSection.ForCurrentFile;
                        return languageServicePopupSection;
                    }
                }
                languageServicePopupSection = LanguageServicePopupSection.Other;
                return languageServicePopupSection;
            }
        }));
    }

    public /* synthetic */ LspServerWidgetItem(LspServer lspServer, VirtualFile virtualFile2, Icon icon, Class clazz, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            Icon icon2 = AllIcons.Json.Object;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Object");
            icon = icon2;
        }
        if ((n2 & 8) != 0) {
            clazz = null;
        }
        this(lspServer, virtualFile2, icon, clazz);
    }

    @NotNull
    protected final LspServer getLspServer() {
        return this.lspServer;
    }

    @NotNull
    public Icon getStatusBarIcon() {
        return this.statusBarIcon;
    }

    @NotNull
    public String getStatusBarTooltip() {
        return this.lspServer.getDescriptor().getPresentableName() + this.getVersionPostfix();
    }

    public boolean isError() {
        return this.isError;
    }

    @NotNull
    public LanguageServicePopupSection getWidgetActionLocation() {
        Lazy lazy = this.widgetActionLocation$delegate;
        return (LanguageServicePopupSection)lazy.getValue();
    }

    @NotNull
    protected String getWidgetActionText() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.lspServer.getState().ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[]{this.getServerLabel()};
                String string2 = LangBundle.message((String)"language.services.widget.item.initializing", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 2: {
                string = this.getServerLabel();
                break;
            }
            case 3: {
                Object[] objectArray = new Object[]{this.getServerLabel()};
                String string3 = LangBundle.message((String)"language.services.widget.item.shutdown.normally", (Object[])objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            case 4: {
                Object[] objectArray = new Object[]{this.getServerLabel()};
                String string4 = LangBundle.message((String)"language.services.widget.item.shutdown.unexpectedly", (Object[])objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String getServerLabel() {
        return this.lspServer.getDescriptor().getPresentableName() + this.getVersionPostfix() + this.getRootPostfix();
    }

    @NotNull
    protected String getVersionPostfix() {
        Object object;
        block3: {
            block2: {
                object = this.lspServer.getInitializeResult();
                if (object == null || (object = object.getServerInfo()) == null || (object = object.getVersion()) == null) break block2;
                Object object2 = object;
                boolean bl = false;
                String string = " " + (String)object2;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    protected String getRootPostfix() {
        VirtualFile[] virtualFileArray = this.lspServer.getDescriptor().getRoots();
        Collection<LspServer> collection = LspServerManager.Companion.getInstance(this.lspServer.getProject()).getServersForProvider(this.lspServer.getProviderClass());
        return collection.size() >= 2 && virtualFileArray.length == 1 ? " \u2026/" + virtualFileArray[0].getName() : "";
    }

    @NotNull
    protected AnAction createWidgetMainAction() {
        AnAction anAction;
        Class<? extends Configurable> clazz = this.settingsPageClass;
        if (clazz != null) {
            Class<? extends Configurable> clazz2 = clazz;
            boolean bl = false;
            anAction = (AnAction)new OpenSettingsAction(clazz2, this.getWidgetActionText(), this.icon);
        } else {
            String string = this.getWidgetActionText();
            Icon icon = this.icon;
            anAction = new AnAction(string, icon){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                }
            };
        }
        return anAction;
    }

    @NotNull
    protected List<AnAction> createWidgetInlineActions() {
        List list;
        block7: {
            list = new ArrayList();
            list.addAll((Collection)this.createAdditionalInlineActions());
            if (this.getWidgetActionLocation() == LanguageServicePopupSection.ForCurrentFile) {
                list.add(new RestartLspServerAction(this.lspServer));
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[this.lspServer.getState().ordinal()]) {
                    case 1: 
                    case 2: {
                        list.add(new StopLspServerAction(this.lspServer));
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        list.add(new RestartLspServerAction(this.lspServer));
                    }
                }
            }
            Class<? extends Configurable> clazz = this.settingsPageClass;
            if (clazz == null) break block7;
            Class<? extends Configurable> clazz2 = clazz;
            boolean bl = false;
            list.add(new OpenSettingsAction(clazz2, null, null, 6, null));
        }
        return list;
    }

    @NotNull
    public List<AnAction> createAdditionalInlineActions() {
        AnAction anAction;
        if (this.lspServer.getState() != LspServerState.ShutdownUnexpectedly) {
            return CollectionsKt.emptyList();
        }
        AnAction anAction2 = anAction = LspWidgetInternalService.Companion.getInstance().createShowErrorOutputAction(this.lspServer);
        return anAction2 != null ? CollectionsKt.listOf((Object)anAction2) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LspServerState.values().length];
            try {
                nArray[LspServerState.Initializing.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LspServerState.Running.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LspServerState.ShutdownNormally.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LspServerState.ShutdownUnexpectedly.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

