/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.threading;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.impl.threading.GraphThreadingService;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J'\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001b0,H\u0002J\u0016\u0010-\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0.H\u0016J!\u0010/\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001b0,H\u0002\u00a2\u0006\u0002\u00100J!\u00101\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001b0,H\u0002\u00a2\u0006\u0002\u00100J!\u00102\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001b0,H\u0002\u00a2\u0006\u0002\u00100J\u0016\u00103\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0.H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0016J'\u00105\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0016\u00106\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0.H\u0016J5\u00107\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\b\u00108\u001a\u0004\u0018\u0001H\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u001b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u00109J\u0016\u0010:\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0.H\u0016J1\u0010;\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\n\b\u0002\u00108\u001a\u0004\u0018\u0001H\u001b2\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0,H\u0002\u00a2\u0006\u0002\u0010<R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006>"}, d2={"Lcom/intellij/openapi/graph/impl/threading/GraphThreadActionExecutor;", "Lcom/intellij/openapi/graph/threading/GraphActionExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "graphDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getGraphDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "graphExecutor", "Ljava/util/concurrent/Executor;", "getGraphExecutor", "()Ljava/util/concurrent/Executor;", "myGraphLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myReadLockCount", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "mySuppressReadLockAssertionCount", "writeExecutor", "getWriteExecutor", "assertGraphThread", "", "assertReadAccess", "assertWriteAccess", "computeReadAction", "T", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "computeWriteAction", "j", "", "N", "w", "runGraphActionAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "runnable", "Ljava/lang/Runnable;", "j", "func", "Lkotlin/Function0;", "runReadAction", "Lcom/intellij/util/ThrowableRunnable;", "N", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "w", "j", "runWriteAction", "runWriteActionAsync", "suppressComputableReadLockAssertion", "suppressRunnableReadLockAssertion", "tryComputeReadAction", "defaultResult", "(Ljava/lang/Object;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "tryRunReadAction", "j", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "intellij.platform.graph.impl"})
@ApiStatus.Experimental
public final class GraphThreadActionExecutor
implements GraphActionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantReadWriteLock myGraphLock;
    private final ThreadLocal<Integer> myReadLockCount;
    private final ThreadLocal<Integer> mySuppressReadLockAssertionCount;
    @NotNull
    public static final String GRAPH_THREAD_NAME = "DiagramScheduler";
    @NotNull
    private static final Logger LOG;

    public GraphThreadActionExecutor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myGraphLock = new ReentrantReadWriteLock();
        this.myReadLockCount = ThreadLocal.withInitial(GraphThreadActionExecutor::N);
        this.mySuppressReadLockAssertionCount = ThreadLocal.withInitial(GraphThreadActionExecutor::j);
    }

    @NotNull
    public CoroutineDispatcher getGraphDispatcher() {
        return GraphThreadingService.Companion.getGraphDispatcher(this.project);
    }

    @NotNull
    public Executor getGraphExecutor() {
        return arg_0 -> GraphThreadActionExecutor.j(this, arg_0);
    }

    @NotNull
    public Executor getWriteExecutor() {
        Function1 function1 = (Function1)new Function1<Runnable, Unit>((Object)this){

            public final void invoke(@NotNull Runnable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((GraphThreadActionExecutor)this.receiver).runWriteActionAsync(p0);
            }
        };
        return new Executor(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Runnable p0) {
                this.function.invoke((Object)p0);
            }
        };
    }

    public void assertGraphThread() {
        if (!this.j()) {
            LOG.error("Method should be accessed only from Graph thread.");
        }
    }

    public void assertReadAccess() {
        if (!this.w()) {
            LOG.error("Method should be accessed only under Graph read lock.");
        }
    }

    public void assertWriteAccess() {
        this.assertGraphThread();
        if (!this.myGraphLock.isWriteLockedByCurrentThread()) {
            LOG.error("Method should be accessed only under Graph write lock.");
        }
    }

    public void suppressRunnableReadLockAssertion(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.j((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public <T> T suppressComputableReadLockAssertion(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.j((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    public void runReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.N((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public void tryRunReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        GraphThreadActionExecutor.tryRunUnderReadLock$default(this, null, (Function0)new Function0<Unit>(runnable){
            final /* synthetic */ ThrowableRunnable<Throwable> $runnable;
            {
                this.$runnable = $runnable;
                super(0);
            }

            public final void invoke() {
                this.$runnable.run();
            }
        }, 1, null);
    }

    public void runWriteAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.w((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public <T> T computeReadAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.N((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    @Nullable
    public <T> T tryComputeReadAction(@Nullable T defaultResult, @NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.j(defaultResult, (Function0)new Function0<T>(computable){

            @Nullable
            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    public <T> T computeWriteAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.w((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> runGraphActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable::run, this.getGraphExecutor());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> runWriteActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return this.runGraphActionAsync(() -> GraphThreadActionExecutor.N(this, runnable));
    }

    private final <T> void j(Function0<? extends T> function0) {
        if (this.j()) {
            function0.invoke();
        } else {
            BuildersKt.launch$default((CoroutineScope)GraphThreadingService.Companion.getGraphScope(this.project), (CoroutineContext)((CoroutineContext)this.getGraphDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(function0, null){
                int label;
                final /* synthetic */ Function0<T> $func;
                {
                    this.$func = $func;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$func.invoke();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T N(Function0<? extends T> function0) {
        if (!this.N()) {
            ThreadingAssertions.assertNoReadAccess();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myGraphLock.readLock();
        readLock.lock();
        try {
            Object object;
            boolean bl = false;
            this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() + 1);
            try {
                Object object2 = function0.invoke();
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                object = object2;
            }
            catch (Throwable throwable) {
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                throw throwable;
            }
            return (T)object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T j(T t10, Function0<? extends T> function0) {
        Object object;
        boolean bl = this.myGraphLock.readLock().tryLock();
        if (bl) {
            Object object2;
            this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() + 1);
            try {
                object2 = function0.invoke();
            }
            finally {
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                this.myGraphLock.readLock().unlock();
            }
            object = object2;
        } else {
            object = t10;
        }
        return object;
    }

    static /* synthetic */ Object tryRunUnderReadLock$default(GraphThreadActionExecutor graphThreadActionExecutor, Object object, Function0 function0, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            object = null;
        }
        return graphThreadActionExecutor.j(object, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T w(Function0<? extends T> function0) {
        if (!this.N()) {
            ThreadingAssertions.assertNoReadAccess();
        }
        this.assertGraphThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this.myGraphLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Object object = function0.invoke();
            return (T)object;
        }
        finally {
            for (int i3 = 0; i3 < n2; ++i3) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T j(Function0<? extends T> function0) {
        this.mySuppressReadLockAssertionCount.set(((Number)this.mySuppressReadLockAssertionCount.get()).intValue() + 1);
        try {
            Object object = function0.invoke();
            return (T)object;
        }
        finally {
            this.mySuppressReadLockAssertionCount.set(((Number)this.mySuppressReadLockAssertionCount.get()).intValue() - 1);
        }
    }

    private final boolean j() {
        return Intrinsics.areEqual((Object)Thread.currentThread(), (Object)GraphThreadingService.Companion.getGraphThread(this.project));
    }

    private final boolean w() {
        Integer n2 = this.myReadLockCount.get();
        return n2 == null || n2 != 0 || this.j();
    }

    private final boolean N() {
        Integer n2 = this.mySuppressReadLockAssertionCount.get();
        return n2 == null || n2 != 0;
    }

    private static final Integer N() {
        return 0;
    }

    private static final Integer j() {
        return 0;
    }

    private static final void j(GraphThreadActionExecutor graphThreadActionExecutor, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)graphThreadActionExecutor, (String)"this$0");
        Intrinsics.checkNotNull((Object)runnable);
        graphThreadActionExecutor.j((Function0)new Function0<Unit>((Object)runnable){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    private static final void N(GraphThreadActionExecutor graphThreadActionExecutor, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)graphThreadActionExecutor, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"$runnable");
        graphThreadActionExecutor.w((Function0)new Function0<Unit>((Object)runnable){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    static {
        Logger logger = Logger.getInstance(GraphThreadActionExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/graph/impl/threading/GraphThreadActionExecutor$Companion;", "", "()V", "GRAPH_THREAD_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

