/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphSvgExporter;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.View;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ExportToFileAction
extends AbstractGraphAction {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ExportToFileAction.class);
    @NotNull
    private static final String DEFAULT_FILE_EXTENSION = "png";
    private static final String @NotNull [] FILE_EXTENSIONS = new String[]{"png", "jpg", "gif", "svg", "svgz"};
    private static final double EXPORT_SCALE = 2.0;
    private static final double HIDPI_SCALE = 2.0;

    public void actionPerformed(@NotNull AnActionEvent e2, @NotNull Graph2D __) {
        GraphBuilder graphBuilder;
        if (e2 == null) {
            ExportToFileAction.j(0);
        }
        if (__ == null) {
            ExportToFileAction.j(1);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        VirtualFile virtualFile2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        String string = (String)ObjectUtils.notNull((Object)e2.getPresentation().getText(), (Object)GraphBundle.message((String)"dialog.title.export", (Object[])new Object[0]));
        File file2 = ExportToFileAction.j(graphBuilder.getProject(), virtualFile2 != null ? virtualFile2.getParent() : null, virtualFile2 != null ? FileUtilRt.getNameWithoutExtension((String)virtualFile2.getPresentableName()) : "diagram", string, StringUtil.notNullize((String)e2.getPresentation().getDescription()));
        if (file2 == null) {
            return;
        }
        ExportToFileAction.exportToFile(graphBuilder, string, file2);
    }

    static void exportToFile(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @NotNull File resultImageFile) {
        if (builder == null) {
            ExportToFileAction.j(2);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.j(3);
        }
        if (resultImageFile == null) {
            ExportToFileAction.j(4);
        }
        ExportToFileAction.j(builder, exportDialogTitle, (? super ExportContext exportContext) -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ReadAction.run(() -> ExportToFileAction.w(builder, exportContext, resultImageFile));
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(resultImageFile));
        }, exportDialogTitle, false, builder.getProject()));
    }

    @NotNull
    static Image exportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle) {
        if (builder == null) {
            ExportToFileAction.j(5);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.j(6);
        }
        return ExportToFileAction.doExportToImage(builder, exportDialogTitle, null);
    }

    @NotNull
    static Image exportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @NotNull Rectangle area) {
        if (builder == null) {
            ExportToFileAction.j(7);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.j(8);
        }
        if (area == null) {
            ExportToFileAction.j(9);
        }
        return ExportToFileAction.doExportToImage(builder, exportDialogTitle, area);
    }

    @NotNull
    static Image doExportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @Nullable Rectangle area) {
        if (builder == null) {
            ExportToFileAction.j(10);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.j(11);
        }
        Ref ref = Ref.create();
        WriteAction.runAndWait(() -> ExportToFileAction.j(builder, exportDialogTitle, (? super ExportContext exportContext) -> ref.set((Object)ExportToFileAction.j(exportContext.exportView, area))));
        Image image = (Image)ref.get();
        if (image == null) {
            ExportToFileAction.j(12);
        }
        return image;
    }

    @Nullable
    private static File j(@NotNull Project project2, @Nullable VirtualFile virtualFile2, @NotNull String string, @NotNull @NlsContexts.DialogTitle String string2, @NotNull @NlsContexts.Label String string3) {
        JFrame jFrame;
        if (project2 == null) {
            ExportToFileAction.j(13);
        }
        if (string == null) {
            ExportToFileAction.j(14);
        }
        if (string2 == null) {
            ExportToFileAction.j(15);
        }
        if (string3 == null) {
            ExportToFileAction.j(16);
        }
        if ((jFrame = WindowManager.getInstance().getFrame(project2)) == null) {
            return null;
        }
        VirtualFileWrapper virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(string2, string3, FILE_EXTENSIONS), (Component)jFrame).save(virtualFile2, string);
        if (virtualFileWrapper == null) {
            return null;
        }
        File file2 = virtualFileWrapper.getFile();
        if (!ArrayUtil.contains((String)StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)file2.getName())), (String[])FILE_EXTENSIONS)) {
            file2 = new File(file2.getPath() + ".png");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void j(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull @Nls String string, @NotNull Consumer<? super ExportContext> consumer2) {
        if (graphBuilder == null) {
            ExportToFileAction.j(17);
        }
        if (string == null) {
            ExportToFileAction.j(18);
        }
        if (consumer2 == null) {
            ExportToFileAction.j(19);
        }
        ExportContext exportContext = ExportToFileAction.j(graphBuilder);
        try {
            consumer2.accept(exportContext);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            Messages.showErrorDialog((Project)graphBuilder.getProject(), (String)exception.getMessage(), (String)string);
        }
        finally {
            ExportToFileAction.j(graphBuilder, exportContext);
        }
    }

    @NotNull
    private static ExportContext j(@NotNull GraphBuilder<?, ?> graphBuilder) {
        Graph2DView graph2DView;
        ZoomableViewport zoomableViewport;
        if (graphBuilder == null) {
            ExportToFileAction.j(20);
        }
        if ((zoomableViewport = (ZoomableViewport)UIUtil.uiParents((Component)(graph2DView = graphBuilder.getView()).getComponent(), (boolean)false).filter(ZoomableViewport.class).first()) != null) {
            zoomableViewport.magnificationStarted(new Point(0, 0));
            zoomableViewport.magnify(0.0);
        }
        GraphExportService.getInstance().setExportMode(true);
        return new ExportContext(graphBuilder.getView(), ExportToFileAction.j(graphBuilder), zoomableViewport);
    }

    private static void w(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull ExportContext exportContext, @NotNull File file2) {
        if (graphBuilder == null) {
            ExportToFileAction.j(21);
        }
        if (exportContext == null) {
            ExportToFileAction.j(22);
        }
        if (file2 == null) {
            ExportToFileAction.j(23);
        }
        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
        String string = FileUtilRt.getExtension((String)file2.getName());
        try {
            if (StringUtil.startsWithIgnoreCase((String)string, (String)"svg")) {
                Graph2D graph2D = graphBuilder.getGraph();
                graph2D.setCurrentView((View)exportContext.exportView);
                GraphSvgExporter.getGraphSvgExporter().exportToSvg(graph2D, file2.getPath(), string);
            } else {
                BufferedImage bufferedImage = ExportToFileAction.j(exportContext.exportView, null);
                ImageIO.write((RenderedImage)bufferedImage, FileUtilRt.getExtension((String)file2.getName()), file2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        RevealFileAction.openFile((File)file2);
    }

    private static void j(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull ExportContext exportContext) {
        if (graphBuilder == null) {
            ExportToFileAction.j(24);
        }
        if (exportContext == null) {
            ExportToFileAction.j(25);
        }
        Graph2D graph2D = graphBuilder.getGraph();
        graph2D.removeView((View)exportContext.exportView);
        graph2D.setCurrentView((View)exportContext.oldView);
        GraphExportService.getInstance().setExportMode(false);
        if (exportContext.zoomable != null) {
            exportContext.zoomable.magnificationFinished(0.0);
        }
    }

    @NotNull
    private static Graph2DView j(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            ExportToFileAction.j(26);
        }
        Graph2D graph2D = graphBuilder.getGraph();
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView(graph2D);
        graph2DView.setZoom(4.0);
        graph2DView.setAntialiasedPainting(true);
        graph2DView.setPaintDetailThreshold(0.0);
        GraphAnimationService.getInstance().updateWorldRect(graph2DView);
        Rectangle rectangle = graph2DView.getWorldRect();
        graph2DView.setViewPoint2D(rectangle.getMinX(), rectangle.getMinY());
        Dimension dimension = new Dimension(graph2DView.toViewCoordX(rectangle.getMaxX()), graph2DView.toViewCoordY(rectangle.getMaxY()));
        graph2DView.getCanvasComponent().setSize(dimension);
        graph2DView.getCanvasComponent().setPreferredSize(dimension);
        ((DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer()).setColor(graph2D.getCurrentView().getComponent().getBackground());
        GraphPresentationModel graphPresentationModel = graphBuilder.getGraphPresentationModel();
        if (graphPresentationModel instanceof BasicGraphPresentationModel) {
            BasicGraphPresentationModel basicGraphPresentationModel = (BasicGraphPresentationModel)graphPresentationModel;
            basicGraphPresentationModel.setupBridgesFor(graph2DView.getGraph2DRenderer());
        }
        Graph2DView graph2DView2 = graph2DView;
        if (graph2DView2 == null) {
            ExportToFileAction.j(27);
        }
        return graph2DView2;
    }

    @NotNull
    private static BufferedImage j(@NotNull Graph2DView graph2DView, @Nullable Rectangle rectangle) {
        BufferedImage bufferedImage;
        if (graph2DView == null) {
            ExportToFileAction.j(28);
        }
        if (rectangle == null) {
            rectangle = graph2DView.getWorldRect();
        }
        try {
            bufferedImage = new BufferedImage((int)(2.0 * (double)rectangle.width), (int)(2.0 * (double)rectangle.height), 1);
        }
        catch (NegativeArraySizeException | OutOfMemoryError throwable) {
            throw new IllegalArgumentException(GraphBundle.message((String)"graph.ExportToFileAction.image.is.too.large", (Object[])new Object[]{rectangle.width, rectangle.height}), throwable);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphicsUtil.setupAAPainting((Graphics)graphics2D);
        graphics2D.setBackground(((DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer()).getColor());
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.scale(0.5, 0.5);
        graphics2D.translate(-graph2DView.toViewCoordX((double)rectangle.x), -graph2DView.toViewCoordY((double)rectangle.y));
        graph2DView.getCanvasComponent().paint(graphics2D);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ExportToFileAction.j(29);
        }
        return bufferedImage2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 12, 27, 29 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDialogTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultImageFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageFileName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDialogDescription";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doExport";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doExportToImage";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createExportView";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "paintToImage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportToFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportToImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doExportToImage";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "askUserToChooseFileToSaveInto";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupExportAndRun";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setUpBeforeExport";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doExportToFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tearDownAfterExport";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createExportView";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "paintToImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 12, 27, 29 -> new IllegalStateException(string);
        };
    }

    private static final class ExportContext {
        @NotNull
        private final Graph2DView oldView;
        @NotNull
        private final Graph2DView exportView;
        @Nullable
        private final ZoomableViewport zoomable;

        private ExportContext(@NotNull Graph2DView oldView, @NotNull Graph2DView exportView, @Nullable ZoomableViewport zoomable) {
            if (oldView == null) {
                ExportContext.j(0);
            }
            if (exportView == null) {
                ExportContext.j(1);
            }
            this.oldView = oldView;
            this.exportView = exportView;
            this.zoomable = zoomable;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exportView";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction$ExportContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

