/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.DefaultExactPathSegmentHandler;
import com.intellij.microservices.url.references.PathSegmentHandler;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.microservices.url.references.UrlPathReferenceKt;
import com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget;
import com.intellij.microservices.url.references.UrlSegmentReference;
import com.intellij.microservices.url.references.UrlSegmentReferenceTarget;
import com.intellij.microservices.utils.CommonFakeNavigatablePomTarget;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004/012BS\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0002H\u0016J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference;", "Lcom/intellij/psi/PsiReferenceBase$Poly;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/microservices/url/references/UrlSegmentReference;", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "host", "range", "Lcom/intellij/openapi/util/TextRange;", "isAtEnd", "", "shouldHaveSlashBefore", "pathSegmentHandler", "Lcom/intellij/microservices/url/references/PathSegmentHandler;", "customNavigate", "Lkotlin/Function1;", "", "(Lcom/intellij/microservices/url/references/UrlPathContext;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;ZZLcom/intellij/microservices/url/references/PathSegmentHandler;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Lcom/intellij/microservices/url/references/UrlPathContext;", "()Z", "unifiedPomTarget", "Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;", "getUnifiedPomTarget", "()Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;", "unifiedPomTarget$delegate", "Lkotlin/Lazy;", "getVariantsIterator", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getVariantsIterator$intellij_microservices", "isReferenceTo", "element", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "j", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "j", "currentPath", "variantPath", "toString", "", "Companion", "UrlPathLookupObject", "UrlTargetInfoFakeElement", "UrlTargetInfoWrapper", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1549#2:188\n1620#2,3:189\n1549#2:192\n1620#2,3:193\n936#2,15:197\n350#2,7:212\n1#3:196\n*S KotlinDebug\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference\n*L\n28#1:188\n28#1:189,3\n39#1:192\n39#1:193,3\n99#1:197,15\n107#1:212,7\n*E\n"})
public final class UrlPathReference
extends PsiReferenceBase.Poly<PsiElement>
implements UrlSegmentReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathContext context;
    private final boolean isAtEnd;
    private final boolean shouldHaveSlashBefore;
    @NotNull
    private final PathSegmentHandler pathSegmentHandler;
    @Nullable
    private final Function1<UrlSegmentReference, Unit> customNavigate;
    @NotNull
    private final Lazy unifiedPomTarget$delegate;

    @JvmOverloads
    public UrlPathReference(@NotNull UrlPathContext context2, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore, @NotNull PathSegmentHandler pathSegmentHandler, @Nullable Function1<? super UrlSegmentReference, Unit> customNavigate) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)pathSegmentHandler, (String)"pathSegmentHandler");
        super(host, range, false);
        this.context = context2;
        this.isAtEnd = isAtEnd;
        this.shouldHaveSlashBefore = shouldHaveSlashBefore;
        this.pathSegmentHandler = pathSegmentHandler;
        this.customNavigate = customNavigate;
        this.unifiedPomTarget$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UrlPathReferenceUnifiedPomTarget>(this){
            final /* synthetic */ UrlPathReference this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final UrlPathReferenceUnifiedPomTarget invoke() {
                if (CollectionsKt.none(this.this$0.getContext().getResolveRequests())) {
                    return null;
                }
                UrlPathContext urlPathContext = this.this$0.getContext();
                boolean bl = this.this$0.isAtEnd();
                Project project2 = this.this$0.getElement().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                return new UrlPathReferenceUnifiedPomTarget(urlPathContext, bl, project2);
            }
        }));
    }

    public /* synthetic */ UrlPathReference(UrlPathContext urlPathContext, PsiElement psiElement, TextRange textRange, boolean bl, boolean bl2, PathSegmentHandler pathSegmentHandler, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            pathSegmentHandler = DefaultExactPathSegmentHandler.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        this(urlPathContext, psiElement, textRange, bl, bl2, pathSegmentHandler, (Function1<? super UrlSegmentReference, Unit>)function1);
    }

    @NotNull
    public final UrlPathContext getContext() {
        return this.context;
    }

    public final boolean isAtEnd() {
        return this.isAtEnd;
    }

    @NotNull
    public String toString() {
        Collection<UrlPath> collection;
        String string = (String)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> UrlPathReference.j(this));
        if (string == null) {
            string = "<recursive-evaluation>";
        }
        String string2 = string;
        Iterable iterable = CollectionsKt.toList(this.context.getResolveRequests());
        TextRange textRange = this.getRangeInElement();
        String string3 = string2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            UrlResolveRequest urlResolveRequest = (UrlResolveRequest)t10;
            collection = collection2;
            boolean bl3 = false;
            collection.add(urlResolveRequest.getPath());
        }
        collection = (List)collection2;
        return "URLPathReference(" + string3 + ", " + textRange + ", contexts = " + CollectionsKt.distinct((Iterable)collection) + ")";
    }

    @Nullable
    public final UrlPathReferenceUnifiedPomTarget getUnifiedPomTarget() {
        Lazy lazy = this.unifiedPomTarget$delegate;
        return (UrlPathReferenceUnifiedPomTarget)lazy.getValue();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Iterable iterable = CollectionsKt.listOfNotNull((Object)this.getUnifiedPomTarget());
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = (UrlPathReferenceUnifiedPomTarget)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            Project project2 = this.getElement().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            collection2.add(new UrlTargetInfoFakeElement(project2, urlPathReferenceUnifiedPomTarget, this, this.context.isDeclaration()));
        }
        Collection collection3 = (List)collection;
        boolean bl4 = false;
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)collection3);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"let(...)");
        return resolveResultArray;
    }

    @NotNull
    public final Iterator<LookupElement> getVariantsIterator$intellij_microservices() {
        MicroservicesUsageCollector.INSTANCE.getURL_PATH_VARIANTS_EVENT().log(this.myElement.getProject());
        Set set = new LinkedHashSet();
        UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = this.getUnifiedPomTarget();
        Sequence sequence = urlPathReferenceUnifiedPomTarget != null ? urlPathReferenceUnifiedPomTarget.mapVariants$intellij_microservices((Function2)new Function2<UrlResolveRequest, Iterable<? extends UrlTargetInfo>, Sequence<? extends LookupElement>>(this, (Set<List<UrlPath.PathSegment>>)set){
            final /* synthetic */ UrlPathReference this$0;
            final /* synthetic */ Set<List<UrlPath.PathSegment>> $knownPrefixes;
            {
                this.this$0 = $receiver;
                this.$knownPrefixes = $knownPrefixes;
                super(2);
            }

            @NotNull
            public final Sequence<LookupElement> invoke(@NotNull UrlResolveRequest context2, @NotNull Iterable<? extends UrlTargetInfo> variants) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter(variants, (String)"variants");
                return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(variants), (Function1)((Function1)new Function1<UrlTargetInfo, Sequence<? extends LookupElement>>(context2, this.this$0, this.$knownPrefixes){
                    final /* synthetic */ UrlResolveRequest $context;
                    final /* synthetic */ UrlPathReference this$0;
                    final /* synthetic */ Set<List<UrlPath.PathSegment>> $knownPrefixes;
                    {
                        this.$context = $context;
                        this.this$0 = $receiver;
                        this.$knownPrefixes = $knownPrefixes;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<LookupElement> invoke(@NotNull UrlTargetInfo variant) {
                        List list;
                        Object object;
                        boolean bl;
                        Object object2;
                        Set<List<UrlPath.PathSegment>> set;
                        Object object3;
                        Iterable iterable;
                        UrlPath urlPath;
                        List<UrlPath.PathSegment> list2;
                        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                        if (!UrlPathReferenceKt.access$compatibleMethod(variant, this.$context.getMethod())) {
                            return SequencesKt.emptySequence();
                        }
                        String string = this.this$0.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        if (((CharSequence)string).length() > 0) {
                            list2 = this.$context.getPath().getSegments();
                            boolean bl2 = false;
                            v1 = new UrlPath(list2.subList(0, RangesKt.coerceAtLeast((int)(list2.size() - 1), (int)0)));
                        } else {
                            v1 = urlPath = this.$context.getPath();
                        }
                        if (!urlPath.canBePrefixFor(variant.getPath())) {
                            return SequencesKt.emptySequence();
                        }
                        UrlPath urlPath2 = UrlPathReference.access$remainingPath(this.this$0, urlPath, variant.getPath());
                        list2 = UrlPathReference.access$getPathSegmentHandler$p(this.this$0).getExactPrefix(urlPath2);
                        this.$knownPrefixes.add(list2);
                        if (this.this$0.isAtEnd()) {
                            iterable = (Iterable)CollectionsKt.getIndices((Collection)list2);
                            boolean bl3 = false;
                            Iterable iterable2 = iterable;
                            object3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                            boolean bl4 = false;
                            Iterator<T> iterator = iterable2.iterator();
                            while (iterator.hasNext()) {
                                int n2;
                                int n3 = n2 = ((IntIterator)iterator).nextInt();
                                Object object4 = object3;
                                boolean bl5 = false;
                                object4.add(list2.subList(0, n3));
                            }
                            iterable = (List)object3;
                            set = this.$knownPrefixes;
                            boolean bl6 = false;
                            object3 = iterable;
                            object2 = new ArrayList<E>();
                            bl = false;
                            object = object3.iterator();
                            while (object.hasNext()) {
                                E e2 = object.next();
                                List list3 = (List)e2;
                                boolean bl7 = false;
                                if (!set.add(list3)) continue;
                                object2.add(e2);
                            }
                            list = (List)object2;
                        } else {
                            list = !((Collection)list2).isEmpty() ? CollectionsKt.listOf(list2.subList(0, 1)) : CollectionsKt.emptyList();
                        }
                        List list4 = list;
                        set = (Set<List<UrlPath.PathSegment>>)((Object)list4);
                        Collection collection = new ArrayList<E>(list4.size() + 1);
                        object3 = this.$context;
                        object2 = this.this$0;
                        bl = false;
                        object = set;
                        boolean bl8 = false;
                        Iterator<T> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            LookupElement lookupElement;
                            T t10;
                            T t11 = t10 = iterator.next();
                            boolean bl9 = false;
                            List list5 = (List)t11;
                            boolean bl10 = false;
                            if (UrlPathReference.access$getVariantsIterator$mkLookup((UrlPathReference)object2, (UrlResolveRequest)object3, list5, urlPath2.getSegments(), variant, true) == null) continue;
                            boolean bl11 = false;
                            collection.add(lookupElement);
                        }
                        iterable = (ArrayList)collection;
                        if (this.this$0.isAtEnd()) {
                            UtilKt.addIfNotNull((List)((List)iterable), (Object)UrlPathReference.access$getVariantsIterator$mkLookup(this.this$0, this.$context, list2, urlPath2.getSegments(), variant, list2.size() != urlPath2.getSegments().size()));
                        }
                        return CollectionsKt.asSequence((Iterable)iterable);
                    }
                }));
            }
        }) : null;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        return SequencesKt.flatten(sequence).iterator();
    }

    private final int j(UrlPath urlPath) {
        int n2 = 0;
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.getOrNull(urlPath.getSegments(), (int)n2);
        boolean bl = false;
        if (pathSegment instanceof UrlPath.PathSegment.Undefined) {
            ++n2;
        }
        UrlPath.PathSegment pathSegment2 = (UrlPath.PathSegment)CollectionsKt.getOrNull(urlPath.getSegments(), (int)n2);
        boolean bl2 = pathSegment2 != null ? pathSegment2.isEmpty() : false;
        if (bl2) {
            ++n2;
        }
        if (urlPath.getSegments().size() > 1) {
            List list;
            int n3;
            block9: {
                List<UrlPath.PathSegment> list2 = urlPath.getSegments();
                n3 = n2;
                boolean bl3 = false;
                if (list2.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ListIterator<UrlPath.PathSegment> listIterator = list2.listIterator(list2.size());
                    while (listIterator.hasPrevious()) {
                        UrlPath.PathSegment pathSegment3 = listIterator.previous();
                        boolean bl4 = false;
                        if (pathSegment3.isEmpty()) continue;
                        listIterator.next();
                        int n4 = list2.size() - listIterator.nextIndex();
                        if (n4 == 0) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList<UrlPath.PathSegment> arrayList;
                            ArrayList<UrlPath.PathSegment> arrayList2 = arrayList = new ArrayList<UrlPath.PathSegment>(n4);
                            boolean bl5 = false;
                            while (listIterator.hasNext()) {
                                arrayList2.add(listIterator.next());
                            }
                            list = arrayList;
                        }
                        break block9;
                    }
                    list = CollectionsKt.toList((Iterable)list2);
                }
            }
            List list3 = list;
            n2 = n3 + list3.size();
        }
        return urlPath.getSegments().size() - n2;
    }

    private final UrlPath j(UrlPath urlPath, UrlPath urlPath2) {
        int n2;
        List<UrlPath.PathSegment> list;
        block3: {
            int n3;
            int n4 = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)this.j(urlPath), (int)0), (int)urlPath2.getSegments().size());
            List<UrlPath.PathSegment> list2 = list = urlPath2.getSegments().subList(n4, urlPath2.getSegments().size());
            boolean bl = false;
            int n5 = 0;
            Iterator<UrlPath.PathSegment> iterator = list2.iterator();
            while (iterator.hasNext()) {
                UrlPath.PathSegment pathSegment;
                UrlPath.PathSegment pathSegment2 = pathSegment = iterator.next();
                boolean bl2 = false;
                if (!pathSegment2.isEmpty()) {
                    n3 = n5;
                    break block3;
                }
                ++n5;
            }
            n3 = n2 = -1;
        }
        if (n2 > 0) {
            return new UrlPath(list.subList(n2, list.size()));
        }
        return new UrlPath(list);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof UrlTargetInfoFakeElement)) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    @JvmOverloads
    public UrlPathReference(@NotNull UrlPathContext context2, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore, @NotNull PathSegmentHandler pathSegmentHandler) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)pathSegmentHandler, (String)"pathSegmentHandler");
        this(context2, host, range, isAtEnd, shouldHaveSlashBefore, pathSegmentHandler, null, 64, null);
    }

    @JvmOverloads
    public UrlPathReference(@NotNull UrlPathContext context2, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(context2, host, range, isAtEnd, shouldHaveSlashBefore, null, null, 96, null);
    }

    @JvmOverloads
    public UrlPathReference(@NotNull UrlPathContext context2, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(context2, host, range, isAtEnd, false, null, null, 112, null);
    }

    private static final String j(UrlPathReference urlPathReference) {
        Intrinsics.checkNotNullParameter((Object)urlPathReference, (String)"this$0");
        return urlPathReference.getValue();
    }

    private static final LookupElement j(UrlPathReference urlPathReference, UrlResolveRequest urlResolveRequest, List<? extends UrlPath.PathSegment> list, List<? extends UrlPath.PathSegment> list2, UrlTargetInfo urlTargetInfo, boolean bl) {
        return urlPathReference.pathSegmentHandler.createLookupElement(urlResolveRequest, list, list2, urlTargetInfo, urlPathReference.shouldHaveSlashBefore ? "/" : "", urlPathReference.isAtEnd && bl ? "/" : "", bl);
    }

    @JvmStatic
    @NotNull
    public static final NavigatablePsiElement createSearchableElement(@NotNull Project project2, @NotNull UrlPathContext urlPathContext) {
        return Companion.createSearchableElement(project2, urlPathContext);
    }

    @JvmStatic
    @Nullable
    public static final NavigatablePsiElement createSearchableElement(@NotNull Project project2, @NotNull UrlTargetInfo targetInfo) {
        return Companion.createSearchableElement(project2, targetInfo);
    }

    @JvmStatic
    @Nullable
    public static final UrlPathReference getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
        return Companion.getFromPomTargetPsiElement(psiElement);
    }

    public static final /* synthetic */ UrlPath access$remainingPath(UrlPathReference $this, UrlPath currentPath, UrlPath variantPath) {
        return $this.j(currentPath, variantPath);
    }

    public static final /* synthetic */ PathSegmentHandler access$getPathSegmentHandler$p(UrlPathReference $this) {
        return $this.pathSegmentHandler;
    }

    public static final /* synthetic */ LookupElement access$getVariantsIterator$mkLookup(UrlPathReference this$0, UrlResolveRequest context2, List exactPrefix, List pathToComplete, UrlTargetInfo variant, boolean hasSomethingNext) {
        return UrlPathReference.j(this$0, context2, exactPrefix, pathToComplete, variant, hasSomethingNext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$Companion;", "", "()V", "createSearchableElement", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "getFromPomTargetPsiElement", "Lcom/intellij/microservices/url/references/UrlPathReference;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NavigatablePsiElement createSearchableElement(@NotNull Project project2, @NotNull UrlPathContext urlPathContext) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
            UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = new UrlPathReferenceUnifiedPomTarget(urlPathContext, project2);
            return (NavigatablePsiElement)new UrlTargetInfoFakeElement(project2, urlPathReferenceUnifiedPomTarget, null, urlPathContext.isDeclaration());
        }

        @JvmStatic
        @Nullable
        public final NavigatablePsiElement createSearchableElement(@NotNull Project project2, @NotNull UrlTargetInfo targetInfo) {
            UrlTargetInfo urlTargetInfo;
            UrlPathContext urlPathContext;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            UrlPath urlPath = UrlPathContextKt.chopTrailingEmptyBlock(targetInfo.getPath());
            if (!Intrinsics.areEqual((Object)urlPath, (Object)UrlPath.Companion.getEMPTY()) && CollectionsKt.any((urlPathContext = new UrlPathContext(urlTargetInfo = Intrinsics.areEqual((Object)urlPath, (Object)targetInfo.getPath()) ? targetInfo : (UrlTargetInfo)new UrlTargetInfoWrapper(targetInfo, urlPath))).getResolveRequests())) {
                return this.createSearchableElement(project2, urlPathContext);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final UrlPathReference getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            UrlTargetInfoFakeElement urlTargetInfoFakeElement = psiElement instanceof UrlTargetInfoFakeElement ? (UrlTargetInfoFakeElement)psiElement : null;
            return urlTargetInfoFakeElement != null ? urlTargetInfoFakeElement.getReference() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$UrlPathLookupObject;", "", "url", "", "(Ljava/lang/String;)V", "j", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.microservices"})
    public static final class UrlPathLookupObject {
        @NotNull
        private final String url;

        public UrlPathLookupObject(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            this.url = url2;
        }

        @NotNull
        public String toString() {
            return this.url;
        }

        private final String j() {
            return this.url;
        }

        @NotNull
        public final UrlPathLookupObject copy(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return new UrlPathLookupObject(url2);
        }

        public static /* synthetic */ UrlPathLookupObject copy$default(UrlPathLookupObject urlPathLookupObject, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = urlPathLookupObject.url;
            }
            return urlPathLookupObject.copy(string);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlPathLookupObject)) {
                return false;
            }
            UrlPathLookupObject urlPathLookupObject = (UrlPathLookupObject)other;
            return Intrinsics.areEqual((Object)this.url, (Object)urlPathLookupObject.url);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$UrlTargetInfoFakeElement;", "Lcom/intellij/microservices/utils/CommonFakeNavigatablePomTarget;", "Lcom/intellij/microservices/url/references/UrlSegmentReferenceTarget;", "project", "Lcom/intellij/openapi/project/Project;", "unifiedPomTarget", "Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;", "reference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "forceFindUsages", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;Lcom/intellij/microservices/url/references/UrlPathReference;Z)V", "getReference", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "canNavigateToSource", "navigate", "", "requestFocus", "intellij.microservices"})
    private static final class UrlTargetInfoFakeElement
    extends CommonFakeNavigatablePomTarget
    implements UrlSegmentReferenceTarget {
        @NotNull
        private final UrlPathReferenceUnifiedPomTarget unifiedPomTarget;
        @Nullable
        private final UrlPathReference reference;
        private final boolean forceFindUsages;

        public UrlTargetInfoFakeElement(@NotNull Project project2, @NotNull UrlPathReferenceUnifiedPomTarget unifiedPomTarget2, @Nullable UrlPathReference reference, boolean forceFindUsages) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)unifiedPomTarget2, (String)"unifiedPomTarget");
            super(project2, (PomRenameableTarget<? extends Object>)((PomRenameableTarget)unifiedPomTarget2));
            this.unifiedPomTarget = unifiedPomTarget2;
            this.reference = reference;
            this.forceFindUsages = forceFindUsages;
        }

        @Nullable
        public final UrlPathReference getReference() {
            return this.reference;
        }

        public boolean canNavigateToSource() {
            UrlPathReference urlPathReference = this.reference;
            return (urlPathReference != null ? urlPathReference.customNavigate : null) != null || super.canNavigateToSource();
        }

        @Override
        public void navigate(boolean requestFocus) {
            UrlPathReference urlPathReference = this.reference;
            if ((urlPathReference != null ? urlPathReference.customNavigate : null) != null) {
                this.reference.customNavigate.invoke((Object)this.reference);
                return;
            }
            if (this.forceFindUsages) {
                this.showFindUsages();
                return;
            }
            MicroservicesUsageCollector.INSTANCE.getURL_PATH_SEGMENT_NAVIGATE_EVENT().log(this.getProject());
            if (this.unifiedPomTarget.canNavigate()) {
                this.unifiedPomTarget.navigate(requestFocus);
            } else {
                super.navigate(requestFocus);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010*\u001a\u0004\u0018\u00010\u0011H\u0096\u0001R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0014\u0010'\u001a\u00020\r8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$UrlTargetInfoWrapper;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "original", "newPath", "Lcom/intellij/microservices/url/UrlPath;", "(Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/microservices/url/UrlPath;)V", "authorities", "", "Lcom/intellij/microservices/url/Authority;", "getAuthorities", "()Ljava/util/List;", "contentTypes", "", "", "getContentTypes", "()Ljava/util/Set;", "documentationPsiElement", "Lcom/intellij/psi/PsiElement;", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "methods", "getMethods", "path", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "schemes", "getSchemes", "source", "getSource", "()Ljava/lang/String;", "resolveToPsiElement", "intellij.microservices"})
    private static final class UrlTargetInfoWrapper
    implements UrlTargetInfo {
        @NotNull
        private final UrlTargetInfo original;
        @NotNull
        private final UrlPath newPath;

        public UrlTargetInfoWrapper(@NotNull UrlTargetInfo original, @NotNull UrlPath newPath) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            this.original = original;
            this.newPath = newPath;
        }

        @Override
        @NotNull
        public List<Authority> getAuthorities() {
            return this.original.getAuthorities();
        }

        @Override
        @NotNull
        public Set<String> getContentTypes() {
            return this.original.getContentTypes();
        }

        @Override
        @Nullable
        public PsiElement getDocumentationPsiElement() {
            return this.original.getDocumentationPsiElement();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.original.getIcon();
        }

        @Override
        public boolean isDeprecated() {
            return this.original.isDeprecated();
        }

        @Override
        @NotNull
        public Set<String> getMethods() {
            return this.original.getMethods();
        }

        @Override
        @NotNull
        public Iterable<UrlQueryParameter> getQueryParameters() {
            return this.original.getQueryParameters();
        }

        @Override
        @NotNull
        public List<String> getSchemes() {
            return this.original.getSchemes();
        }

        @Override
        @NotNull
        public String getSource() {
            return this.original.getSource();
        }

        @Override
        @Nullable
        public PsiElement resolveToPsiElement() {
            return this.original.resolveToPsiElement();
        }

        @Override
        @NotNull
        public UrlPath getPath() {
            return this.newPath;
        }
    }
}

