/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001f\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\r\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a0\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0013\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0015*\u00020\u0015\u001a\n\u0010\u0007\u001a\u00020\u0015*\u00020\u0015\u001a\u001c\u0010\u0016\u001a\u00020\u000f*\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"canBuildUrlContext", "Ljava/lang/ThreadLocal;", "", "chopLeadingEmptyBlock", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segments", "chopTrailingEmptyBlock", "forbidExpensiveUrlContext", "T", "call", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "j", "applyFromParsed", "Lcom/intellij/microservices/url/references/UrlPathContext;", "parsedUrl", "Lcom/intellij/microservices/url/references/UrlPksParser$ParsedPksUrl;", "scheme", "auth", "path", "Lcom/intellij/microservices/url/UrlPath;", "configureFromStringHeuristically", "url", "", "specification", "Lcom/intellij/microservices/url/FrameworkUrlPathSpecification;", "resolveTargets", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathContext.kt\ncom/intellij/microservices/url/references/UrlPathContextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public final class UrlPathContextKt {
    @NotNull
    private static final ThreadLocal<Boolean> canBuildUrlContext;

    @NotNull
    public static final Set<UrlTargetInfo> resolveTargets(@NotNull UrlPathContext $this$resolveTargets, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        UrlResolverManager urlResolverManager = UrlResolverManager.Companion.getInstance(project2);
        return UrlPathModelKt.filterBestUrlPathMatches$default(SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence($this$resolveTargets.getResolveRequests()), (Function1)((Function1)new Function1<UrlResolveRequest, Sequence<? extends UrlTargetInfo>>(urlResolverManager){
            final /* synthetic */ UrlResolverManager $urlResolver;
            {
                this.$urlResolver = $urlResolver;
                super(1);
            }

            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlResolveRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.asSequence(this.$urlResolver.resolve(it));
            }
        }))), null, 2, null);
    }

    @NotNull
    public static final UrlPathContext applyFromParsed(@NotNull UrlPathContext $this$applyFromParsed, @NotNull UrlPksParser.ParsedPksUrl parsedUrl, boolean scheme, boolean auth, boolean path) {
        UrlPathContext urlPathContext;
        block9: {
            Object object;
            block10: {
                Object object2;
                block7: {
                    Object object3;
                    block8: {
                        Object object4;
                        Intrinsics.checkNotNullParameter((Object)$this$applyFromParsed, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)parsedUrl, (String)"parsedUrl");
                        urlPathContext = null;
                        urlPathContext = $this$applyFromParsed;
                        if (!scheme) break block7;
                        object3 = parsedUrl.getScheme();
                        if (object3 == null || (object3 = object3.getValueIfKnown()) == null) break block8;
                        object2 = object4 = object3;
                        boolean bl = false;
                        object3 = ((CharSequence)object2).length() > 0 ? object4 : null;
                        if (object3 == null) break block8;
                        Object object5 = object3;
                        boolean bl2 = false;
                        UrlPathContext urlPathContext2 = urlPathContext.withSchemes(SetsKt.setOf((Object)object5));
                        object3 = urlPathContext2;
                        if (urlPathContext2 != null) break block7;
                    }
                    object3 = urlPathContext = urlPathContext;
                }
                if (!auth) break block9;
                object = parsedUrl.getAuthority();
                if (object == null || (object = object.getValueIfKnown()) == null) break block10;
                object2 = object;
                boolean bl = false;
                UrlPathContext urlPathContext3 = urlPathContext.withAuthorities(SetsKt.setOf((Object)object2));
                object = urlPathContext3;
                if (urlPathContext3 != null) break block9;
            }
            object = urlPathContext = urlPathContext;
        }
        if (path) {
            UrlPath urlPath = parsedUrl.getUrlPath();
            boolean bl = false;
            urlPathContext = urlPathContext.subContext(urlPath);
        }
        return urlPathContext;
    }

    public static /* synthetic */ UrlPathContext applyFromParsed$default(UrlPathContext urlPathContext, UrlPksParser.ParsedPksUrl parsedPksUrl, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        return UrlPathContextKt.applyFromParsed(urlPathContext, parsedPksUrl, bl, bl2, bl3);
    }

    @NotNull
    public static final UrlPathContext configureFromStringHeuristically(@NotNull UrlPathContext $this$configureFromStringHeuristically, @Nullable String url2, @NotNull FrameworkUrlPathSpecification specification) {
        Intrinsics.checkNotNullParameter((Object)$this$configureFromStringHeuristically, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (url2 == null) {
            return $this$configureFromStringHeuristically;
        }
        PartiallyKnownString partiallyKnownString = new PartiallyKnownString(url2);
        UrlPathContext urlPathContext = $this$configureFromStringHeuristically;
        UrlPksParser.ParsedPksUrl parsedPksUrl = specification.getParser().parseFullUrl(partiallyKnownString);
        PartiallyKnownString partiallyKnownString2 = parsedPksUrl.getAuthority();
        CharSequence charSequence = partiallyKnownString2 != null ? partiallyKnownString2.getValueIfKnown() : null;
        urlPathContext = !(charSequence == null || charSequence.length() == 0) ? UrlPathContextKt.applyFromParsed$default(urlPathContext, parsedPksUrl, false, false, false, 14, null) : urlPathContext.subContext(specification.getParser().parseUrlPath(partiallyKnownString).getUrlPath());
        return urlPathContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T forbidExpensiveUrlContext(@NotNull Function0<? extends T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Boolean bl = canBuildUrlContext.get();
        try {
            canBuildUrlContext.set(false);
            Object object = call.invoke();
            return (T)object;
        }
        finally {
            canBuildUrlContext.set(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final UrlPath chopLeadingEmptyBlock(@NotNull UrlPath $this$chopLeadingEmptyBlock) {
        UrlPath urlPath;
        Intrinsics.checkNotNullParameter((Object)$this$chopLeadingEmptyBlock, (String)"<this>");
        if ($this$chopLeadingEmptyBlock != UrlPath.Companion.getEMPTY()) {
            UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull($this$chopLeadingEmptyBlock.getSegments());
            boolean bl = pathSegment != null ? pathSegment.isEmpty() : false;
            if (bl) {
                List<UrlPath.PathSegment> list = UrlPathContextKt.N($this$chopLeadingEmptyBlock.getSegments());
                if (list.isEmpty()) {
                    urlPath = UrlPath.Companion.getEMPTY();
                    return urlPath;
                }
                urlPath = new UrlPath(list);
                return urlPath;
            }
        }
        urlPath = $this$chopLeadingEmptyBlock;
        return urlPath;
    }

    @NotNull
    public static final UrlPath chopTrailingEmptyBlock(@NotNull UrlPath $this$chopTrailingEmptyBlock) {
        List<UrlPath.PathSegment> list;
        Intrinsics.checkNotNullParameter((Object)$this$chopTrailingEmptyBlock, (String)"<this>");
        return $this$chopTrailingEmptyBlock != UrlPath.Companion.getEMPTY() && UrlPathContextKt.j($this$chopTrailingEmptyBlock.getSegments()) ? ((list = UrlPathContextKt.j($this$chopTrailingEmptyBlock.getSegments())).isEmpty() ? UrlPath.Companion.getEMPTY() : new UrlPath(list)) : $this$chopTrailingEmptyBlock;
    }

    private static final List<UrlPath.PathSegment> N(List<? extends UrlPath.PathSegment> list) {
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull(list);
        return (pathSegment != null ? pathSegment.isEmpty() : false) ? list.subList(1, list.size()) : list;
    }

    private static final List<UrlPath.PathSegment> j(List<? extends UrlPath.PathSegment> list) {
        return UrlPathContextKt.j(list) ? list.subList(0, list.size() - 1) : list;
    }

    private static final boolean j(List<? extends UrlPath.PathSegment> list) {
        return list.size() > 1 && ((UrlPath.PathSegment)CollectionsKt.last(list)).isEmpty();
    }

    private static final Boolean j() {
        return true;
    }

    public static final /* synthetic */ ThreadLocal access$getCanBuildUrlContext$p() {
        return canBuildUrlContext;
    }

    public static final /* synthetic */ List access$chopTrailingEmptyBlock(List segments) {
        return UrlPathContextKt.j(segments);
    }

    public static final /* synthetic */ List access$chopLeadingEmptyBlock(List segments) {
        return UrlPathContextKt.N(segments);
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(UrlPathContextKt::j);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        canBuildUrlContext = threadLocal;
    }
}

