/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/url/MultiPathBestMatcher;", "", "()V", "bestResolveMatches", "Ljava/util/HashSet;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "longestMatchLength", "", "addBestMatching", "all", "", "original", "Lcom/intellij/microservices/url/UrlPath;", "getResult", "", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/MultiPathBestMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,337:1\n1774#2,4:338\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/MultiPathBestMatcher\n*L\n315#1:338,4\n*E\n"})
public final class MultiPathBestMatcher {
    @NotNull
    private final HashSet<UrlTargetInfo> bestResolveMatches = new HashSet();
    private int longestMatchLength = 1;

    @NotNull
    public final MultiPathBestMatcher addBestMatching(@NotNull Iterable<? extends UrlTargetInfo> all, @Nullable UrlPath original) {
        Intrinsics.checkNotNullParameter(all, (String)"all");
        for (UrlTargetInfo urlTargetInfo : all) {
            int n2;
            UrlPath urlPath = original;
            if (urlPath != null) {
                v1 = urlPath.commonLength(urlTargetInfo.getPath());
            } else {
                Iterable iterable = urlTargetInfo.getPath().getSegments();
                boolean bl = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    v1 = 0;
                } else {
                    int n3 = 0;
                    for (Object t10 : iterable) {
                        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)t10;
                        boolean bl2 = false;
                        if (!(pathSegment instanceof UrlPath.PathSegment.Exact) || ++n3 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v1 = n2 = n3;
                }
            }
            if (n2 > this.longestMatchLength) {
                this.longestMatchLength = n2;
                this.bestResolveMatches.clear();
                this.bestResolveMatches.add(urlTargetInfo);
                continue;
            }
            if (n2 != this.longestMatchLength) continue;
            this.bestResolveMatches.add(urlTargetInfo);
        }
        return this;
    }

    public static /* synthetic */ MultiPathBestMatcher addBestMatching$default(MultiPathBestMatcher multiPathBestMatcher, Iterable iterable, UrlPath urlPath, int n2, Object object) {
        if ((n2 & 2) != 0) {
            urlPath = null;
        }
        return multiPathBestMatcher.addBestMatching(iterable, urlPath);
    }

    @NotNull
    public final Set<UrlTargetInfo> getResult() {
        return this.bestResolveMatches;
    }
}

