/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mq;

import com.intellij.microservices.mq.DestinationMQType;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQModelKt;
import com.intellij.microservices.mq.MQResolver;
import com.intellij.microservices.mq.MQResolverFactory;
import com.intellij.microservices.mq.MQResolverManager;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.NamedMQType;
import com.intellij.microservices.mq.UnknownMQProviderType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006*\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/mq/MQResolverManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allResolvers", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/mq/MQResolver;", "j", "()Lkotlin/sequences/Sequence;", "getAllVariants", "Lcom/intellij/microservices/mq/MQTargetInfo;", "typeHint", "Lcom/intellij/microservices/mq/MQType;", "j", "", "resolver", "j", "getVariants", "j", "Companion", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nMQResolverManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MQResolverManager.kt\ncom/intellij/microservices/mq/MQResolverManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,67:1\n614#2:68\n*S KotlinDebug\n*F\n+ 1 MQResolverManager.kt\ncom/intellij/microservices/mq/MQResolverManager\n*L\n22#1:68\n*E\n"})
public final class MQResolverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final ExtensionPointName<MQResolverFactory> EP_NAME = ExtensionPointName.Companion.create("com.intellij.microservices.mqResolverFactory");

    public MQResolverManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    private final Sequence<MQResolver> j() {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<MQResolverFactory, Sequence<? extends MQResolver>>(this){
            final /* synthetic */ MQResolverManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<MQResolver> invoke(@NotNull MQResolverFactory it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.asSequence((Iterable)it.forProject(MQResolverManager.access$getProject$p(this.this$0)));
            }
        }));
    }

    private final Sequence<MQResolver> j(MQType mQType) {
        Sequence sequence = SequencesKt.filter(this.j(), (Function1)((Function1)new Function1<MQResolver, Boolean>(mQType){
            final /* synthetic */ MQType $typeHint;
            {
                this.$typeHint = $typeHint;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MQResolver resolver) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
                    Iterable iterable = resolver.getSupportedTypes();
                    MQType mQType = this.$typeHint;
                    boolean bl2 = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl = false;
                    } else {
                        for (T t10 : iterable) {
                            MQType mQType2 = (MQType)t10;
                            boolean bl3 = false;
                            if (!MQModelKt.areMQTypesCompatible(mQType, mQType2)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
        boolean bl = false;
        return SequencesKt.sortedWith((Sequence)sequence, (Comparator)new Comparator(this){
            final /* synthetic */ MQResolverManager this$0;
            {
                this.this$0 = mQResolverManager;
            }

            public final int compare(T a2, T b2) {
                MQResolver mQResolver = (MQResolver)b2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(MQResolverManager.access$getPriority(this.this$0, mQResolver));
                mQResolver = (MQResolver)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(MQResolverManager.access$getPriority(this.this$0, mQResolver)));
            }
        });
    }

    private final int j(MQResolver mQResolver) {
        List<MQType> list = mQResolver.getSupportedTypes();
        if (list.isEmpty()) {
            return -100;
        }
        MQType mQType = (MQType)CollectionsKt.first(list);
        if (Intrinsics.areEqual((Object)mQType, (Object)UnknownMQProviderType.INSTANCE)) {
            return -1;
        }
        if (mQType instanceof DestinationMQType) {
            return 0;
        }
        if (mQType instanceof NamedMQType && ((NamedMQType)mQType).getDestinationType() == null) {
            return 1;
        }
        if (list.size() > 1) {
            return 10;
        }
        return 100;
    }

    @NotNull
    public final Sequence<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return this.j((Sequence<? extends MQTargetInfo>)SequencesKt.distinctBy(this.getAllVariants(typeHint), (Function1)getVariants.1.INSTANCE));
    }

    @NotNull
    public final Sequence<MQTargetInfo> getAllVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return DumbService.Companion.isDumb(this.project) ? SequencesKt.emptySequence() : SequencesKt.flatMap(this.j(typeHint), (Function1)((Function1)new Function1<MQResolver, Sequence<? extends MQTargetInfo>>(typeHint){
            final /* synthetic */ MQType $typeHint;
            {
                this.$typeHint = $typeHint;
                super(1);
            }

            @NotNull
            public final Sequence<MQTargetInfo> invoke(@NotNull MQResolver resolver) {
                Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
                return CollectionsKt.asSequence(resolver.getVariants(this.$typeHint));
            }
        }));
    }

    private final Sequence<MQTargetInfo> j(Sequence<? extends MQTargetInfo> sequence) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MQTargetInfo>, Continuation<? super Unit>, Object>(sequence, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<MQTargetInfo> $this_distinctMqIds;
            {
                this.$this_distinctMqIds = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Iterator iterator;
                HashMap<K, V> hashMap;
                SequenceScope sequenceScope;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        sequenceScope = (SequenceScope)this.L$0;
                        hashMap = new HashMap<K, V>();
                        iterator = this.$this_distinctMqIds.iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        iterator = (Iterator)this.L$2;
                        hashMap = (HashMap<K, V>)this.L$1;
                        sequenceScope = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator.hasNext()) {
                    MQType mQType;
                    MQTargetInfo mQTargetInfo = (MQTargetInfo)iterator.next();
                    String string = mQTargetInfo.getDestination().getName();
                    MQType mQType2 = mQTargetInfo.getDestination().getType();
                    Object object4 = (MQTargetInfo)hashMap.get(string);
                    MQType mQType3 = object4 != null && (object4 = object4.getDestination()) != null ? ((MQDestination)object4).getType() : (mQType = null);
                    if (mQType != null && (Intrinsics.areEqual((Object)mQType2, (Object)UnknownMQProviderType.INSTANCE) || Intrinsics.areEqual((Object)mQType2, (Object)mQType) || mQType2.isCompatibleWith(mQType))) continue;
                    ((Map)hashMap).put(string, mQTargetInfo);
                    this.L$0 = sequenceScope;
                    this.L$1 = hashMap;
                    this.L$2 = iterator;
                    this.label = 1;
                    object2 = sequenceScope.yield((Object)mQTargetInfo, (Continuation)this);
                    if (object2 != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super MQTargetInfo> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(MQResolverManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ int access$getPriority(MQResolverManager $this, MQResolver resolver) {
        return $this.j(resolver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/microservices/mq/MQResolverManager$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/microservices/mq/MQResolverFactory;", "getInstance", "Lcom/intellij/microservices/mq/MQResolverManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MQResolverManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return new MQResolverManager(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

