/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0012\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/microservices/http/HttpHeaderElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/psi/SyntheticElement;", "Lcom/intellij/psi/meta/PsiMetaOwner;", "Lcom/intellij/psi/meta/PsiPresentableMetaData;", "parent", "Lcom/intellij/psi/PsiElement;", "headerName", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "canNavigate", "", "equals", "other", "", "getDeclaration", "getIcon", "Ljavax/swing/Icon;", "getMetaData", "Lcom/intellij/psi/meta/PsiMetaData;", "getName", "context", "getNavigationElement", "getParent", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getTypeName", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "hashCode", "", "init", "", "element", "isEquivalentTo", "another", "navigate", "requestFocus", "intellij.microservices"})
public final class HttpHeaderElement
extends FakePsiElement
implements SyntheticElement,
PsiMetaOwner,
PsiPresentableMetaData {
    @NotNull
    private final PsiElement parent;
    @NotNull
    private final String headerName;

    public HttpHeaderElement(@NotNull PsiElement parent, @NotNull String headerName) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        this.parent = parent;
        this.headerName = headerName;
    }

    @NotNull
    public String getName() {
        return this.headerName;
    }

    @NotNull
    public PsiElement getParent() {
        return this.parent;
    }

    @NotNull
    public String getName(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getName();
    }

    @NotNull
    public PsiElement getDeclaration() {
        return (PsiElement)this;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }

    public void init(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Type;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Type");
        return icon;
    }

    @NotNull
    public PsiMetaData getMetaData() {
        return (PsiMetaData)this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return (PsiElement)this;
    }

    @NotNull
    public String getTypeName() {
        return MicroservicesBundle.message("http.header.element", new Object[0]);
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof HttpHeaderElement && Intrinsics.areEqual((Object)((HttpHeaderElement)another).headerName, (Object)this.headerName);
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project2).isDumb()) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        RelativePoint relativePoint2 = relativePoint;
        ShowUsagesAction.startFindUsages((PsiElement)((PsiElement)this), (RelativePoint)relativePoint2, (Editor)editor2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.http.HttpHeaderElement");
        HttpHeaderElement cfr_ignored_0 = (HttpHeaderElement)((Object)other);
        return Intrinsics.areEqual((Object)this.headerName, (Object)((HttpHeaderElement)((Object)other)).headerName);
    }

    public int hashCode() {
        return this.headerName.hashCode();
    }
}

