/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.ide.Prefs;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.N.N.m;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.JbaTokenAuthProvider;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CloudConfigClientUtil {
    private static final int TIMEOUT = 10000;
    public static final String INSTALLED_PLUGINS_FILENAME = "installed_plugins.txt";
    public static final String PLUGIN_RULES = "plugin_rules.txt";
    public static final String LOCAL_PLUGIN_RULES = "local_plugin_rules.txt";
    private static String myOsName;
    public static ETagCloudConfigFileClient testClient;
    public static Computable<ETagCloudConfigFileClient> clientBuilder;
    private static final UserController COMMON_CONTROLLER;
    private static final UserController OVERRIDE_CONTROLLER;
    private static final UserController DEBUG_CONTROLLER;

    @NotNull
    public static String getName() {
        String string = "/" + ApplicationNamesInfo.getInstance().getProductName() + (PluginManagerCore.isRunningFromSources() ? "-Snapshot/" : "/");
        if (string == null) {
            CloudConfigClientUtil.j(0);
        }
        return string;
    }

    @NotNull
    public static List<String> readPlugins(@NotNull String pluginList) {
        if (pluginList == null) {
            CloudConfigClientUtil.j(1);
        }
        List list = StringUtil.split((String)pluginList, (String)"\n");
        if (list == null) {
            CloudConfigClientUtil.j(2);
        }
        return list;
    }

    @NotNull
    public static String getOS() {
        if (myOsName == null) {
            myOsName = CloudConfigClientUtil.j();
        }
        String string = myOsName;
        if (string == null) {
            CloudConfigClientUtil.j(3);
        }
        return string;
    }

    @NotNull
    private static String j() {
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        if (SystemInfo.isFreeBSD) {
            return "freebsd";
        }
        if (SystemInfo.isUnix) {
            return "unix";
        }
        if (SystemInfo.isSolaris) {
            return "solaris";
        }
        if (SystemInfo.isChromeOS) {
            return "chrome";
        }
        return "unknown";
    }

    public static void loadFiles(@NotNull File archiveFile, @NotNull Collection<String> files2, @NotNull Map<String, String> result2) throws IOException {
        if (archiveFile == null) {
            CloudConfigClientUtil.j(4);
        }
        if (files2 == null) {
            CloudConfigClientUtil.j(5);
        }
        if (result2 == null) {
            CloudConfigClientUtil.j(6);
        }
        try (SevenZFile sevenZFile = new SevenZFile(archiveFile);){
            while (!files2.isEmpty()) {
                SevenZArchiveEntry sevenZArchiveEntry = sevenZFile.getNextEntry();
                if (sevenZArchiveEntry == null) {
                    break;
                }
                if (sevenZArchiveEntry.isDirectory() || !files2.remove(sevenZArchiveEntry.getName())) continue;
                byte[] byArray = CloudConfigClientUtil.loadBytes(sevenZFile, (int)sevenZArchiveEntry.getSize());
                result2.put(sevenZArchiveEntry.getName(), new String(byArray, StandardCharsets.UTF_8));
            }
        }
    }

    public static byte @NotNull [] loadBytes(@NotNull SevenZFile reader, int length) throws IOException {
        int n2;
        int n3;
        if (reader == null) {
            CloudConfigClientUtil.j(7);
        }
        byte[] byArray = new byte[length];
        for (n2 = 0; n2 < byArray.length && (n3 = reader.read(byArray, n2, byArray.length - n2)) > 0; n2 += n3) {
        }
        if (n2 == byArray.length) {
            if (byArray == null) {
                CloudConfigClientUtil.j(8);
            }
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (byArray2 == null) {
            CloudConfigClientUtil.j(9);
        }
        return byArray2;
    }

    @Nullable
    public static ETagCloudConfigFileClient createClient() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            return testClient;
        }
        if (clientBuilder != null) {
            ETagCloudConfigFileClient eTagCloudConfigFileClient = (ETagCloudConfigFileClient)clientBuilder.get();
            clientBuilder = null;
            return eTagCloudConfigFileClient;
        }
        Configuration configuration = CloudConfigClientUtil.j();
        return configuration == null ? null : new ETagCloudConfigFileClient(configuration);
    }

    @Nullable
    private static Configuration j() {
        String string = CloudConfigClientUtil.getUserId();
        if (string == null) {
            return null;
        }
        return new Configuration().connectTimeout(10000).readTimeout(10000).auth((AuthProvider)new JbaTokenAuthProvider(string){

            public void authenticate(HttpURLConnection connection) {
                super.authenticate(connection);
                if (connection instanceof HttpsURLConnection) {
                    SSLContext sSLContext = m.j();
                    assert (sSLContext != null);
                    ((HttpsURLConnection)connection).setSSLSocketFactory(sSLContext.getSocketFactory());
                }
            }
        });
    }

    private static boolean j() {
        return Boolean.getBoolean("idea.cloud.config.debug");
    }

    @Nullable
    public static String getUserLogin() {
        if (CloudConfigClientUtil.j()) {
            return DEBUG_CONTROLLER.j();
        }
        String string = OVERRIDE_CONTROLLER.j();
        return string == null ? COMMON_CONTROLLER.j() : string;
    }

    @Nullable
    static String getUserId() {
        if (CloudConfigClientUtil.j()) {
            String string = DEBUG_CONTROLLER.j();
            return string == null ? null : DEBUG_CONTROLLER.N();
        }
        String string = OVERRIDE_CONTROLLER.j();
        return string == null ? COMMON_CONTROLLER.N() : OVERRIDE_CONTROLLER.N();
    }

    public static void setUserAndId(@NotNull String login2, @NotNull String id) {
        if (login2 == null) {
            CloudConfigClientUtil.j(10);
        }
        if (id == null) {
            CloudConfigClientUtil.j(11);
        }
        UserController userController = CloudConfigClientUtil.j() ? DEBUG_CONTROLLER : OVERRIDE_CONTROLLER;
        userController.j(login2, id);
    }

    public static boolean isNewSettingsSyncEnabled() {
        return SystemProperties.getBooleanProperty((String)"idea.settings.sync.enabled", (boolean)true);
    }

    static {
        COMMON_CONTROLLER = new UserController("JetBrains.JetProfile.UserLogin", "JetBrains.JetProfile.UserId", "The Drive to Develop.");
        OVERRIDE_CONTROLLER = new UserController("JetBrains.SyncSettings.User", "JetBrains.SyncSettings.Id", "yesuGibuLiavibUyuroV.");
        DEBUG_CONTROLLER = new UserController("JetBrains.SyncSettings.Debug.User", "JetBrains.SyncSettings.Debug.Id", "Develop with Pleasure");
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 4, 5, 6, 7, 10, 11 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/cloudConfig/CloudConfigClientUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "login";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/cloudConfig/CloudConfigClientUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readPlugins";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOS";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUserAndId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static final class UserController {
        @NotNull
        private final String myUserKey;
        @NotNull
        private final String myIdKey;
        private final byte[] mySecret;

        private UserController(@NotNull String userKey, @NotNull String idKey, @NotNull String secret) {
            if (userKey == null) {
                UserController.j(0);
            }
            if (idKey == null) {
                UserController.j(1);
            }
            if (secret == null) {
                UserController.j(2);
            }
            this.myUserKey = userKey;
            this.myIdKey = idKey;
            this.mySecret = secret.getBytes(StandardCharsets.UTF_8);
        }

        @Nullable
        private String j() {
            return this.j(this.myUserKey);
        }

        @Nullable
        private String N() {
            return this.j(this.myIdKey);
        }

        private void j(@NotNull String string, @NotNull String string2) {
            if (string == null) {
                UserController.j(3);
            }
            if (string2 == null) {
                UserController.j(4);
            }
            this.N(this.myUserKey, string);
            this.N(this.myIdKey, string2);
        }

        @Nullable
        private String j(@NotNull String string) {
            String string2;
            if (string == null) {
                UserController.j(5);
            }
            return (string2 = Prefs.get((String)string, null)) == null ? null : this.j(string2, false);
        }

        private void N(@NotNull String string, @NotNull String string2) {
            if (string == null) {
                UserController.j(6);
            }
            if (string2 == null) {
                UserController.j(7);
            }
            Prefs.put((String)string, (String)this.j(string2, true));
        }

        private String j(@NotNull String string, boolean bl) {
            if (string == null) {
                UserController.j(8);
            }
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (bl) {
                return new String(Base64.getMimeEncoder().encode(this.j(byArray)), StandardCharsets.UTF_8);
            }
            return new String(this.j(Base64.getMimeDecoder().decode(byArray)), StandardCharsets.UTF_8);
        }

        private byte[] j(byte[] byArray) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] ^ this.mySecret[i2 % this.mySecret.length]);
            }
            return byArray;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secret";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idValue";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/cloudConfig/CloudConfigClientUtil$UserController";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUserAndId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

