/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.util;

import com.intellij.cidr.cpp.lexer.CidrRawStringLexerBase;
import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStringLiteralUtil {
    private static final Logger LOG = Logger.getInstance(CidrStringLiteralUtil.class);
    protected static final Map<String, CidrStringPrefix> STR_PREFIX_TYPE = new HashMap<String, CidrStringPrefix>(CidrStringPrefix.values().length, 1.0f);
    protected static final Map<String, CidrCharType> CHAR_PREFIX_TYPE = new HashMap<String, CidrCharType>(4, 1.0f);

    public static boolean isStringLiteralPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CidrStringLiteralUtil.j(0);
        }
        return STR_PREFIX_TYPE.containsKey(prefix);
    }

    @SafeVarargs
    @NotNull
    public static <T extends CidrStringLiteral> T concatStrings(CidrStringCodec<T> stringCodec, T ... stringLiterals) {
        if (stringLiterals == null) {
            CidrStringLiteralUtil.j(1);
        }
        CidrStringPrefix cidrStringPrefix = CidrStringPrefix.PREFIX_EMPTY;
        StringBuilder stringBuilder = new StringBuilder();
        for (T t10 : stringLiterals) {
            String string;
            CidrStringPrefix cidrStringPrefix2;
            if (cidrStringPrefix.encoding == ((CidrStringLiteral)t10).prefix.encoding || cidrStringPrefix.encoding == CidrEncoding.NONE || ((CidrStringLiteral)t10).prefix.encoding == CidrEncoding.NONE) {
                CidrStringPrefix cidrStringPrefix3 = cidrStringPrefix2 = cidrStringPrefix.encoding != CidrEncoding.NONE ? cidrStringPrefix : ((CidrStringLiteral)t10).prefix;
                if (cidrStringPrefix.isRaw || ((CidrStringLiteral)t10).prefix.isRaw) {
                    cidrStringPrefix2 = CidrStringPrefix.setRaw(cidrStringPrefix2, true);
                }
                if (cidrStringPrefix.isRaw != cidrStringPrefix2.isRaw) {
                    var10_10 = stringBuilder.toString();
                    stringBuilder = new StringBuilder(cidrStringPrefix2.isRaw ? StringUtil.unescapeStringCharacters((String)var10_10) : StringUtil.escapeStringCharacters((String)var10_10));
                }
                string = ((CidrStringLiteral)t10).getContents(!cidrStringPrefix2.isRaw);
            } else {
                cidrStringPrefix2 = CidrStringPrefix.setRaw(cidrStringPrefix, false);
                var10_10 = cidrStringPrefix2.encoding.getString(((CidrStringLiteral)t10).prefix.encoding.getBytes(((CidrStringLiteral)t10).getContents(false)));
                if (cidrStringPrefix.isRaw != cidrStringPrefix2.isRaw) {
                    stringBuilder = new StringBuilder(StringUtil.escapeStringCharacters((String)stringBuilder.toString()));
                }
                string = StringUtil.escapeStringCharacters((String)var10_10);
            }
            stringBuilder.append(string);
            cidrStringPrefix = cidrStringPrefix2;
        }
        T t11 = stringCodec.createStringLiteral(cidrStringPrefix, stringBuilder.toString());
        if (t11 == null) {
            CidrStringLiteralUtil.j(2);
        }
        return t11;
    }

    @NotNull
    public static <T extends CidrStringLiteral> T parseStringLiteral(@NotNull CidrStringCodec<T> stringCodec, @Nullable String literalText) {
        String string;
        if (stringCodec == null) {
            CidrStringLiteralUtil.j(3);
        }
        if (literalText == null) {
            T t10 = stringCodec.getBadLiteral();
            if (t10 == null) {
                CidrStringLiteralUtil.j(4);
            }
            return t10;
        }
        int n2 = literalText.length();
        if (n2 == 0) {
            T t11 = stringCodec.getBadLiteral();
            if (t11 == null) {
                CidrStringLiteralUtil.j(5);
            }
            return t11;
        }
        int n3 = 34;
        int n4 = literalText.indexOf(34);
        if (n4 == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            T t12 = stringCodec.getBadLiteral();
            if (t12 == null) {
                CidrStringLiteralUtil.j(6);
            }
            return t12;
        }
        String string2 = literalText.substring(0, n4);
        CidrStringPrefix cidrStringPrefix = STR_PREFIX_TYPE.get(string2);
        if (cidrStringPrefix == null) {
            T t13 = stringCodec.getBadLiteral();
            if (t13 == null) {
                CidrStringLiteralUtil.j(7);
            }
            return t13;
        }
        if (n4 == n2 - 1) {
            string = "";
        } else {
            string = literalText.substring(n4 + 1);
            if (cidrStringPrefix.isRaw) {
                CidrRawStringLexerBase cidrRawStringLexerBase = stringCodec.createRawStringLexer();
                cidrRawStringLexerBase.start(literalText, n4, n2);
                string = cidrRawStringLexerBase.getRawText();
            } else if (literalText.charAt(n2 - 1) == '\"') {
                string = string.substring(0, string.length() - 1);
            }
        }
        T t14 = stringCodec.createStringLiteral(cidrStringPrefix, string);
        if (t14 == null) {
            CidrStringLiteralUtil.j(8);
        }
        return t14;
    }

    static {
        for (CidrStringPrefix cidrStringPrefix : CidrStringPrefix.values()) {
            STR_PREFIX_TYPE.put(cidrStringPrefix.prefix, cidrStringPrefix);
        }
        CHAR_PREFIX_TYPE.put("", CidrCharType.CHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("L", CidrCharType.WCHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("u", CidrCharType.CHAR16_LITERAL);
        CHAR_PREFIX_TYPE.put("U", CidrCharType.CHAR32_LITERAL);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiterals";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCodec";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "concatStrings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStringLiteral";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "concatStrings";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseStringLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class CidrStringPrefix
    extends Enum<CidrStringPrefix> {
        public static final /* enum */ CidrStringPrefix PREFIX_EMPTY = new CidrStringPrefix("", false, CidrEncoding.NONE, CidrIntType.CHAR, CidrIntType.CHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_R = new CidrStringPrefix("R", true, CidrEncoding.NONE, CidrIntType.CHAR, CidrIntType.CHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_L = new CidrStringPrefix("L", false, CidrEncoding.WCHAR, CidrIntType.WCHAR, CidrIntType.WCHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_LR = new CidrStringPrefix("LR", true, CidrEncoding.WCHAR, CidrIntType.WCHAR, CidrIntType.WCHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_u8 = new CidrStringPrefix("u8", false, CidrEncoding.UTF8, CidrIntType.CHAR, CidrIntType.CHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_u8R = new CidrStringPrefix("u8R", true, CidrEncoding.UTF8, CidrIntType.CHAR, CidrIntType.CHAR_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_u = new CidrStringPrefix("u", false, CidrEncoding.UTF16, CidrIntType.CHAR16, CidrIntType.CHAR16_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_uR = new CidrStringPrefix("uR", true, CidrEncoding.UTF16, CidrIntType.CHAR16, CidrIntType.CHAR16_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_U = new CidrStringPrefix("U", false, CidrEncoding.UTF32, CidrIntType.CHAR32, CidrIntType.CHAR32_CONST);
        public static final /* enum */ CidrStringPrefix PREFIX_UR = new CidrStringPrefix("UR", true, CidrEncoding.UTF32, CidrIntType.CHAR32, CidrIntType.CHAR32_CONST);
        @NotNull
        public final String prefix;
        public final boolean isRaw;
        @NotNull
        public final CidrEncoding encoding;
        @NotNull
        public final CidrIntType charTypePlainC;
        @NotNull
        public final CidrIntType charTypeCpp;
        private static final /* synthetic */ CidrStringPrefix[] $VALUES;

        public static CidrStringPrefix[] values() {
            return (CidrStringPrefix[])$VALUES.clone();
        }

        public static CidrStringPrefix valueOf(String name) {
            return Enum.valueOf(CidrStringPrefix.class, name);
        }

        private CidrStringPrefix(@NotNull String prefix, @NotNull boolean isRaw, @NotNull CidrEncoding encoding, CidrIntType charTypePlainC, CidrIntType charTypeCpp) {
            if (prefix == null) {
                CidrStringPrefix.j(0);
            }
            if (encoding == null) {
                CidrStringPrefix.j(1);
            }
            if (charTypePlainC == null) {
                CidrStringPrefix.j(2);
            }
            if (charTypeCpp == null) {
                CidrStringPrefix.j(3);
            }
            this.prefix = prefix;
            this.isRaw = isRaw;
            this.encoding = encoding;
            this.charTypePlainC = charTypePlainC;
            this.charTypeCpp = charTypeCpp;
        }

        public static CidrStringPrefix setRaw(CidrStringPrefix prefix, boolean raw) {
            if (raw) {
                return switch (prefix) {
                    case PREFIX_EMPTY -> PREFIX_R;
                    case PREFIX_L -> PREFIX_LR;
                    case PREFIX_u8 -> PREFIX_u8R;
                    case PREFIX_u -> PREFIX_uR;
                    case PREFIX_U -> PREFIX_UR;
                    default -> prefix;
                };
            }
            return switch (prefix) {
                case PREFIX_R -> PREFIX_EMPTY;
                case PREFIX_LR -> PREFIX_L;
                case PREFIX_u8R -> PREFIX_u8;
                case PREFIX_uR -> PREFIX_u;
                case PREFIX_UR -> PREFIX_U;
                default -> prefix;
            };
        }

        private static /* synthetic */ CidrStringPrefix[] j() {
            return new CidrStringPrefix[]{PREFIX_EMPTY, PREFIX_R, PREFIX_L, PREFIX_LR, PREFIX_u8, PREFIX_u8R, PREFIX_u, PREFIX_uR, PREFIX_U, PREFIX_UR};
        }

        static {
            $VALUES = CidrStringPrefix.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "encoding";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charTypePlainC";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charTypeCpp";
                    break;
                }
            }
            objectArray[1] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil$CidrStringPrefix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class CidrEncoding
    extends Enum<CidrEncoding> {
        public static final /* enum */ CidrEncoding NONE = new CidrEncoding(StandardCharsets.US_ASCII);
        public static final /* enum */ CidrEncoding WCHAR = new CidrEncoding(StandardCharsets.UTF_16LE);
        public static final /* enum */ CidrEncoding UTF8 = new CidrEncoding(StandardCharsets.UTF_8);
        public static final /* enum */ CidrEncoding UTF16 = new CidrEncoding(StandardCharsets.UTF_16LE);
        public static final /* enum */ CidrEncoding UTF32 = new CidrEncoding(CharsetToolkit.UTF_32LE_CHARSET);
        @NotNull
        private final Charset charset;
        private static final /* synthetic */ CidrEncoding[] $VALUES;

        public static CidrEncoding[] values() {
            return (CidrEncoding[])$VALUES.clone();
        }

        public static CidrEncoding valueOf(String name) {
            return Enum.valueOf(CidrEncoding.class, name);
        }

        private CidrEncoding(Charset charset) {
            if (charset == null) {
                CidrEncoding.j(0);
            }
            this.charset = charset;
        }

        @Contract(pure=true)
        public byte @NotNull [] getBytes(@NotNull String contents) {
            if (contents == null) {
                CidrEncoding.j(1);
            }
            byte[] byArray = contents.getBytes(this.charset);
            if (byArray == null) {
                CidrEncoding.j(2);
            }
            return byArray;
        }

        @NotNull
        public String getString(byte[] bytes) {
            String string = this.charset.decode(ByteBuffer.wrap(bytes)).toString();
            if (string == null) {
                CidrEncoding.j(3);
            }
            return string;
        }

        private static /* synthetic */ CidrEncoding[] j() {
            return new CidrEncoding[]{NONE, WCHAR, UTF8, UTF16, UTF32};
        }

        static {
            $VALUES = CidrEncoding.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charset";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil$CidrEncoding";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil$CidrEncoding";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBytes";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class CidrCharType
    extends Enum<CidrCharType> {
        public static final /* enum */ CidrCharType CHAR_LITERAL = new CidrCharType(CidrIntType.INT, CidrIntType.CHAR);
        public static final /* enum */ CidrCharType MULTICHAR_LITERAL = new CidrCharType(CidrIntType.INT);
        public static final /* enum */ CidrCharType WCHAR_LITERAL = new CidrCharType(CidrIntType.WCHAR);
        public static final /* enum */ CidrCharType CHAR16_LITERAL = new CidrCharType(CidrIntType.CHAR16);
        public static final /* enum */ CidrCharType CHAR32_LITERAL = new CidrCharType(CidrIntType.CHAR32);
        @NotNull
        public final CidrIntType typePlainC;
        @NotNull
        public final CidrIntType typeCpp;
        private static final /* synthetic */ CidrCharType[] $VALUES;

        public static CidrCharType[] values() {
            return (CidrCharType[])$VALUES.clone();
        }

        public static CidrCharType valueOf(String name) {
            return Enum.valueOf(CidrCharType.class, name);
        }

        private CidrCharType(CidrIntType type) {
            if (type == null) {
                CidrCharType.j(0);
            }
            this(type, type);
        }

        private CidrCharType(CidrIntType typePlainC, CidrIntType typeCpp) {
            if (typePlainC == null) {
                CidrCharType.j(1);
            }
            if (typeCpp == null) {
                CidrCharType.j(2);
            }
            this.typePlainC = typePlainC;
            this.typeCpp = typeCpp;
        }

        private static /* synthetic */ CidrCharType[] j() {
            return new CidrCharType[]{CHAR_LITERAL, MULTICHAR_LITERAL, WCHAR_LITERAL, CHAR16_LITERAL, CHAR32_LITERAL};
        }

        static {
            $VALUES = CidrCharType.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typePlainC";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeCpp";
                    break;
                }
            }
            objectArray[1] = "com/intellij/cidr/cpp/util/CidrStringLiteralUtil$CidrCharType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

