/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.util;

import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CidrStringLiteral {
    @NotNull
    public final CidrStringLiteralUtil.CidrStringPrefix prefix;
    @NotNull
    public final String contents;

    public CidrStringLiteral(@NotNull CidrStringLiteralUtil.CidrStringPrefix prefix, @NotNull String contents) {
        if (prefix == null) {
            CidrStringLiteral.j(0);
        }
        if (contents == null) {
            CidrStringLiteral.j(1);
        }
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (this.prefix.isRaw != escaped) {
            return this.contents;
        }
        if (escaped) {
            return StringUtil.escapeStringCharacters((String)this.contents);
        }
        return StringUtil.unescapeAnsiStringCharacters((String)this.contents);
    }

    @NotNull
    public CidrIntType getElementType(boolean isPlainOldC) {
        CidrIntType cidrIntType = isPlainOldC ? this.prefix.charTypePlainC : this.prefix.charTypeCpp;
        if (cidrIntType == null) {
            CidrStringLiteral.j(2);
        }
        return cidrIntType;
    }

    public int getContentLengthInCharacters() {
        String string = this.getContents(false);
        if (this.prefix.encoding == CidrStringLiteralUtil.CidrEncoding.UTF8) {
            byte[] byArray = this.prefix.encoding.getBytes(string);
            return byArray.length;
        }
        return string.length();
    }

    public String toString() {
        return "CidrStringLiteral{prefix=" + this.prefix + ", contents='" + this.contents + "'}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CidrStringLiteral cidrStringLiteral = (CidrStringLiteral)o2;
        if (this.prefix != cidrStringLiteral.prefix) {
            return false;
        }
        return this.contents.equals(cidrStringLiteral.contents);
    }

    public int hashCode() {
        int n2 = this.prefix.hashCode();
        n2 = 31 * n2 + this.contents.hashCode();
        return n2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/cpp/util/CidrStringLiteral";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/cpp/util/CidrStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

