/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrPrefixStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCHighlightingLexer
extends OCLexerWithDirectives {
    public static final char STRING_START = '\"';
    public static final char CHAR_START = '\'';

    @NotNull
    public static OCHighlightingLexer createDefault(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
        if (tokenTypeProvider == null) {
            OCHighlightingLexer.N(0);
        }
        return new OCHighlightingLexer(CidrLexerSettings.forLanguage(tokenTypeProvider, CLanguageKind.OBJ_CPP).forHighlighting().build());
    }

    @Contract(value="_, _ -> !null")
    @NotNull
    public static StringLiteralLexer createStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        return new CidrStringLiteralLexer(quoteChar, originalLiteralToken);
    }

    @Contract(value="_ -> !null")
    @NotNull
    public static OCRawStringLexerBase createRawStringLexer(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
        if (tokenTypeProvider == null) {
            OCHighlightingLexer.N(1);
        }
        return new OCRawStringLexerBase(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, tokenTypeProvider.getSTRING_LITERAL());
    }

    public OCHighlightingLexer(@NotNull CidrLexerSettings settings) {
        if (settings == null) {
            OCHighlightingLexer.N(2);
        }
        super(settings);
        CidrPrefixStringLiteralLexer cidrPrefixStringLiteralLexer = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\"', this.myTokenTypeProvider.getSTRING_LITERAL()));
        this.registerSelfStoppingLayer((Lexer)cidrPrefixStringLiteralLexer, new IElementType[]{this.myTokenTypeProvider.getSTRING_LITERAL()}, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer cidrPrefixStringLiteralLexer2 = new CidrPrefixStringLiteralLexer('\'', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\'', this.myTokenTypeProvider.getCHARACTER_LITERAL()));
        this.registerSelfStoppingLayer((Lexer)cidrPrefixStringLiteralLexer2, new IElementType[]{this.myTokenTypeProvider.getCHARACTER_LITERAL()}, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer cidrPrefixStringLiteralLexer3 = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), OCHighlightingLexer.createRawStringLexer(this.myTokenTypeProvider));
        this.registerSelfStoppingLayer((Lexer)cidrPrefixStringLiteralLexer3, new IElementType[]{this.myTokenTypeProvider.getRAW_STRING_LITERAL(), this.myTokenTypeProvider.getWRONG_RAW_STRING_LITERAL()}, IElementType.EMPTY_ARRAY);
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenTypeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cidr/cpp/lexer/OCHighlightingLexer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefault";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRawStringLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

