/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrStringLiteralLexer
extends StringLiteralLexer {
    public static final char LONG_UNICODE_ESCAPE_CHAR = 'U';
    public static final char NAMED_UNICODE_ESCAPE_CHAR = 'N';
    public static final char OCTAL_ESCAPE_CHAR = 'o';
    public static final int LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH = 10;
    @NonNls
    public static final String ADDITIONAL_VALID_ESCAPES = "?abvUNo";

    public CidrStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken, false, ADDITIONAL_VALID_ESCAPES, true, true);
    }

    protected int locateHexEscapeSequence(int start2, int indexOfCharAfterSlash) {
        int n2 = this.j(indexOfCharAfterSlash, c2 -> StringUtil.isHexDigit((char)c2.charValue()));
        if (n2 >= 0) {
            return n2;
        }
        for (n2 = indexOfCharAfterSlash + 1; n2 < this.myBufferEnd; ++n2) {
            if (StringUtil.isHexDigit((char)this.myBuffer.charAt(n2))) continue;
            return n2;
        }
        return n2;
    }

    @NotNull
    protected IElementType getHexCodedEscapeSeq() {
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            IElementType iElementType = this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                CidrStringLiteralLexer.j(0);
            }
            return iElementType;
        }
        IElementType iElementType = this.myStart + 2 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myStart + 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        if (iElementType == null) {
            CidrStringLiteralLexer.j(1);
        }
        return iElementType;
    }

    protected int locateUnicodeEscapeSequence(int start2, int indexOfCharAfterSlash) {
        int n2 = this.j(indexOfCharAfterSlash, c2 -> StringUtil.isHexDigit((char)c2.charValue()));
        if (n2 >= 0) {
            return n2;
        }
        return super.locateUnicodeEscapeSequence(start2, indexOfCharAfterSlash);
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            IElementType iElementType = this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                CidrStringLiteralLexer.j(2);
            }
            return iElementType;
        }
        IElementType iElementType = super.getUnicodeEscapeSequenceType();
        if (iElementType == null) {
            CidrStringLiteralLexer.j(3);
        }
        return iElementType;
    }

    protected int locateAdditionalEscapeSequence(int start2, int indexOfCharAfterSlash) {
        int n2;
        char c3 = this.myBuffer.charAt(indexOfCharAfterSlash);
        if (c3 == 'U') {
            int n3;
            for (n3 = indexOfCharAfterSlash + 1; n3 < start2 + 10; ++n3) {
                if (n3 != this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(n3))) continue;
                return n3;
            }
            return n3;
        }
        if (c3 == 'o' && (n2 = this.j(indexOfCharAfterSlash, c2 -> StringUtil.isOctalDigit((char)c2.charValue()))) >= 0) {
            return n2;
        }
        if (c3 == 'N' && (n2 = this.j(indexOfCharAfterSlash, c2 -> c2.charValue() != '}' && c2.charValue() != '\"')) >= 0) {
            return n2;
        }
        return -1;
    }

    public IElementType getTokenType() {
        char c2;
        IElementType iElementType = super.getTokenType();
        if (iElementType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && ((c2 = this.myBuffer.charAt(this.myStart + 1)) == 'U' ? this.myEnd - this.myStart != 10 : (c2 == 'N' ? this.myEnd - this.myStart <= 4 || this.myBuffer.charAt(this.myEnd - 1) != '}' : c2 == 'o' && (this.myBuffer.charAt(this.myEnd - 1) != '}' || !StringUtil.isOctalDigit((char)this.myBuffer.charAt(this.myEnd - 2)))))) {
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return iElementType;
    }

    private int j(int n2, Predicate<Character> predicate) {
        if (n2 + 1 < this.myBufferEnd && this.myBuffer.charAt(n2 + 1) == '{') {
            int n3;
            for (n3 = n2 + 2; n3 < this.myBufferEnd; ++n3) {
                char c2 = this.myBuffer.charAt(n3);
                if (c2 == '}') {
                    return n3 + 1;
                }
                if (predicate.test(Character.valueOf(c2))) continue;
                return n3;
            }
            return n3;
        }
        return -1;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/cidr/cpp/lexer/CidrStringLiteralLexer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHexCodedEscapeSeq";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnicodeEscapeSequenceType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

