/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRawStringLexerBase
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(StringLiteralLexer.class);
    private static final short LQUOTE = 100;
    private static final short PREFIX = 101;
    private static final short INSIDE = 102;
    private static final short SUFFIX = 103;
    private static final short RQUOTE = 104;
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myPrefixStart;
    private int myPrefixEnd;
    private int mySuffixStart;
    private int mySuffixEnd;
    private int myLastState;
    private int myBufferEnd;
    private final IElementType myMarkerLiteralToken;
    private final IElementType myContentLiteralToken;
    private final int myMaxRawStringPrefixLength;

    public CidrRawStringLexerBase(@NotNull IElementType markerLiteralToken, @NotNull IElementType contentLiteralToken, int maxRawStringPrefixLength) {
        if (markerLiteralToken == null) {
            CidrRawStringLexerBase.j(0);
        }
        if (contentLiteralToken == null) {
            CidrRawStringLexerBase.j(1);
        }
        this.myMarkerLiteralToken = markerLiteralToken;
        this.myContentLiteralToken = contentLiteralToken;
        this.myMaxRawStringPrefixLength = maxRawStringPrefixLength;
    }

    @Contract(pure=true)
    private static boolean j(char c2) {
        return "\\\t\f\r\n\u000b ()".indexOf(c2) == -1;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        int n2;
        int n3;
        if (buffer == null) {
            CidrRawStringLexerBase.j(2);
        }
        if (buffer.length() < endOffset) {
            LOG.error("buffer Length: " + buffer.length() + ", endOffset: " + endOffset, new Throwable());
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myLastState = initialState;
        if (buffer.length() > 0 && buffer.charAt(startOffset) == '\"') {
            this.myEnd = this.myStart + 1;
            this.myState = 100;
            n3 = buffer.charAt(this.myBufferEnd - 1) == '\"' ? this.myBufferEnd - 1 : this.myBufferEnd;
        } else {
            this.myEnd = this.myStart;
            this.myState = 101;
            n3 = this.myBufferEnd;
        }
        this.myPrefixEnd = this.myPrefixStart = this.myEnd;
        for (n2 = 0; this.myPrefixEnd < n3 && CidrRawStringLexerBase.j(this.myBuffer.charAt(this.myPrefixEnd)) && n2 < this.myMaxRawStringPrefixLength; ++n2) {
            ++this.myPrefixEnd;
        }
        this.mySuffixStart = this.mySuffixEnd = n3;
        if (this.myPrefixEnd < this.myBufferEnd && n2 < this.myMaxRawStringPrefixLength && this.myBuffer.charAt(this.myPrefixEnd) == '(') {
            String string = this.myPrefixEnd == this.myPrefixStart ? "" : this.myBuffer.subSequence(this.myPrefixStart, this.myPrefixEnd).toString();
            ++this.myPrefixEnd;
            String string2 = ")" + string;
            int n4 = n3 - string2.length();
            String string3 = this.myBuffer.subSequence(n4, n3).toString();
            if (string3.equals(string2)) {
                this.mySuffixStart = n4;
                this.mySuffixEnd = n3;
            }
        }
    }

    public String getRawText() {
        return this.myBuffer.subSequence(this.myPrefixEnd, this.mySuffixStart).toString();
    }

    public int getState() {
        return this.myLastState;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        return switch (this.myState) {
            case 101, 103 -> this.myMarkerLiteralToken;
            case 100, 102, 104 -> this.myContentLiteralToken;
            default -> null;
        };
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        if (this.myEnd == this.myBufferEnd - 1) {
            this.myState = this.myBuffer.charAt(this.myEnd) == '\"' ? 104 : 101;
            this.myEnd = this.myBufferEnd;
        } else if (this.myEnd == this.myPrefixStart) {
            this.myEnd = this.myPrefixEnd;
            this.myState = 101;
        } else if (this.myEnd == this.mySuffixStart) {
            this.myEnd = this.mySuffixEnd;
            this.myState = 103;
        } else if (this.myEnd == this.myPrefixEnd) {
            this.myEnd = this.mySuffixStart;
            this.myState = 102;
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            CidrRawStringLexerBase.j(3);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerLiteralToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentLiteralToken";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/cpp/lexer/CidrRawStringLexerBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/cpp/lexer/CidrRawStringLexerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

