/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrLexerUtils {
    public static int indexOf(CharSequence source, CharSequence model) {
        return CidrLexerUtils.indexOf(source, model, 0);
    }

    public static int indexOf(CharSequence source, CharSequence model, int fromSourceIndex) {
        return CidrLexerUtils.indexOf(source, 0, source.length(), model, 0, model.length(), fromSourceIndex);
    }

    static int indexOf(CharSequence source, int sourceOffset, int sourceLength, CharSequence model, int modelOffset, int modelLength, int fromSourceIndex) {
        if (fromSourceIndex >= sourceLength) {
            return modelLength == 0 ? sourceLength : -1;
        }
        if (fromSourceIndex < 0) {
            fromSourceIndex = 0;
        }
        if (modelLength == 0) {
            return fromSourceIndex;
        }
        char c2 = model.charAt(modelOffset);
        int n2 = sourceOffset + (sourceLength - modelLength);
        for (int i2 = sourceOffset + fromSourceIndex; i2 <= n2; ++i2) {
            if (source.charAt(i2) != c2) {
                while (++i2 <= n2 && source.charAt(i2) != c2) {
                }
            }
            if (i2 > n2) continue;
            int n3 = i2 + 1;
            int n4 = n3 + modelLength - 1;
            int n5 = modelOffset + 1;
            while (n3 < n4 && source.charAt(n3) == model.charAt(n5)) {
                ++n3;
                ++n5;
            }
            if (n3 != n4) continue;
            return i2 - sourceOffset;
        }
        return -1;
    }

    @Nullable
    public static IElementType goToNextSignificantToken(@NotNull OCLexer lexer) {
        if (lexer == null) {
            CidrLexerUtils.j(0);
        }
        lexer.advance();
        while (!CidrLexerUtils.isAtSignificantToken(lexer)) {
            lexer.advance();
        }
        return lexer.getTokenType();
    }

    public static boolean isAtSignificantToken(@NotNull OCLexer lexer) {
        if (lexer == null) {
            CidrLexerUtils.j(1);
        }
        CidrTokenTypeProvider cidrTokenTypeProvider = lexer.getTokenTypeProvider();
        IElementType iElementType = lexer.getTokenType();
        return !cidrTokenTypeProvider.getWhitespaces().contains(iElementType) && !cidrTokenTypeProvider.getComments().contains(iElementType);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "lexer";
        objectArray2[1] = "com/intellij/cidr/cpp/lexer/CidrLexerUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "goToNextSignificantToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtSignificantToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

