/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.endpoints;

import com.intellij.grpc.endpoints.ProtoUrlTargetInfoKt;
import com.intellij.grpc.model.ProtoRpcModel;
import com.intellij.grpc.model.ProtoServiceModel;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grpc/endpoints/ProtoUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "serviceModel", "Lcom/intellij/grpc/model/ProtoServiceModel;", "endpointModel", "Lcom/intellij/grpc/model/ProtoRpcModel;", "(Lcom/intellij/grpc/model/ProtoServiceModel;Lcom/intellij/grpc/model/ProtoRpcModel;)V", "authorities", "", "Lcom/intellij/microservices/url/Authority;", "getAuthorities", "()Ljava/util/List;", "methods", "", "", "getMethods", "()Ljava/util/Set;", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "schemes", "getSchemes", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "intellij.grpc"})
public final class ProtoUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final ProtoServiceModel serviceModel;
    @NotNull
    private final ProtoRpcModel endpointModel;

    public ProtoUrlTargetInfo(@NotNull ProtoServiceModel serviceModel, @NotNull ProtoRpcModel endpointModel) {
        Intrinsics.checkNotNullParameter((Object)serviceModel, (String)"serviceModel");
        Intrinsics.checkNotNullParameter((Object)endpointModel, (String)"endpointModel");
        this.serviceModel = serviceModel;
        this.endpointModel = endpointModel;
    }

    @NotNull
    public List<String> getSchemes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return CollectionsKt.listOf((Object)new Authority.Exact("localhost:8080"));
    }

    @NotNull
    public UrlPath getPath() {
        return ProtoUrlTargetInfoKt.access$getUrlPathParser$p().parseUrlPath(new PartiallyKnownString(this.serviceModel.getServiceQualifiedName() + "/" + this.endpointModel.getShortName())).getUrlPath();
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return (PsiElement)this.endpointModel.getSourcePsi();
    }

    @NotNull
    public Set<String> getMethods() {
        return SetsKt.setOf((Object)"GRPC");
    }
}

