/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.WipWorkerCommandProcessor;
import org.jetbrains.wip.WipWorkerVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.serviceworker.ServiceWorkerKt;
import org.jetbrains.wip.protocol.target.AttachedToTargetEventData;
import org.jetbrains.wip.protocol.target.DetachedFromTargetEventData;
import org.jetbrains.wip.protocol.target.ReceivedMessageFromTargetEventData;
import org.jetbrains.wip.protocol.target.TargetKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tJ\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "getVm", "()Lorg/jetbrains/wip/WipVm;", "workerList", "", "Lorg/jetbrains/wip/WipWorkerVm;", "getWorkerList", "()Ljava/util/List;", "workers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "enableWorkers", "Lorg/jetbrains/concurrency/Promise;", "hasWorker", "", "workerId", "prepareWorkerForDebugging", "", "worker", "registerWorkerEvents", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "workerCreated", "workerVm", "workerMessageReceived", "message", "workerTerminated", "id", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipWorkerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipWorkerManager.kt\norg/jetbrains/wip/WipWorkerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1747#2,3:80\n*S KotlinDebug\n*F\n+ 1 WipWorkerManager.kt\norg/jetbrains/wip/WipWorkerManager\n*L\n64#1:80,3\n*E\n"})
public class WipWorkerManager {
    @NotNull
    private final WipVm vm;
    @NotNull
    private final ConcurrentHashMap<String, WipWorkerVm> workers;

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.workers = new ConcurrentHashMap();
    }

    @NotNull
    protected final WipVm getVm() {
        return this.vm;
    }

    @NotNull
    public Promise<?> enableWorkers() {
        Object[] objectArray = new Promise[]{this.vm.getCommandProcessor().send((Request)TargetKt.SetAutoAttach$default(true, true, null, null, 12, null)), this.vm.getCommandProcessor().send((Request)ServiceWorkerKt.Enable())};
        return Promises.all((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    public final void workerCreated(@NotNull WipWorkerVm workerVm2) {
        Intrinsics.checkNotNullParameter((Object)((Object)workerVm2), (String)"workerVm");
        this.vm.getRegisterVmPrintEvents().invoke((Object)workerVm2);
        String id = workerVm2.getSessionId();
        WipWorkerVm wipWorkerVm = this.workers.remove(id);
        if (wipWorkerVm != null) {
            wipWorkerVm.terminate();
        }
        ((Map)this.workers).put(id, workerVm2);
        this.prepareWorkerForDebugging(workerVm2);
    }

    private final void prepareWorkerForDebugging(WipWorkerVm worker) {
        WipVmKt.enableConsole(worker.getCommandProcessor());
        worker.getCommandProcessor().send((Request)DebuggerKt.Enable$default(null, 1, null));
        worker.enableWorkers();
        this.vm.getDebugListener().childVmAdded((Vm)worker);
        worker.getCommandProcessor().send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void workerTerminated(@NotNull String id) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            WipWorkerVm wipWorkerVm = this.workers.remove(id);
            if (wipWorkerVm == null) break block0;
            wipWorkerVm.terminate();
        }
    }

    public final void workerMessageReceived(@NotNull String workerId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)workerId, (String)"workerId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = this.workers.get(workerId);
        if (object == null || (object = object.getCommandProcessor()) == null) {
            return;
        }
        WipWorkerVm processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)message));
    }

    public void registerWorkerEvents(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        eventMap.add((EventType)AttachedToTargetEventData.TYPE, (Function1)new Function1<AttachedToTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AttachedToTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                WipWorkerCommandProcessor wipWorkerCommandProcessor = new WipWorkerCommandProcessor(it.sessionId(), this.this$0.getVm().getCommandProcessor());
                WipWorkerVm workerVm2 = new WipWorkerVm(it.sessionId(), it.targetInfo().targetId(), it.targetInfo().title(), this.this$0.getVm().getDebugListener(), wipWorkerCommandProcessor, null, 32, null);
                this.this$0.workerCreated(workerVm2);
            }
        });
        eventMap.add((EventType)DetachedFromTargetEventData.TYPE, (Function1)new Function1<DetachedFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DetachedFromTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.workerTerminated(it.sessionId());
            }
        });
        eventMap.add((EventType)ReceivedMessageFromTargetEventData.TYPE, (Function1)new Function1<ReceivedMessageFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ReceivedMessageFromTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.workerMessageReceived(it.sessionId(), it.message());
            }
        });
    }

    public final boolean hasWorker(@Nullable String workerId) {
        boolean bl;
        block4: {
            if (workerId == null) {
                return false;
            }
            Collection<WipWorkerVm> collection = this.workers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WipWorkerVm worker = (WipWorkerVm)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)worker.getWorkerId(), (Object)workerId)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<WipWorkerVm> getWorkerList() {
        Collection<WipWorkerVm> collection = this.workers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }
}

