/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.jetbrains.plugins.reactnative.PackagerRunner;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerConfigurationEditor;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "packagerArgumentsField", "Lcom/intellij/ui/RawCommandLineEditor;", "packagerRunnerModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/PackagerRunner;", "packagerRunnerPanel", "Ljavax/swing/JPanel;", "packagerScriptSelector", "Lcom/intellij/ui/TextFieldWithHistory;", "Lorg/jetbrains/annotations/NotNull;", "packagerScriptSelectorLabel", "Ljavax/swing/JLabel;", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "reactNativeFieldLabel", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "getDimensionServiceKey", "", "updatePackagerRunnerVisibility", "intellij.javascript.reactNativeDebugger"})
@SourceDebugExtension(value={"SMAP\nReactNativePackagerConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactNativePackagerConfigurationEditor.kt\ncom/jetbrains/plugins/reactnative/ReactNativePackagerConfigurationEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class ReactNativePackagerConfigurationEditor
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel packagerRunnerPanel;
    @NotNull
    private final RadioButtonEnumModel<PackagerRunner> packagerRunnerModel;
    @NotNull
    private final JLabel packagerScriptSelectorLabel;
    @NotNull
    private final TextFieldWithHistory packagerScriptSelector;
    @NotNull
    private final NodeJsInterpreterField nodeInterpreterField;
    @NotNull
    private final JLabel reactNativeFieldLabel;
    @NotNull
    private final NodePackageField reactNativeField;
    @NotNull
    private final RawCommandLineEditor packagerArgumentsField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirField;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;

    public ReactNativePackagerConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.packagerRunnerPanel = new JPanel(new GridBagLayout());
        this.packagerRunnerModel = ReactNativeConfigurationEditorKt.createRadioButtonGroup(PackagerRunner.class, this.packagerRunnerPanel);
        this.packagerScriptSelectorLabel = new JLabel(JSDebuggerBundle.message((String)"react.native.packager.config.script", (Object[])new Object[0]));
        TextFieldWithHistory textFieldWithHistory = NpmRunConfigurationEditor.createRunScriptsField((Project)this.project, () -> ReactNativePackagerConfigurationEditor.packagerScriptSelector$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"createRunScriptsField(...)");
        this.packagerScriptSelector = textFieldWithHistory;
        this.nodeInterpreterField = new NodeJsInterpreterField(this.project, false);
        this.reactNativeFieldLabel = new JLabel(JSDebuggerBundle.message((String)"react.native.packager.config.package", (Object[])new Object[0]));
        this.reactNativeField = ReactNativeConfigurationEditorKt.createReactNativePackageField(this.nodeInterpreterField);
        this.packagerArgumentsField = new RawCommandLineEditor();
        this.workingDirField = new TextFieldWithBrowseButton();
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.init();
        this.setTitle(JSDebuggerBundle.message((String)"react.native.packager.config.title", (Object[])new Object[0]));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.jetbrains.plugins.reactnative.ReactNativePackagerConfigurationEditor";
    }

    private final void updatePackagerRunnerVisibility() {
        boolean isNpm = this.packagerRunnerModel.getSelected() == PackagerRunner.NPM;
        this.packagerScriptSelector.setVisible(isNpm);
        this.packagerScriptSelectorLabel.setVisible(isNpm);
        this.reactNativeField.setVisible(!isNpm);
        this.reactNativeFieldLabel.setVisible(!isNpm);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.packagerScriptSelectorLabel.setLabelFor((Component)this.packagerScriptSelector);
        this.packagerRunnerModel.addActionListener(arg_0 -> ReactNativePackagerConfigurationEditor.createCenterPanel$lambda$1(this, arg_0));
        FormBuilder formBuilder2 = new FormBuilder(){

            protected int getFill(@Nullable JComponent component) {
                return 2;
            }
        };
        formBuilder2.addLabeledComponent(JSDebuggerBundle.message((String)"react.native.packager.config.command", (Object[])new Object[0]), (JComponent)this.packagerRunnerPanel).addLabeledComponent((JComponent)this.packagerScriptSelectorLabel, (JComponent)this.packagerScriptSelector).addLabeledComponent((JComponent)this.reactNativeFieldLabel, (JComponent)this.reactNativeField).addLabeledComponent(JSDebuggerBundle.message((String)"react.native.config.arguments", (Object[])new Object[0]), (JComponent)this.packagerArgumentsField).addLabeledComponent(JSDebuggerBundle.message((String)"react.native.config.interpreter", (Object[])new Object[0]), (JComponent)this.nodeInterpreterField, 12).addLabeledComponent(JSDebuggerBundle.message((String)"react.native.config.directory", (Object[])new Object[0]), (JComponent)this.workingDirField).addLabeledComponent(JSDebuggerBundle.message((String)"react.native.config.env", (Object[])new Object[0]), (JComponent)this.envVarsComponent);
        ReactNativePackagerConfiguration configuration = ReactNativePackagerConfiguration.Companion.getInstance(this.project);
        if (configuration.getScripts().isEmpty()) {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.BUILT_IN);
        } else {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.NPM);
            this.packagerScriptSelector.setTextAndAddToHistory(ParametersListUtil.join(configuration.getScripts()));
        }
        this.packagerArgumentsField.setText(configuration.getArguments());
        NodePackage nodePackage = configuration.getReactNativePackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            this.reactNativeField.setSelected(it);
        }
        this.nodeInterpreterField.setInterpreterRef(configuration.getNodeInterpreter());
        this.workingDirField.setText(ReactNativeRunConfigurationKt.findEffectiveWorkingDirectory(configuration.getWorkingDirectory(), this.project));
        this.envVarsComponent.setData(configuration.getEnvData());
        this.updatePackagerRunnerVisibility();
        return formBuilder2.getPanel();
    }

    protected void doOKAction() {
        List list;
        if (this.packagerRunnerModel.getSelected() == PackagerRunner.NPM) {
            List list2 = ParametersListUtil.parse((String)this.packagerScriptSelector.getText());
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        List scripts = list;
        ReactNativePackagerConfiguration configuration = ReactNativePackagerConfiguration.Companion.getInstance(this.project);
        configuration.setScripts(CollectionsKt.toMutableList((Collection)scripts));
        configuration.setArguments(this.packagerArgumentsField.getText());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        configuration.setNodeInterpreter(nodeJsInterpreterRef);
        configuration.setReactNativePackage(this.reactNativeField.getSelected());
        configuration.setWorkingDirectory(this.workingDirField.getText());
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        configuration.setEnvData(environmentVariablesData);
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List result = new ArrayList();
        try {
            NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
        }
        catch (RuntimeConfigurationException e) {
            result.add(new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.nodeInterpreterField));
        }
        if (this.packagerRunnerModel.getSelected() == PackagerRunner.BUILT_IN) {
            String string = this.reactNativeField.getSelected().getSystemDependentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemDependentPath(...)");
            if (((CharSequence)string).length() == 0) {
                result.add(new ValidationInfo(JSDebuggerBundle.message((String)"react.native.packager.config.validation.react", (Object[])new Object[0]), (JComponent)this.reactNativeField));
            }
        } else {
            String string = this.packagerScriptSelector.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                result.add(new ValidationInfo(JSDebuggerBundle.message((String)"react.native.packager.config.validation.npm", (Object[])new Object[0]), (JComponent)this.packagerScriptSelector));
            }
        }
        return result;
    }

    private static final String packagerScriptSelector$lambda$0(ReactNativePackagerConfigurationEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        String[] stringArray = new String[]{this$0.workingDirField.getText(), "package.json"};
        return FileUtil.join((String[])stringArray);
    }

    private static final void createCenterPanel$lambda$1(ReactNativePackagerConfigurationEditor this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.updatePackagerRunnerVisibility();
    }
}

