/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebuggerIcons;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.jetbrains.debugger.wip.JSRemoteDebugConfiguration;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationTypeKt;
import java.util.ListIterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfigurationType;", "Lcom/intellij/execution/configurations/ConfigurationTypeBase;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/execution/RunConfigurationConverter;", "()V", "convertRunConfigurationOnDemand", "", "element", "Lorg/jdom/Element;", "getHelpTopic", "", "getTag", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nJSRemoteDebugConfigurationType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSRemoteDebugConfigurationType.kt\ncom/jetbrains/debugger/wip/JSRemoteDebugConfigurationType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class JSRemoteDebugConfigurationType
extends ConfigurationTypeBase
implements DumbAware,
RunConfigurationConverter {
    public JSRemoteDebugConfigurationType() {
        String string = JSDebuggerBundle.message((String)"js.remote.configuration.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super("ChromiumRemoteDebugType", string, null, NotNullLazyValue.createValue(JSRemoteDebugConfigurationType::_init_$lambda$0));
        this.addFactory(new ConfigurationFactory(){

            @NotNull
            public RunConfigurationSingletonPolicy getSingletonPolicy() {
                return RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
            }

            @NotNull
            public String getId() {
                return "Chromium Remote";
            }

            @NotNull
            public JSRemoteDebugConfiguration createTemplateConfiguration(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new JSRemoteDebugConfiguration(project, this, this.getConfigurationTypeDescription());
            }

            public boolean isEditableInDumbMode() {
                return true;
            }
        });
    }

    @NotNull
    public String getTag() {
        return "jsRemote";
    }

    public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!JSRemoteDebugConfigurationTypeKt.access$isNodeJsRemoteDebugConfiguration(element)) {
            return false;
        }
        element.setAttribute("type", "ChromiumRemoteDebugType");
        element.setAttribute("factoryName", "Chromium Remote");
        element.setAttribute("isV8Legacy", "true");
        ListIterator iterator = element.getChildren().listIterator();
        while (iterator.hasNext()) {
            Attribute it;
            Element next = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)next.getName(), (Object)"node-js-remote-debug")) continue;
            if (next.getAttribute("host") != null) {
                boolean bl = false;
                element.setAttribute("host", it.getValue());
            }
            if (next.getAttribute("debug-port") != null) {
                boolean bl = false;
                element.setAttribute("port", it.getValue());
            }
            iterator.remove();
        }
        return true;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.dialogs.rundebug.ChromiumRemoteDebugType";
    }

    private static final Icon _init_$lambda$0() {
        return JavaScriptDebuggerIcons.JavaScript_remote_debug_configuration;
    }
}

