/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.CommonBundle;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSDebuggerCoroutineScopeHolder;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.debugger.wip.ChromeLocalConnectedTabsService;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.ChromeLocalVmConnectionKt;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipLocalVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import com.jetbrains.debugger.wip.WipVmBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J6\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\f\u00104\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00065"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalVmConnection;", "Lcom/jetbrains/debugger/wip/WipLocalVmConnection;", "url", "Lcom/intellij/util/Url;", "reloadReusedPage", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/util/Url;ZLcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/xdebugger/XDebugSession;)V", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "newPageRequested", "processHandle", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/execution/process/KillableProcessHandler;", "getReloadReusedPage", "()Z", "reusedExistingBrowserInstance", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "connect", "", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "address", "Ljava/net/InetSocketAddress;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/wip/WipVm;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "getUserDataPath", "", "port", "", "launchBrowserAndOpen", "remoteDebuggingPort", "project", "Lcom/intellij/openapi/project/Project;", "launchBrowserOnNewPortAndOpen", "processPageConnections", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "intellij.javascript.chrome.connector"})
public class ChromeLocalVmConnection
extends WipLocalVmConnection {
    private final boolean reloadReusedPage;
    @NotNull
    private final WebBrowser browser;
    @NotNull
    private final XDebugSession session;
    private boolean reusedExistingBrowserInstance;
    private boolean newPageRequested;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Deferred<? extends KillableProcessHandler> processHandle;

    public ChromeLocalVmConnection(@Nullable Url url, boolean reloadReusedPage, @NotNull WebBrowser browser, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(url);
        this.reloadReusedPage = reloadReusedPage;
        this.browser = browser;
        this.session = session;
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.coroutineScope = JSDebuggerCoroutineScopeHolder.Companion.createChildScope(project);
    }

    public /* synthetic */ ChromeLocalVmConnection(Url url, boolean bl, WebBrowser webBrowser, XDebugSession xDebugSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(url, bl, webBrowser, xDebugSession);
    }

    public final boolean getReloadReusedPage() {
        return this.reloadReusedPage;
    }

    @NotNull
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    public final void connect() {
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int savedPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (savedPort > 0) {
            this.reusedExistingBrowserInstance = true;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), savedPort);
            AsyncPromise result = new AsyncPromise();
            Ref.ObjectRef f = new Ref.ObjectRef();
            result.onSuccess(arg_0 -> ChromeLocalVmConnection.connect$lambda$0((Function1)new Function1<WipVm, Unit>(f, this, address){
                final /* synthetic */ Ref.ObjectRef<ScheduledFuture<?>> $f;
                final /* synthetic */ ChromeLocalVmConnection this$0;
                final /* synthetic */ InetSocketAddress $address;
                {
                    this.$f = $f;
                    this.this$0 = $receiver;
                    this.$address = $address;
                    super(1);
                }

                public final void invoke(@NotNull WipVm it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    ScheduledFuture scheduledFuture = (ScheduledFuture)this.$f.element;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                    }
                    ChromeLocalVmConnection.access$connectionSucceeded(this.this$0, it, this.$address);
                }
            }, arg_0));
            ApplicationManager.getApplication().executeOnPooledThread(() -> ChromeLocalVmConnection.connect$lambda$2(this, address, result, f, savedPort, project2));
        } else {
            this.launchBrowserOnNewPortAndOpen(project2);
        }
    }

    private final void launchBrowserOnNewPortAndOpen(Project project) {
        int port = NetUtils.findAvailableSocketPort();
        int oldPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (oldPort > 0) {
            ChromeLocalVmConnectionKt.access$getLOG$p().warn("Chrome debug port changed from " + oldPort + " to " + port + ".");
        }
        PropertiesComponent.getInstance().setValue("js.chrome.debugger.port." + this.getBrowser().getId(), port, -1);
        this.launchBrowserAndOpen(port, project);
    }

    private final void launchBrowserAndOpen(int remoteDebuggingPort, Project project) {
        String string = PathUtil.toSystemDependentName((String)this.getBrowser().getPath());
        if (string == null) {
            Object[] objectArray = new Object[]{CommonBundle.settingsActionPath()};
            throw new CantRunException(IdeBundle.message((String)"error.please.specify.path.to.web.browser", (Object[])objectArray));
        }
        String browserPath = string;
        BrowserSpecificSettings browserSpecificSettings = this.getBrowser().getSpecificSettings();
        ChromeSettings chromeSettings = browserSpecificSettings instanceof ChromeSettings ? (ChromeSettings)browserSpecificSettings : null;
        if (chromeSettings == null) {
            throw new AssertionError((Object)"Browser is not Chrome. Must be checked in Run configuration.");
        }
        ChromeSettings chromeSettings2 = chromeSettings;
        List additionalParameters = new ArrayList();
        List list = chromeSettings2.getAdditionalParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalParameters(...)");
        additionalParameters.addAll(list);
        additionalParameters.add("--remote-debugging-port=" + remoteDebuggingPort);
        if (!chromeSettings2.isUseCustomProfile()) {
            String userDataPath = this.getUserDataPath(remoteDebuggingPort);
            additionalParameters.add("--user-data-dir=" + userDataPath);
            additionalParameters.add("--no-first-run");
            additionalParameters.add("--disable-fre");
        }
        additionalParameters.add("--no-default-browser-check");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(BrowserUtil.getOpenBrowserCommand((String)browserPath, (String)"about:blank", (List)additionalParameters, (boolean)true)).withEnvironment(chromeSettings2.getEnvironmentVariables());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine command = generalCommandLine;
        this.processHandle = BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KillableProcessHandler>, Object>(command, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GeneralCommandLine $command;
            {
                this.$command = $command;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        CoroutineScope $this$async;
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = $this$async = (CoroutineScope)this.L$0;
                        Object object4 = this.$command;
                        try {
                            boolean bl = false;
                            object2 = Result.constructor-impl((Object)new KillableProcessHandler(object4));
                        }
                        catch (Throwable bl) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                        }
                        object3 = object2;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                        if (throwable != null) {
                            Object it = object4 = throwable;
                            boolean bl = false;
                            ChromeLocalVmConnectionKt.access$getLOG$p().warn((Throwable)it);
                        }
                        return Result.isFailure-impl((Object)object3) ? null : object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super KillableProcessHandler> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.reusedExistingBrowserInstance = false;
        Promise openPromise = RemoteVmConnection.open$default((RemoteVmConnection)this, (InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), remoteDebuggingPort), null, (int)2, null);
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this).addRequest(() -> ChromeLocalVmConnection.launchBrowserAndOpen$lambda$4(openPromise, remoteDebuggingPort, project, this), TimeUnit.SECONDS.toMillis(9L));
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Promise promise = Promises.asPromise((Job)BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 7[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation.dumpInner(MemberFunctionInvokation.java:52)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null)).thenAsync(arg_0 -> ChromeLocalVmConnection.detachAndClose$lambda$5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
        return promise;
    }

    private final String getUserDataPath(int port) {
        File userDataDir = new File(PathManager.getSystemPath(), "chrome-user-data-" + port);
        if (!userDataDir.exists()) {
            userDataDir.mkdir();
        }
        String string = userDataDir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Override
    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            private final long startTimeMillis;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise<WipVm> $vmResult;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                this.$vmResult = $vmResult;
                this.startTimeMillis = System.currentTimeMillis();
            }

            public void channelActive(@NotNull ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, this.$vmResult);
            }

            /*
             * WARNING - void declaration
             */
            protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpResponse message) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                try {
                    if (ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                        if (this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult)) {
                            context.pipeline().remove((ChannelHandler)this);
                            if (this.this$0.getReloadReusedPage() && !ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                                this.$vmResult.onSuccess(arg_0 -> createChannelHandler.1.messageReceived$lambda$0((Function1)new Function1<WipVm, Unit>(this.this$0){
                                    final /* synthetic */ ChromeLocalVmConnection this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull WipVm vm) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
                                        vm.addReadyListener((Function0<Unit>)((Function0)new Function0<Unit>(vm, this.this$0){
                                            final /* synthetic */ WipVm $vm;
                                            final /* synthetic */ ChromeLocalVmConnection this$0;
                                            {
                                                this.$vm = $vm;
                                                this.this$0 = $receiver;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                if (Intrinsics.areEqual((Object)this.$vm.getCurrentUrl(), (Object)this.this$0.getUrl())) {
                                                    this.$vm.getCommandProcessor().send((Request)PageKt.Reload$default(true, null, 2, null)).thenAsync(arg_0 -> createChannelHandler.messageReceived.1.invoke$lambda$0((Function1)new Function1<Unit, Promise<Unit>>(this.this$0, this.$vm){
                                                        final /* synthetic */ ChromeLocalVmConnection this$0;
                                                        final /* synthetic */ WipVm $vm;
                                                        {
                                                            this.this$0 = $receiver;
                                                            this.$vm = $vm;
                                                            super(1);
                                                        }

                                                        public final Promise<Unit> invoke(Unit it) {
                                                            XDebugSession xDebugSession = this.this$0.getSession();
                                                            WipVm wipVm = this.$vm;
                                                            ChromeLocalVmConnection chromeLocalVmConnection = this.this$0;
                                                            XDebugSession it2 = xDebugSession;
                                                            boolean bl = false;
                                                            return wipVm.getCommandProcessor().send((Request)DebuggerKt.SetSkipAllPauses(chromeLocalVmConnection.getSession().areBreakpointsMuted()));
                                                        }
                                                    }, arg_0));
                                                } else {
                                                    WipVm wipVm = this.$vm;
                                                    Intrinsics.checkNotNullExpressionValue((Object)((Object)wipVm), (String)"$vm");
                                                    WipVmBootstrap wipVmBootstrap = new WipVmBootstrap(wipVm);
                                                    Url url = this.this$0.getUrl();
                                                    Intrinsics.checkNotNull((Object)url);
                                                    wipVmBootstrap.navigate(url);
                                                }
                                            }

                                            private static final Promise invoke$lambda$0(Function1 $tmp0, Object p0) {
                                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                                return (Promise)$tmp0.invoke(p0);
                                            }
                                        }));
                                    }
                                }, arg_0));
                            }
                            return;
                        }
                    }
                    if (!ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                    if (ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                        if (!this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult) && System.currentTimeMillis() - this.startTimeMillis < 5000L) {
                            context.executor().schedule(() -> createChannelHandler.1.messageReceived$lambda$1(this.this$0, this.$address, context, this.$vmResult), 100L, TimeUnit.MILLISECONDS);
                        } else {
                            context.pipeline().remove((ChannelHandler)this);
                        }
                    } else {
                        void $this$addChannelListener$iv;
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json/new?about:blank");
                        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(this.$address));
                        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
                        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
                        ChannelFuture channelFuture2 = channelFuture;
                        AsyncPromise<WipVm> asyncPromise = this.$vmResult;
                        boolean $i$f$addChannelListener = false;
                        $this$addChannelListener$iv.addListener(new GenericFutureListener(asyncPromise){
                            final /* synthetic */ AsyncPromise $vmResult$inlined;
                            {
                                this.$vmResult$inlined = asyncPromise;
                            }

                            public final void operationComplete(ChannelFuture it) {
                                Intrinsics.checkNotNull((Object)it);
                                ChannelFuture it2 = it;
                                boolean bl = false;
                                if (!it2.isSuccess()) {
                                    Throwable throwable = it2.cause();
                                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"cause(...)");
                                    this.$vmResult$inlined.setError(throwable);
                                }
                            }
                        });
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                }
                catch (Throwable e) {
                    this.$vmResult.setError(e);
                }
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }

            private static final void messageReceived$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void messageReceived$lambda$1(ChromeLocalVmConnection this$0, InetSocketAddress $address, ChannelHandlerContext $context, AsyncPromise $vmResult) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                Intrinsics.checkNotNullParameter((Object)$vmResult, (String)"$vmResult");
                this$0.sendGetJson($address, $context, (AsyncPromise<WipVm>)$vmResult);
            }
        };
    }

    @Override
    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pageConnections, (String)"pageConnections");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        RunProfile runProfile = this.session.getRunProfile();
        if (this.newPageRequested) {
            PageConnection p;
            for (PageConnection p2 : CollectionsKt.reversed((Iterable)pageConnections)) {
                if (!Intrinsics.areEqual((Object)p2.getUrl(), (Object)"about:blank")) continue;
                if (p2.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    result.setError(string);
                    return false;
                }
                if (runProfile != null) {
                    ((ChromeLocalConnectedTabsService)ApplicationManager.getApplication().getService(ChromeLocalConnectedTabsService.class)).addTabToReuse(runProfile, p2);
                }
                this.connectDebugger(p2, context, result, debugMessageQueue);
                if (this.getUrl() != null) {
                    result.onSuccess(arg_0 -> ChromeLocalVmConnection.processPageConnections$lambda$6((Function1)new Function1<WipVm, Unit>(this){
                        final /* synthetic */ ChromeLocalVmConnection this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull WipVm it) {
                            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                            it.addReadyListener((Function0<Unit>)((Function0)new Function0<Unit>(it, this.this$0){
                                final /* synthetic */ WipVm $it;
                                final /* synthetic */ ChromeLocalVmConnection this$0;
                                {
                                    this.$it = $it;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    WipVm wipVm = this.$it;
                                    Intrinsics.checkNotNullExpressionValue((Object)((Object)wipVm), (String)"$it");
                                    new WipVmBootstrap(wipVm).navigate(this.this$0.getUrl());
                                }
                            }));
                        }
                    }, arg_0));
                }
                return false;
            }
            if (pageConnections.size() == 1 && Intrinsics.areEqual((Object)pageConnections.get(0).getTitle(), (Object)"React Native Debugger") && (p = pageConnections.get(0)).getWebSocketDebuggerUrl() != null) {
                this.connectDebugger(p, context, result, debugMessageQueue);
                return false;
            }
        } else if (runProfile != null) {
            for (PageConnection p : pageConnections) {
                PageConnection pageConnection = ((ChromeLocalConnectedTabsService)ApplicationManager.getApplication().getService(ChromeLocalConnectedTabsService.class)).getTabToReuse(runProfile);
                if (!Intrinsics.areEqual((Object)p.getId(), (Object)(pageConnection != null ? pageConnection.getId() : null))) continue;
                if (p.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    result.setError(string);
                    return false;
                }
                this.connectDebugger(p, context, result, debugMessageQueue);
                return false;
            }
        }
        return true;
    }

    private static final void connect$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void connect$lambda$2$lambda$1(Channel $channel, ChromeLocalVmConnection this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $channel.close();
        this$0.launchBrowserOnNewPortAndOpen($project);
    }

    private static final void connect$lambda$2(ChromeLocalVmConnection this$0, InetSocketAddress $address, AsyncPromise $result, Ref.ObjectRef $f, int $savedPort, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$f, (String)"$f");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Channel channel = NettyKt.connectRetrying$default((Bootstrap)this$0.createBootstrap($address, (AsyncPromise<WipVm>)$result), (InetSocketAddress)$address, (int)2, null, (int)4, null).getChannel();
        if (channel != null) {
            $f.element = channel.eventLoop().schedule(() -> ChromeLocalVmConnection.connect$lambda$2$lambda$1(channel, this$0, $project), 500L, TimeUnit.MILLISECONDS);
        } else {
            this$0.launchBrowserAndOpen($savedPort, $project);
        }
    }

    private static final void launchBrowserAndOpen$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void launchBrowserAndOpen$lambda$4(Promise $openPromise, int $remoteDebuggingPort, Project $project, ChromeLocalVmConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)$openPromise, (String)"$openPromise");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (Promises.isPending((Promise)$openPromise)) {
            Object object = new Object[]{$remoteDebuggingPort};
            String string = JSDebuggerBundle.message((String)"js.debug.waiting.for.chrome.remote.debug.port", (Object[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            Notification notification = JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP().createNotification(message, NotificationType.WARNING);
            object = JSDebuggerBundle.message((String)"js.debug.waiting.for.chrome.remote.debug.port.more.info", (Object[])new Object[0]);
            notification.addAction((AnAction)new NotificationAction((String)object){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    HelpManager.getInstance().invokeHelp("Configure_Debugging_Chrome_UserData");
                }
            });
            object = JSDebuggerBundle.message((String)"js.debug.try.another.port", (Object[])new Object[0]);
            notification.addAction((AnAction)new NotificationAction(this$0, (String)object){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    ExecutionEnvironment environment;
                    XDebugSessionImpl sessionImpl;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    PropertiesComponent.getInstance().unsetValue("js.chrome.debugger.port." + this.this$0.getBrowser().getId());
                    XDebugSession xDebugSession = this.this$0.getSession();
                    XDebugSessionImpl xDebugSessionImpl = sessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
                    if (sessionImpl != null && (environment = sessionImpl.getExecutionEnvironment()) != null) {
                        notification.expire();
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                }
            });
            notification.notify($project);
            $openPromise.onProcessed(arg_0 -> ChromeLocalVmConnection.launchBrowserAndOpen$lambda$4$lambda$3((Function1)new Function1<WipVm, Unit>(notification){
                final /* synthetic */ Notification $notification;
                {
                    this.$notification = $notification;
                    super(1);
                }

                public final void invoke(WipVm it) {
                    this.$notification.expire();
                }
            }, arg_0));
        }
    }

    private static final Promise detachAndClose$lambda$5(ChromeLocalVmConnection this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return super.detachAndClose();
    }

    private static final void processPageConnections$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$connectionSucceeded(ChromeLocalVmConnection $this, WipVm it, InetSocketAddress address) {
        $this.connectionSucceeded((Vm)it, address);
    }

    public static final /* synthetic */ Deferred access$getProcessHandle$p(ChromeLocalVmConnection $this) {
        return $this.processHandle;
    }

    public static final /* synthetic */ boolean access$getReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this) {
        return $this.reusedExistingBrowserInstance;
    }

    public static final /* synthetic */ boolean access$getNewPageRequested$p(ChromeLocalVmConnection $this) {
        return $this.newPageRequested;
    }

    public static final /* synthetic */ void access$setNewPageRequested$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.newPageRequested = bl;
    }
}

