/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.debugger.Vm;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.console.ConsoleMessageValue;
import org.jetbrains.wip.protocol.console.MessageAddedEventData;
import org.jetbrains.wip.protocol.log.EntryAddedEventData;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ExceptionDetailsValue;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aK\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\t2\u001a\b\u0004\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00010\fH\u0082\b\u001a\u001c\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0010"}, d2={"isWorkerMessage", "", "message", "", "vm", "Lorg/jetbrains/debugger/Vm;", "listsAreEqual", "T", "a1", "", "a2", "comparator", "Lkotlin/Function2;", "messagesEquals", "m1", "m2", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nChromeDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcessKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n323#1,7:331\n1726#2,3:338\n1726#2,3:341\n*S KotlinDebug\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcessKt\n*L\n286#1:331,7\n286#1:338,3\n329#1:341,3\n*E\n"})
public final class ChromeDebugProcessKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWorkerMessage(Object message, Vm vm) {
        if (!(message instanceof EntryAddedEventData)) return false;
        if (((EntryAddedEventData)message).entry().source() != LogEntryValue.Source.WORKER) return false;
        Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipVm");
        if (!((WipVm)vm).hasWorker(((EntryAddedEventData)message).entry().getWorkerId())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean messagesEquals(Object m1, Object m2) {
        if (m1 instanceof ConsoleAPICalledEventData) {
            void a1$iv;
            Object object;
            if (!(m2 instanceof ConsoleAPICalledEventData)) {
                return false;
            }
            if (((ConsoleAPICalledEventData)m1).type() != ((ConsoleAPICalledEventData)m2).type()) return false;
            if (((ConsoleAPICalledEventData)m1).getExecutionContextId() != ((ConsoleAPICalledEventData)m2).getExecutionContextId()) return false;
            Object object2 = ((ConsoleAPICalledEventData)m1).getStackTrace();
            if (!Intrinsics.areEqual((Object)(object2 != null && (object2 = object2.callFrames()) != null ? (CallFrameValue)CollectionsKt.getOrNull((List)object2, (int)0) : null), (object = ((ConsoleAPICalledEventData)m2).getStackTrace()) != null && (object = object.callFrames()) != null ? (CallFrameValue)CollectionsKt.getOrNull((List)object, (int)0) : null)) return false;
            List<RemoteObjectValue> list = ((ConsoleAPICalledEventData)m1).args();
            List<RemoteObjectValue> a2$iv = ((ConsoleAPICalledEventData)m2).args();
            boolean $i$f$listsAreEqual = false;
            if (a1$iv != null && a2$iv != null) {
                boolean bl;
                if (a1$iv.size() != a2$iv.size()) {
                    return false;
                }
                Iterable $this$all$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)a1$iv));
                boolean $i$f$all = false;
                if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator = $this$all$iv$iv.iterator();
                do {
                    void e2;
                    int element$iv$iv;
                    if (!iterator.hasNext()) return true;
                    int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    RemoteObjectValue remoteObjectValue = a2$iv.get(it$iv);
                    RemoteObjectValue e1 = (RemoteObjectValue)a1$iv.get(it$iv);
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)e1.value(), (Object)e2.value())) return false;
                    if (!Intrinsics.areEqual((Object)e1.getObjectId(), (Object)e2.getObjectId())) return false;
                    bl = true;
                } while (bl);
                return false;
            }
            boolean bl = Intrinsics.areEqual((Object)a1$iv, a2$iv);
            if (!bl) return false;
            return true;
        }
        if (m1 instanceof EntryAddedEventData) {
            if (!(m2 instanceof EntryAddedEventData)) {
                return false;
            }
            LogEntryValue entry1 = ((EntryAddedEventData)m1).entry();
            LogEntryValue entry2 = ((EntryAddedEventData)m2).entry();
            if (entry1.getLineNumber() != entry2.getLineNumber()) return false;
            if (entry1.source() != entry2.source()) return false;
            if (entry1.level() != entry2.level()) return false;
            if (!Intrinsics.areEqual((Object)entry1.getUrl(), (Object)entry2.getUrl())) return false;
            if (!Intrinsics.areEqual((Object)entry1.text(), (Object)entry2.text())) return false;
            return true;
        }
        if (m1 instanceof ExceptionThrownEventData) {
            if (!(m2 instanceof ExceptionThrownEventData)) {
                return false;
            }
            ExceptionDetailsValue d1 = ((ExceptionThrownEventData)m1).exceptionDetails();
            ExceptionDetailsValue d2 = ((ExceptionThrownEventData)m2).exceptionDetails();
            if (!Intrinsics.areEqual((Object)d1.getUrl(), (Object)d2.getUrl())) return false;
            if (d1.getLineNumber() != d2.getLineNumber()) return false;
            if (d1.getColumnNumber() != d2.getColumnNumber()) return false;
            if (!Intrinsics.areEqual((Object)d1.text(), (Object)d2.text())) return false;
            return true;
        }
        if (!(m1 instanceof MessageAddedEventData)) return false;
        if (!(m2 instanceof MessageAddedEventData)) {
            return false;
        }
        ConsoleMessageValue d1 = ((MessageAddedEventData)m1).message();
        ConsoleMessageValue d2 = ((MessageAddedEventData)m2).message();
        if (d1.getExecutionContextId() != d2.getExecutionContextId()) return false;
        if (d1.getLine() != d2.getLine()) return false;
        if (d1.getColumn() != d2.getColumn()) return false;
        if (d1.level() != d2.level()) return false;
        if (!Intrinsics.areEqual((Object)d1.getUrl(), (Object)d2.getUrl())) return false;
        if (!Intrinsics.areEqual((Object)d1.text(), (Object)d2.text())) return false;
        if (!Intrinsics.areEqual(d1.getParameters(), d2.getParameters())) return false;
        return true;
    }

    private static final <T> boolean listsAreEqual(List<? extends T> a1, List<? extends T> a2, Function2<? super T, ? super T, Boolean> comparator) {
        boolean bl;
        block5: {
            boolean $i$f$listsAreEqual = false;
            if (a1 == null || a2 == null) {
                return Intrinsics.areEqual(a1, a2);
            }
            if (a1.size() != a2.size()) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)a1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (((Boolean)comparator.invoke(a1.get(it), a2.get(it))).booleanValue()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$messagesEquals(Object m1, Object m2) {
        return ChromeDebugProcessKt.messagesEquals(m1, m2);
    }

    public static final /* synthetic */ boolean access$isWorkerMessage(Object message, Vm vm) {
        return ChromeDebugProcessKt.isWorkerMessage(message, vm);
    }
}

