/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.attach;

import com.intellij.execution.filters.Filter;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebuggerIcons;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipWebSocketConnection;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerWsUrlFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "attachDebuggerToWs", "", "url", "WipCheckWsUrlConnection", "intellij.javascript.chrome.connector"})
public final class JSDebuggerWsUrlFilter
implements Filter {
    @NotNull
    private final Project project;

    public JSDebuggerWsUrlFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String string = StringsKt.startsWith$default((String)line, (String)"Debugger listening on ws://", (boolean)false, (int)2, null) ? "Debugger listening on ws://" : (StringsKt.startsWith$default((String)line, (String)"DevTools listening on ws://", (boolean)false, (int)2, null) ? "DevTools listening on ws://" : null);
        if (string == null) {
            return null;
        }
        String prefix = string;
        int startIndexInLine = prefix.length() - 5;
        int startIndex = entireLength - line.length() + startIndexInLine;
        String string2 = line.substring(startIndexInLine);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String url = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return new Filter.Result(startIndex, startIndex + url.length(), arg_0 -> JSDebuggerWsUrlFilter.applyFilter$lambda$0(this, url, arg_0));
    }

    private final void attachDebuggerToWs(String url) {
        URI uri = new URI(url);
        XDebuggerManager.getInstance((Project)this.project).startSessionAndShowTab("ws://" + uri.getAuthority() + "/...", JavaScriptDebuggerIcons.JavaScript_remote_debug_configuration, null, false, new XDebugProcessStarter(url, uri){
            final /* synthetic */ String $url;
            final /* synthetic */ URI $uri;
            {
                this.$url = $url;
                this.$uri = $uri;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                WipRemoteVmConnection connection2 = StringsKt.contains$default((CharSequence)this.$url, (CharSequence)"/devtools/browser/", (boolean)false, (int)2, null) ? (WipRemoteVmConnection)new WipCheckWsUrlConnection(this.$url) : (WipRemoteVmConnection)new WipWebSocketConnection(this.$url, true);
                RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(null, (DebuggableFileFinder)new LocalFileSystemFileFinder(), 1, null);
                NodeChromeDebugProcess process = new NodeChromeDebugProcess(session, (DebuggableFileFinder)finder, connection2, null, 8, null);
                RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)new InetSocketAddress(this.$uri.getHost(), this.$uri.getPort() == -1 ? 80 : this.$uri.getPort()), null, (int)2, null);
                return (XDebugProcess)process;
            }
        });
    }

    private static final void applyFilter$lambda$0(JSDebuggerWsUrlFilter this$0, String $url, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.attachDebuggerToWs($url);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerWsUrlFilter$WipCheckWsUrlConnection;", "Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "wsUrl", "", "(Ljava/lang/String;)V", "processPageConnections", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/wip/WipVm;", "intellij.javascript.chrome.connector"})
    private static final class WipCheckWsUrlConnection
    extends WipRemoteVmConnection {
        @NotNull
        private final String wsUrl;

        public WipCheckWsUrlConnection(@NotNull String wsUrl) {
            Intrinsics.checkNotNullParameter((Object)wsUrl, (String)"wsUrl");
            super(null, null, 3, null);
            this.wsUrl = wsUrl;
        }

        @Override
        protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(pageConnections, (String)"pageConnections");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            for (PageConnection p : pageConnections) {
                if (!Intrinsics.areEqual((Object)this.wsUrl, (Object)p.getWebSocketDebuggerUrl())) continue;
                this.connectDebugger(p, context, result, debugMessageQueue);
                return true;
            }
            return super.processPageConnections(context, debugMessageQueue, pageConnections, result);
        }
    }
}

