/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.AppendableWithRead;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface Out {
    public OutputStream toOutputStream();

    public Appendable toAppendable();

    @NotNull
    public Out append(byte @NotNull [] var1);

    @NotNull
    public Out appendText(@NotNull CharSequence var1);

    public long sizeInBytes();

    public long length();

    default public void close() throws IOException {
    }

    public static final class FromStream
    extends BaseOut {
        @NotNull
        private final OutputStream myStream;
        private long size;

        public FromStream(@NotNull OutputStream stream) {
            if (stream == null) {
                FromStream.$$$reportNull$$$0(0);
            }
            this.myStream = stream;
        }

        @Override
        protected Out appendImpl(byte @NotNull [] bytes) {
            if (bytes == null) {
                FromStream.$$$reportNull$$$0(1);
            }
            try {
                this.myStream.write(bytes);
                this.size += (long)bytes.length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public long sizeInBytes() {
            return this.size;
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/Out$FromStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Wrapper
    extends BaseOut {
        private final Out myDelegate;

        public Wrapper(Out delegate) {
            this.myDelegate = delegate;
        }

        public Out getDelegate() {
            return this.myDelegate;
        }

        @Override
        @NotNull
        public Out append(byte @NotNull [] bytes) {
            if (bytes == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            Out out = this.myDelegate.append(bytes);
            if (out == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            return out;
        }

        @Override
        @NotNull
        public Out appendText(@NotNull CharSequence seq) {
            if (seq == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            Out out = this.myDelegate.appendText(seq);
            if (out == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            return out;
        }

        @Override
        public long sizeInBytes() {
            return this.myDelegate.sizeInBytes();
        }

        @Override
        public long length() {
            return this.myDelegate.length();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/Out$Wrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "seq";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/Out$Wrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Readable
    extends BaseOut {
        private final ByteArrayOutputStream stream;

        public Readable() {
            this.stream = new ByteArrayOutputStream();
        }

        public Readable(int capacity) {
            this.stream = new ByteArrayOutputStream(capacity);
        }

        @Override
        protected Out appendImpl(byte @NotNull [] bytes) {
            if (bytes == null) {
                Readable.$$$reportNull$$$0(0);
            }
            try {
                this.stream.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public long sizeInBytes() {
            return this.stream.size();
        }

        @Override
        @NotNull
        public String getString() {
            String string = this.stream.toString(StandardCharsets.UTF_8);
            if (string == null) {
                Readable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public byte[] toBytes() {
            return this.stream.toByteArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/Out$Readable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/Out$Readable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendImpl";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class BaseOut
    implements Out {
        private final OutputStream meAsOutputStream = new OutputStream(){

            @Override
            public void write(@NotNull byte[] b) {
                if (b == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(b);
            }

            @Override
            public void write(@NotNull byte[] b, int off, int len) {
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.append(Arrays.copyOfRange(b, off, off + len));
            }

            @Override
            public void write(int b) {
                this.append(new byte[]{(byte)b});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/util/Out$BaseOut$1", "write"));
            }
        };
        private final AppendableWithRead meAsAppendable = new AppendableWithRead(){

            @Override
            public Appendable append(CharSequence csq) {
                this.appendText(csq);
                return this;
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end2) {
                return this.append(csq.subSequence(start, end2));
            }

            @Override
            public Appendable append(char c) {
                return this.append(String.valueOf(c));
            }

            @Override
            @NotNull
            public String getString() {
                String string = this.getString();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Out$BaseOut$2", "getString"));
            }
        };
        private boolean writtenRawBytes = false;
        private long length = 0L;

        @Override
        public OutputStream toOutputStream() {
            return this.meAsOutputStream;
        }

        @Override
        public Appendable toAppendable() {
            return this.meAsAppendable;
        }

        protected Out append(byte @NotNull [] bytes, boolean rawBytes) {
            if (bytes == null) {
                BaseOut.$$$reportNull$$$0(0);
            }
            this.writtenRawBytes |= rawBytes;
            return this.appendImpl(bytes);
        }

        protected Out appendImpl(byte @NotNull [] bytes) {
            if (bytes == null) {
                BaseOut.$$$reportNull$$$0(1);
            }
            return this;
        }

        @Override
        @NotNull
        public Out append(byte @NotNull [] bytes) {
            if (bytes == null) {
                BaseOut.$$$reportNull$$$0(2);
            }
            Out out = this.append(bytes, true);
            if (out == null) {
                BaseOut.$$$reportNull$$$0(3);
            }
            return out;
        }

        @Override
        @NotNull
        public Out appendText(@NotNull CharSequence seq) {
            if (seq == null) {
                BaseOut.$$$reportNull$$$0(4);
            }
            this.length += (long)seq.length();
            Out out = this.append(seq.toString().getBytes(StandardCharsets.UTF_8), false);
            if (out == null) {
                BaseOut.$$$reportNull$$$0(5);
            }
            return out;
        }

        @Override
        public long length() {
            if (this.writtenRawBytes) {
                throw new AssertionError((Object)"Raw bytes has already been written in this Out. Impossible to calculate length");
            }
            return this.length;
        }

        @NotNull
        public String getString() {
            String string = this.toString();
            if (string == null) {
                BaseOut.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/Out$BaseOut";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "seq";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/Out$BaseOut";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendImpl";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

