/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.extensions.DataColumn;
import com.intellij.database.extensions.DataExtractorBindings;
import com.intellij.database.extensions.DataRow;
import com.intellij.database.extensions.DataStream;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extensions.ValueFormatter;
import com.intellij.database.extractors.DataColumnImpl;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataRowImpl;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HierarchicalDataColumnImpl;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.util.Out;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptDataExtractor
implements DataExtractor {
    private final Project myProject;
    private final Path myScriptFile;
    private final IdeScriptEngine engine;
    private final boolean isAggregator;
    private final boolean supportsText;

    public ScriptDataExtractor(@Nullable Project project, @NotNull Path scriptFile, @NotNull IdeScriptEngine engine, @NotNull ObjectFormatter objectFormatter, boolean isAggregator, boolean supportsText) {
        if (scriptFile == null) {
            ScriptDataExtractor.$$$reportNull$$$0(0);
        }
        if (engine == null) {
            ScriptDataExtractor.$$$reportNull$$$0(1);
        }
        if (objectFormatter == null) {
            ScriptDataExtractor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myScriptFile = scriptFile;
        this.isAggregator = isAggregator;
        this.supportsText = supportsText;
        this.engine = engine;
        ExtensionScriptsUtil.setBindings(engine).bind(DataExtractorBindings.PROJECT, project).bind(DataExtractorBindings.FORMATTER, this.createFormatter(objectFormatter));
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return ScriptDataExtractor.getFileExtension(this.myScriptFile);
    }

    @Override
    public boolean supportsText() {
        return this.supportsText;
    }

    @NotNull
    private static String getFileExtension(@NotNull Path scriptFile) {
        if (scriptFile == null) {
            ScriptDataExtractor.$$$reportNull$$$0(3);
        }
        String string = ExtractorScripts.getOutputFileExtension(scriptFile.getFileName().toString());
        if (string == null) {
            ScriptDataExtractor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public DataExtractor.Extraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            ScriptDataExtractor.$$$reportNull$$$0(5);
        }
        if (allColumns == null) {
            ScriptDataExtractor.$$$reportNull$$$0(6);
        }
        if (query == null) {
            ScriptDataExtractor.$$$reportNull$$$0(7);
        }
        if (config == null) {
            ScriptDataExtractor.$$$reportNull$$$0(8);
        }
        ExtractionDataConveyor conveyor = new ExtractionDataConveyor(selectedColumns, allColumns.size());
        ExtractionDataConveyor.DataStreamImpl stream = conveyor.outputStream;
        this.prepareEngine(out, stream, allColumns, config.isTransposed(), selectedColumns);
        conveyor.setBinder(() -> ExtensionScriptsUtil.setBindings(this.engine));
        boolean errorMessagesDisabled = config.getSilent();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ExtensionScriptsUtil.prepareScript(this.myScriptFile);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Throwable exception = null;
            try {
                ExtensionScriptsUtil.evalScript(this.myProject, this.engine, this.myScriptFile, !this.isAggregator && !errorMessagesDisabled);
            }
            catch (Throwable th) {
                exception = th;
            }
            finally {
                stream.close(exception);
            }
        });
        ExtractionDataConveyor.ScriptExtraction scriptExtraction = conveyor.extractionInput;
        if (scriptExtraction == null) {
            ScriptDataExtractor.$$$reportNull$$$0(9);
        }
        return scriptExtraction;
    }

    private void prepareEngine(@NotNull Out out, @NotNull DataStream<DataRowImpl> stream, @NotNull List<? extends GridColumn> allColumns, boolean transposed, int ... selectedColumns) {
        if (out == null) {
            ScriptDataExtractor.$$$reportNull$$$0(10);
        }
        if (stream == null) {
            ScriptDataExtractor.$$$reportNull$$$0(11);
        }
        if (allColumns == null) {
            ScriptDataExtractor.$$$reportNull$$$0(12);
        }
        List<? extends DataColumn> dataColumns = ScriptDataExtractor.createDataColumns(allColumns, selectedColumns);
        ExtensionScriptsUtil.setBindings(this.engine).bind(DataExtractorBindings.ALL_COLUMNS, dataColumns).bind(DataExtractorBindings.COLUMNS, ScriptDataExtractor.getSelectedDataColumns(dataColumns, selectedColumns)).bind(DataExtractorBindings.OUT, ScriptDataExtractor.createOutput(out)).bind(DataExtractorBindings.ROWS, stream).bind(DataExtractorBindings.TRANSPOSED, transposed);
    }

    @NotNull
    private ValueFormatter createFormatter(final @NotNull ObjectFormatter objectFormatter) {
        if (objectFormatter == null) {
            ScriptDataExtractor.$$$reportNull$$$0(13);
        }
        final DatabaseObjectFormatterConfig config = StringUtil.equalsIgnoreCase((CharSequence)"sql", (CharSequence)this.getFileExtension()) ? new DatabaseObjectFormatterConfig(ObjectFormatterMode.SQL_SCRIPT) : (StringUtil.equalsIgnoreCase((CharSequence)"json", (CharSequence)this.getFileExtension()) ? new DatabaseObjectFormatterConfig(ObjectFormatterMode.JSON) : new DatabaseObjectFormatterConfig(ObjectFormatterMode.DEFAULT));
        return new ValueFormatter(){

            @Override
            @NotNull
            public String format(@NotNull DataRow row, @NotNull DataColumn column) {
                if (row == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (column == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = this.formatValue(row.value(column), column);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @NotNull
            public String formatValue(@Nullable Object o, @NotNull DataColumn column) {
                if (column == null) {
                    1.$$$reportNull$$$0(3);
                }
                String str = objectFormatter.objectToString(o, ((DataColumnImpl)column).getColumn(), config);
                String string = StringUtil.notNullize((String)str, (String)"null");
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            @NotNull
            public String getTypeName(@Nullable Object o, @NotNull DataColumn column) {
                if (column == null) {
                    1.$$$reportNull$$$0(5);
                }
                String string = ScriptDataExtractor.this.getTypeName(o, (DataColumnImpl)column);
                if (string == null) {
                    1.$$$reportNull$$$0(6);
                }
                return string;
            }

            @Override
            public boolean isStringLiteral(@Nullable Object o, @NotNull DataColumn column) {
                if (column == null) {
                    1.$$$reportNull$$$0(7);
                }
                return objectFormatter.isStringLiteral(((DataColumnImpl)column).getColumn(), o, config.getMode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "row";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/extractors/ScriptDataExtractor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/extractors/ScriptDataExtractor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "format";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "formatValue";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "format";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "formatValue";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeName";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "isStringLiteral";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    protected String getTypeName(@Nullable Object o, DataColumnImpl column) {
        String string = (String)ObjectUtils.notNull((Object)StringUtil.nullize((String)column.getColumn().getTypeName()), (Object)"unknown");
        if (string == null) {
            ScriptDataExtractor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static List<? extends DataColumn> getSelectedDataColumns(List<? extends DataColumn> allDataColumns, int[] selectedColumns) {
        if (selectedColumns.length == 0) {
            return allDataColumns;
        }
        ArrayList<DataColumn> selectedDataColumns = new ArrayList<DataColumn>(selectedColumns.length);
        Set<Integer> indicesSet = GridExtractorsUtilCore.intArrayToSet(selectedColumns);
        for (int i = 0; i < allDataColumns.size(); ++i) {
            DataColumn dataColumn = allDataColumns.get(i);
            if (dataColumn instanceof HierarchicalDataColumnImpl) {
                HierarchicalDataColumnImpl hierarchical = (HierarchicalDataColumnImpl)dataColumn;
                if (!hierarchical.isMatchesSelection()) continue;
                selectedDataColumns.add(dataColumn);
                continue;
            }
            if (!indicesSet.contains(i)) continue;
            selectedDataColumns.add(dataColumn);
        }
        return selectedDataColumns;
    }

    @NotNull
    private static List<? extends DataColumn> createDataColumns(List<? extends GridColumn> allColumns, int[] selectedColumns) {
        ArrayList<DataColumnImpl> dataColumns = new ArrayList<DataColumnImpl>();
        for (GridColumn gridColumn : allColumns) {
            if (gridColumn instanceof HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn) {
                HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn hierarchical = (HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn)gridColumn;
                dataColumns.add(new HierarchicalDataColumnImpl(hierarchical));
                continue;
            }
            dataColumns.add(new DataColumnImpl(gridColumn));
        }
        ArrayList<DataColumnImpl> arrayList = dataColumns;
        if (arrayList == null) {
            ScriptDataExtractor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static Appendable createOutput(final Out out) {
        return new Appendable(){

            @Override
            public Appendable append(CharSequence csq) {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end2) {
                out.appendText(csq.subSequence(start, end2));
                return this;
            }

            @Override
            public Appendable append(char c) {
                return this.append(String.valueOf(c));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ScriptDataExtractor";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ScriptDataExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startExtraction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startExtraction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFormatter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static class ExtractionDataConveyor {
        public final ScriptExtraction extractionInput = new ScriptExtraction();
        public final DataStreamImpl outputStream = new DataStreamImpl();
        final int[] mySelectedColumns;
        private int myAllColumnsCount;
        private List<? extends DataColumn> myAllColumnsUpdate = null;
        Supplier<ExtensionScriptsUtil.Binder> myBinder;
        private final Queue<RowUpdate> myRowsQueue = new ArrayDeque<RowUpdate>();
        private boolean myRowsDequeued;
        private boolean myAllRowsLoaded;
        private boolean myStopped;
        private Throwable myStopReason;

        ExtractionDataConveyor(int[] selectedColumns, int allColumnsCount) {
            this.mySelectedColumns = selectedColumns;
            this.myAllColumnsCount = allColumnsCount;
        }

        public synchronized void setBinder(@NotNull Supplier<ExtensionScriptsUtil.Binder> binder) {
            if (binder == null) {
                ExtractionDataConveyor.$$$reportNull$$$0(0);
            }
            this.myBinder = binder;
        }

        public synchronized void enqueue(List<? extends GridRow> rows) {
            this.myRowsQueue.addAll(ContainerUtil.map(rows, row -> this.createUpdate((GridRow)row)));
            this.notifyAll();
            this.waitUntilRowsAreDequeued();
        }

        private RowUpdate createUpdate(GridRow row) {
            RowUpdate update = new RowUpdate(row, this.myAllColumnsUpdate);
            this.myAllColumnsUpdate = null;
            return update;
        }

        private synchronized void updateColumns(GridColumn[] columns) {
            if (columns.length == this.myAllColumnsCount) {
                return;
            }
            this.myAllColumnsCount = columns.length;
            this.myAllColumnsUpdate = ScriptDataExtractor.createDataColumns(Arrays.asList(columns), this.mySelectedColumns);
        }

        public synchronized void allRowsEnqueued() {
            this.myAllRowsLoaded = true;
            this.notifyAll();
            this.waitUntilStopped();
        }

        public synchronized DataRowImpl dequeue() {
            this.waitUntilRowsAreEnqueued();
            if (this.myRowsQueue.isEmpty()) {
                throw new AssertionError();
            }
            RowUpdate update = this.myRowsQueue.remove();
            if (update.myAllColumnsUpdate != null) {
                this.myBinder.get().bind(DataExtractorBindings.ALL_COLUMNS, update.myAllColumnsUpdate).bind(DataExtractorBindings.COLUMNS, ScriptDataExtractor.getSelectedDataColumns(update.myAllColumnsUpdate, this.mySelectedColumns));
            }
            DataRowImpl dataRow = new DataRowImpl(update.myRow, !this.myRowsDequeued, this.myAllRowsLoaded && this.myRowsQueue.isEmpty());
            this.myRowsDequeued = true;
            this.notifyAll();
            return dataRow;
        }

        public synchronized boolean isDepleted() {
            return this.myAllRowsLoaded && this.myRowsQueue.isEmpty();
        }

        public synchronized void stop(@Nullable Throwable error) {
            this.myStopped = true;
            this.myStopReason = error;
            this.notifyAll();
        }

        private synchronized void waitUntilRowsAreEnqueued() {
            while (!this.myAllRowsLoaded && this.myRowsQueue.size() < 2) {
                this.checkStopped();
                this.doWait();
            }
        }

        private synchronized void waitUntilRowsAreDequeued() {
            while (!this.myAllRowsLoaded && this.myRowsQueue.size() > 1) {
                if (this.checkStopped()) {
                    this.myRowsQueue.clear();
                    continue;
                }
                this.doWait();
            }
        }

        private synchronized void waitUntilStopped() {
            while (!this.checkStopped()) {
                this.doWait();
            }
        }

        private synchronized boolean checkStopped() {
            if (this.myStopReason != null) {
                throw this.myStopReason instanceof ProcessCanceledException ? (ProcessCanceledException)this.myStopReason : new ProcessCanceledException(this.myStopReason);
            }
            return this.myStopped;
        }

        private synchronized void doWait() {
            try {
                this.wait(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "com/intellij/database/extractors/ScriptDataExtractor$ExtractionDataConveyor", "setBinder"));
        }

        private class ScriptExtraction
        implements DataExtractor.Extraction {
            private ScriptExtraction() {
            }

            @Override
            public void updateColumns(GridColumn @NotNull [] columns) {
                if (columns == null) {
                    ScriptExtraction.$$$reportNull$$$0(0);
                }
                ExtractionDataConveyor.this.updateColumns(columns);
            }

            @Override
            public void addData(List<? extends GridRow> rows) {
                ExtractionDataConveyor.this.enqueue(rows);
            }

            @Override
            public void complete() {
                ExtractionDataConveyor.this.allRowsEnqueued();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/extractors/ScriptDataExtractor$ExtractionDataConveyor$ScriptExtraction", "updateColumns"));
            }
        }

        class DataStreamImpl
        extends DataStream<DataRowImpl> {
            final AtomicReference<Iterator<DataRowImpl>> iterator = new AtomicReference<1>(new Iterator<DataRowImpl>(){

                @Override
                public boolean hasNext() {
                    return !ExtractionDataConveyor.this.isDepleted();
                }

                @Override
                public DataRowImpl next() {
                    return ExtractionDataConveyor.this.dequeue();
                }
            });

            DataStreamImpl() {
            }

            @NotNull
            public Iterator<DataRowImpl> iterator() {
                Iterator result = this.iterator.getAndSet(null);
                if (result == null) {
                    throw new AssertionError((Object)"This data stream can only be iterated once");
                }
                Iterator iterator = result;
                if (iterator == null) {
                    DataStreamImpl.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            void close(@Nullable Throwable error) {
                ExtractionDataConveyor.this.stop(error);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ScriptDataExtractor$ExtractionDataConveyor$DataStreamImpl", "iterator"));
            }
        }

        static class RowUpdate {
            final GridRow myRow;
            final List<? extends DataColumn> myAllColumnsUpdate;

            RowUpdate(GridRow row, List<? extends DataColumn> allColumnsUpdate) {
                this.myRow = row;
                this.myAllColumnsUpdate = allColumnsUpdate;
            }
        }
    }
}

