/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.datagrid.ObjectNormalizerProvider;
import com.intellij.database.extensions.DataConsumer;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptedGridDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn> {
    private final DataGridListModel myModel;
    private final GridMutationModel myMutationModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    private final DataLoader myLoader;
    private final VirtualFile myFile;
    private final Supplier<@Nullable Boolean> myFirstRowIsHeader;
    private final MultiPageModel<GridRow, GridColumn> myPageModel;
    private final com.intellij.util.Function<GridDataRequest.Context, @NotNull ObjectNormalizer> myNormalizerCache;

    public ScriptedGridDataHookUp(@NotNull Project project, @NotNull DataLoader loader, @NotNull VirtualFile file, @NotNull Supplier<@Nullable Boolean> firstRowIsHeader) {
        if (project == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (firstRowIsHeader == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(3);
        }
        this(project, loader, file, firstRowIsHeader, (TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean>)((TripleFunction)(a, b, ignored) -> GridCellEditorHelper.areValuesEqual(a, b)));
    }

    public ScriptedGridDataHookUp(@NotNull Project project, @NotNull DataLoader loader, @NotNull VirtualFile file, @NotNull Supplier<@Nullable Boolean> firstRowIsHeader, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual) {
        if (project == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(4);
        }
        if (loader == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(6);
        }
        if (firstRowIsHeader == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(7);
        }
        if (valuesEqual == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(8);
        }
        super(project);
        this.myNormalizerCache = ObjectNormalizerProvider.getCache();
        this.myLoader = loader;
        this.myFile = file;
        this.myFirstRowIsHeader = firstRowIsHeader;
        this.myModel = new DataGridListModel((v1, v2) -> (Boolean)valuesEqual.fun(v1, v2, (Object)this));
        this.myMutationModel = new GridMutationModel(this);
        this.myModelUpdater = new GridStorageAndModelUpdater(this.myModel, this.myMutationModel, null);
        this.myPageModel = new MultiPageModelImpl<GridRow, GridColumn>(this.myMutationModel, null);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        MultiPageModel<GridRow, GridColumn> multiPageModel = this.myPageModel;
        if (multiPageModel == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(10);
        }
        return multiPageModel;
    }

    @Override
    @NotNull
    public GridLoader getLoader() {
        return new GridLoader(){

            @Override
            public void reloadCurrentPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.load(source, ScriptedGridDataHookUp.this.getPageModel().getPageStart());
            }

            @Override
            public void loadNextPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.load(source, ScriptedGridDataHookUp.this.getPageModel().getPageEnd());
            }

            @Override
            public void loadPreviousPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.load(source, Math.max(ScriptedGridDataHookUp.this.getPageModel().getPageStart() - ScriptedGridDataHookUp.this.getPageModel().getPageSize(), 0));
            }

            @Override
            public void loadLastPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.load(source, -1);
            }

            @Override
            public void loadFirstPage(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.load(source, 0);
            }

            @Override
            public void load(@NotNull GridRequestSource source, int offset) {
                if (source == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.saveFile();
                ScriptedGridDataHookUp.this.myModel.setUpdatingNow(true);
                ScriptedGridDataHookUp.this.myModelUpdater.removeRows(0, ScriptedGridDataHookUp.this.myModel.getRowCount());
                ScriptedGridDataHookUp.this.notifyRequestStarted(source);
                this.notifyProgress(source, null);
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadImpl(source, offset));
            }

            private void notifyProgress(@NotNull GridRequestSource source, @Nls @Nullable String progress) {
                if (source == null) {
                    1.$$$reportNull$$$0(6);
                }
                HtmlBuilder builder = new HtmlBuilder();
                builder.append(DataGridBundle.message("progress.text.loading.script", new Object[0]));
                if (progress != null) {
                    builder.br().append(StringUtil.shortenTextWithEllipsis((String)progress, (int)50, (int)10));
                }
                ScriptedGridDataHookUp.this.notifyRequestProgress(source, builder.wrapWith("center").wrapWith("body").wrapWith("html").toString());
            }

            private void saveFile() {
                FileDocumentManager fdm = FileDocumentManager.getInstance();
                Document document = fdm.getCachedDocument(ScriptedGridDataHookUp.this.myFile);
                if (document != null) {
                    fdm.saveDocument(document);
                }
            }

            private void loadImpl(final @NotNull GridRequestSource source, int offset) {
                if (source == null) {
                    1.$$$reportNull$$$0(7);
                }
                Context requestContext = new Context();
                int ps = ScriptedGridDataHookUp.this.getPageModel().getPageSize();
                int endOffset = ps > 0 && offset >= 0 ? offset + ps : Integer.MAX_VALUE;
                try {
                    ScriptedGridDataHookUp.this.myLoader.ensureInitialized(new DataLoader.ScriptProgressMessagesConsumer(){

                        @Override
                        public void message(@NotNull String text) {
                            if (text == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.notifyProgress(source, text);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/ScriptedGridDataHookUp$1$1", "message"));
                        }
                    });
                    this.consumeRows(offset, ps, endOffset, columns -> ApplicationManager.getApplication().invokeLater(() -> ScriptedGridDataHookUp.this.myModelUpdater.setColumns((List<? extends GridColumn>)columns)), (rows, fetched) -> {
                        if (ScriptedGridDataHookUp.this.myModel.getRowCount() == 0) {
                            ScriptedGridDataHookUp.this.notifyRequestProgress(source, DataGridBundle.message("progress.text.loading.data", new Object[0]));
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            ObjectNormalizer.convertRows((ObjectNormalizer)ScriptedGridDataHookUp.this.myNormalizerCache.fun((Object)requestContext), rows, ScriptedGridDataHookUp.this.myModel.getColumns());
                            ScriptedGridDataHookUp.this.myModelUpdater.addRows((List<? extends GridRow>)rows);
                            int start = offset < 0 ? (ps > 0 ? fetched - ps : 0) : offset;
                            ScriptedGridDataHookUp.this.myPageModel.setPageStart(start);
                            ScriptedGridDataHookUp.this.myPageModel.setPageEnd((int)fetched);
                            if (!(ScriptedGridDataHookUp.this.myPageModel.isTotalRowCountPrecise() || (long)fetched.intValue() <= ScriptedGridDataHookUp.this.myPageModel.getTotalRowCount() && ScriptedGridDataHookUp.this.myPageModel.getPageEnd() != fetched.intValue())) {
                                ScriptedGridDataHookUp.this.myPageModel.setTotalRowCount(fetched.intValue(), endOffset > fetched);
                            }
                            ScriptedGridDataHookUp.this.myModelUpdater.afterLastRowAdded();
                            ScriptedGridDataHookUp.this.notifyRequestFinished(source, true);
                        });
                    });
                }
                catch (ProcessCanceledException c) {
                    ScriptedGridDataHookUp.this.notifyRequestFinished(source, false);
                    throw c;
                }
                catch (Throwable e) {
                    ScriptedGridDataHookUp.this.notifyRequestError(source, SimpleErrorInfo.create(e));
                    ScriptedGridDataHookUp.this.notifyRequestFinished(source, false);
                }
            }

            private void consumeRows(int offset, int ps, int endOffset, Consumer<List<DataConsumer.Column>> columnsConsumer, BiConsumer<List<DataConsumer.Row>, Integer> rowsConsumer) throws Exception {
                ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>();
                Consumer<DataConsumer.Row> consumer = offset < 0 && ps > 0 ? new CyclicConsumer(ps) : rows::add;
                RowsConsumer dataConsumer = new RowsConsumer(offset, endOffset, Boolean.TRUE.equals(ScriptedGridDataHookUp.this.myFirstRowIsHeader.get()), consumer, columnsConsumer);
                try {
                    ScriptedGridDataHookUp.this.myLoader.loadFromFile(ScriptedGridDataHookUp.this.getProject(), ScriptedGridDataHookUp.this.myFile, dataConsumer);
                }
                catch (PageEndException pageEndException) {
                    // empty catch block
                }
                if (consumer instanceof CyclicConsumer) {
                    Consumer<DataConsumer.Row> cc = consumer;
                    rows.addAll(((CyclicConsumer)cc).getRows());
                }
                rowsConsumer.accept(rows, dataConsumer.rowIdx);
            }

            @Override
            public void updateTotalRowCount(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(8);
                }
                try {
                    CountConsumer consumer = new CountConsumer();
                    ScriptedGridDataHookUp.this.myLoader.loadFromFile(ScriptedGridDataHookUp.this.getProject(), ScriptedGridDataHookUp.this.myFile, consumer);
                    ScriptedGridDataHookUp.this.myPageModel.setTotalRowCount(Math.max(consumer.getCount(), 0), true);
                    ScriptedGridDataHookUp.this.notifyRequestFinished(source, true);
                }
                catch (ProcessCanceledException c) {
                    ScriptedGridDataHookUp.this.notifyRequestFinished(source, false);
                    throw c;
                }
                catch (Exception e) {
                    ScriptedGridDataHookUp.this.notifyRequestError(source, SimpleErrorInfo.create(e));
                }
            }

            @Override
            public void applyFilterAndSorting(@NotNull GridRequestSource source) {
                if (source == null) {
                    1.$$$reportNull$$$0(9);
                }
                ScriptedGridDataHookUp.this.notifyRequestFinished(source, false);
            }

            @Override
            public void updateIsTotalRowCountUpdateable() {
                ScriptedGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "source";
                objectArray2[1] = "com/intellij/database/datagrid/ScriptedGridDataHookUp$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadCurrentPage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadNextPage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadPreviousPage";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadLastPage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadFirstPage";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "load";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyProgress";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadImpl";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateTotalRowCount";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyFilterAndSorting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            static class CyclicConsumer
            implements Consumer<DataConsumer.Row> {
                private final DataConsumer.Row[] myRows;
                private int mySize;

                CyclicConsumer(int pageSize) {
                    this.myRows = new DataConsumer.Row[pageSize];
                    this.mySize = 0;
                }

                @Override
                public void accept(DataConsumer.Row objects) {
                    this.myRows[this.mySize++ % this.myRows.length] = objects;
                }

                @NotNull
                public List<DataConsumer.Row> getRows() {
                    return new AbstractList<DataConsumer.Row>(){

                        @Override
                        public DataConsumer.Row get(int i) {
                            return myRows[mySize < myRows.length ? i : (mySize + i) % myRows.length];
                        }

                        @Override
                        public int size() {
                            return Math.max(mySize, myRows.length);
                        }
                    };
                }
            }
        };
    }

    @Override
    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(11);
        }
        return gridMutationModel;
    }

    @Override
    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            ScriptedGridDataHookUp.$$$reportNull$$$0(12);
        }
        return dataGridListModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstRowIsHeader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/ScriptedGridDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/ScriptedGridDataHookUp";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private class CountConsumer
    extends DataConsumer {
        private int cnt;

        private CountConsumer() {
            this.cnt = Boolean.TRUE.equals(ScriptedGridDataHookUp.this.myFirstRowIsHeader.get()) ? -1 : 0;
        }

        @Override
        public void consumeColumns(String[] names, Class<?>[] types) {
        }

        @Override
        public void consume(Object ... row) {
            ++this.cnt;
        }

        public int getCount() {
            return Math.max(this.cnt, 0);
        }
    }

    private static class RowsConsumer
    extends DataConsumer {
        private final int myOffset;
        private final int myEndOffset;
        int rowIdx;
        private boolean columnsAreSetByScript;
        private List<DataConsumer.Column> columnsToSet;
        private final Consumer<List<DataConsumer.Column>> myColumnsConsumer;
        private final Consumer<DataConsumer.Row> myRowConsumer;

        RowsConsumer(int offset, int endOffset, boolean firstRowIsHeader, Consumer<DataConsumer.Row> rowConsumer, Consumer<List<DataConsumer.Column>> columnsConsumer) {
            this.myOffset = offset;
            this.myEndOffset = endOffset;
            this.myRowConsumer = rowConsumer;
            this.rowIdx = firstRowIsHeader ? -1 : 0;
            this.myColumnsConsumer = columnsConsumer;
            this.columnsToSet = Collections.emptyList();
        }

        @Override
        public void consumeColumns(String[] names, Class<?>[] types) {
            ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(names.length);
            for (String name : names) {
                int idx = columns.size();
                Class<?> type = types[idx];
                columns.add(new DataConsumer.Column(idx, name, 1111, type.getSimpleName(), type.getName()));
            }
            this.columnsToSet = columns;
            this.columnsAreSetByScript = true;
        }

        @Override
        public void consume(Object ... row) {
            this.updateColumnsFromData(row);
            if (this.rowIdx != -1 && this.rowIdx >= this.myOffset) {
                this.myRowConsumer.accept(DataConsumer.Row.create(this.rowIdx, row));
            }
            ++this.rowIdx;
            if (this.rowIdx >= this.myEndOffset) {
                throw new PageEndException();
            }
        }

        private void updateColumnsFromData(Object[] row) {
            DataConsumer.Column prevColumn;
            int idx;
            ArrayList<DataConsumer.Column> columns;
            if (this.rowIdx == -1) {
                columns = new ArrayList<DataConsumer.Column>(row.length);
                for (Object v : row) {
                    idx = columns.size();
                    prevColumn = (DataConsumer.Column)ContainerUtil.getOrElse(this.columnsToSet, (int)idx, null);
                    columns.add(RowsConsumer.withNewName(String.valueOf(v), prevColumn, idx));
                }
                this.columnsToSet = columns;
            }
            if (this.rowIdx != 0) {
                return;
            }
            if (!this.columnsAreSetByScript) {
                columns = new ArrayList(row.length);
                for (Object v : row) {
                    idx = columns.size();
                    prevColumn = (DataConsumer.Column)ContainerUtil.getOrElse(this.columnsToSet, (int)idx, null);
                    Class type = v == null ? Object.class : v.getClass();
                    columns.add(new DataConsumer.Column(idx, (String)(prevColumn == null ? "C" + idx : prevColumn.getName()), 1111, type.getSimpleName(), type.getName()));
                }
                while (columns.size() < this.columnsToSet.size()) {
                    columns.add(this.columnsToSet.get(columns.size()));
                }
                this.columnsToSet = columns;
            }
            this.myColumnsConsumer.accept(this.columnsToSet);
        }

        @NotNull
        private static DataConsumer.Column withNewName(String name, DataConsumer.Column prevColumn, int idx) {
            if (prevColumn == null) {
                Class<Object> type = Object.class;
                return new DataConsumer.Column(idx, name, 1111, type.getSimpleName(), type.getName());
            }
            return new DataConsumer.Column(idx, name, prevColumn.getType(), prevColumn.getTypeName(), prevColumn.getJavaClassName());
        }
    }

    private static class PageEndException
    extends ProcessCanceledException {
        private PageEndException() {
        }
    }

    public static class ScriptedLoaderFileConfig {
        private static final FileAttribute SCRIPTED_LOADER_CONFIG_ATTR = new FileAttribute("scripted_loader_config", 1, true);
        private static final Key<ScriptedLoaderFileConfig> SCRIPTED_LOADER_CONFIG = Key.create((String)"SCRIPTED_LOADER_CONFIG");
        private static final ScriptedLoaderFileConfig DEFAULT = new ScriptedLoaderFileConfig(null);
        @Nullable
        private final Boolean myFirstRowIsHeader;

        public ScriptedLoaderFileConfig(@Nullable Boolean firstRowIsHeader) {
            this.myFirstRowIsHeader = firstRowIsHeader;
        }

        @Nullable
        public Boolean getFirstRowIsHeader() {
            return this.myFirstRowIsHeader;
        }

        @NotNull
        public ScriptedLoaderFileConfig withFirstRowIsHeader(@Nullable Boolean firstRowIsHeader) {
            return new ScriptedLoaderFileConfig(firstRowIsHeader);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScriptedLoaderFileConfig)) {
                return false;
            }
            ScriptedLoaderFileConfig config = (ScriptedLoaderFileConfig)o;
            return Objects.equals(this.myFirstRowIsHeader, config.myFirstRowIsHeader);
        }

        public int hashCode() {
            return Objects.hashCode(this.myFirstRowIsHeader);
        }

        @NotNull
        public static ScriptedLoaderFileConfig get(@NotNull VirtualFile file) {
            ScriptedLoaderFileConfig res;
            if (file == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(0);
            }
            if ((res = (ScriptedLoaderFileConfig)SCRIPTED_LOADER_CONFIG.get((UserDataHolder)file)) != null) {
                ScriptedLoaderFileConfig scriptedLoaderFileConfig = res;
                if (scriptedLoaderFileConfig == null) {
                    ScriptedLoaderFileConfig.$$$reportNull$$$0(1);
                }
                return scriptedLoaderFileConfig;
            }
            res = ScriptedLoaderFileConfig.read(file);
            if (res != DEFAULT) {
                SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)res);
            }
            ScriptedLoaderFileConfig scriptedLoaderFileConfig = res;
            if (scriptedLoaderFileConfig == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(2);
            }
            return scriptedLoaderFileConfig;
        }

        public static void modify(@NotNull VirtualFile file, @NotNull Function<ScriptedLoaderFileConfig, ScriptedLoaderFileConfig> transform) {
            ScriptedLoaderFileConfig config;
            ScriptedLoaderFileConfig current;
            if (file == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(3);
            }
            if (transform == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(4);
            }
            if ((current = ScriptedLoaderFileConfig.get(file)).equals(config = transform.apply(current))) {
                return;
            }
            SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)config);
            ScriptedLoaderFileConfig.write(file, config);
        }

        public static void set(@NotNull VirtualFile file, @NotNull ScriptedLoaderFileConfig config) {
            ScriptedLoaderFileConfig current;
            if (file == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(5);
            }
            if (config == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(6);
            }
            if ((current = ScriptedLoaderFileConfig.get(file)).equals(config)) {
                return;
            }
            SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)config);
            ScriptedLoaderFileConfig.write(file, config);
        }

        private static void write(@NotNull VirtualFile file, @NotNull ScriptedLoaderFileConfig config) {
            if (file == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(7);
            }
            if (config == null) {
                ScriptedLoaderFileConfig.$$$reportNull$$$0(8);
            }
            if (!(file instanceof VirtualFileWithId)) {
                return;
            }
            try (AttributeOutputStream stream = SCRIPTED_LOADER_CONFIG_ATTR.writeFileAttribute(file);){
                ScriptedLoaderFileConfig.writeNullableBool(stream, config.getFirstRowIsHeader());
            }
            catch (IOException e) {
                Logger.getInstance(ScriptedLoaderFileConfig.class).warn((Throwable)e);
            }
        }

        /*
         * Exception decompiling
         */
        @NotNull
        private static ScriptedLoaderFileConfig read(@NotNull VirtualFile file) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static void writeNullableBool(AttributeOutputStream stream, Boolean b) throws IOException {
            stream.writeByte(b == null ? -1 : (b != false ? 1 : 0));
        }

        private static Boolean readNullableBool(AttributeInputStream stream) throws IOException {
            byte b = stream.readByte();
            return b == -1 ? null : Boolean.valueOf(b == 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/ScriptedGridDataHookUp$ScriptedLoaderFileConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/ScriptedGridDataHookUp$ScriptedLoaderFileConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "modify";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    public static class Context
    implements GridDataRequest.Context {
    }
}

