/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColumnHierarchyUtil {
    @NotNull
    public static <Column> List<List<Column>> getPathsToLeafColumns(@NotNull JBTreeTraverser<Column> traverser) {
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(0);
        }
        ArrayList paths = new ArrayList();
        ColumnHierarchyUtil.traverseAndProcess(traverser, (stack, node) -> {
            if (traverser.children(node).isEmpty()) {
                paths.add(new ArrayList(stack));
            }
        });
        ArrayList arrayList = paths;
        if (arrayList == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static <Column> void traverseAndProcess(@NotNull JBTreeTraverser<Column> traverser, @NotNull BiConsumer<List<Column>, Column> nodeProcessor) {
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(2);
        }
        if (nodeProcessor == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(3);
        }
        ArrayList stack = new ArrayList();
        try {
            for (Object node : traverser.preOrderDfsTraversal()) {
                while (!stack.isEmpty() && !traverser.children(stack.get(stack.size() - 1)).contains(node)) {
                    stack.remove(stack.size() - 1);
                }
                stack.add(node);
                nodeProcessor.accept(stack, node);
            }
        }
        catch (BreakException breakException) {
            // empty catch block
        }
    }

    @NotNull
    public static <Column> List<Column> getPathToColumn(@NotNull JBTreeTraverser<Column> traverser, @NotNull Column targetColumn) {
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(4);
        }
        if (targetColumn == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(5);
        }
        ArrayList path = new ArrayList();
        ColumnHierarchyUtil.traverseAndProcess(traverser, (stack, node) -> {
            if (node.equals(targetColumn)) {
                path.addAll(stack);
                throw new BreakException();
            }
        });
        ArrayList arrayList = path;
        if (arrayList == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static <Column> int getMaxDepth(@NotNull JBTreeTraverser<Column> traverser) {
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(7);
        }
        int[] maxDepth = new int[]{0};
        ColumnHierarchyUtil.traverseAndProcess(traverser, (stack, node) -> {
            if (traverser.children(node).isEmpty()) {
                maxDepth[0] = Math.max(maxDepth[0], stack.size());
            }
        });
        return maxDepth[0];
    }

    @NotNull
    public static <Column> List<Column> getAllLeafNodesInSubtree(@NotNull JBTreeTraverser<Column> traverser, @NotNull Column node) {
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(8);
        }
        if (node == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(9);
        }
        List list = ((JBTreeTraverser)traverser.withRoot(node)).traverse(TreeTraversal.LEAVES_DFS).toList();
        if (list == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public static <Column> Column getAncestorAtDepth(@NotNull JBTreeTraverser<Column> traverser, @NotNull Column child, int depth) {
        List<Column> path;
        if (traverser == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(11);
        }
        if (child == null) {
            ColumnHierarchyUtil.$$$reportNull$$$0(12);
        }
        return depth >= (path = ColumnHierarchyUtil.getPathToColumn(traverser, child)).size() ? null : (Column)path.get(depth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/ColumnHierarchyUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetColumn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/ColumnHierarchyUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToLeafColumns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToColumn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLeafNodesInSubtree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToLeafColumns";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "traverseAndProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathToColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMaxDepth";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllLeafNodesInSubtree";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorAtDepth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 10 -> new IllegalStateException(string);
        };
    }

    private static class BreakException
    extends RuntimeException {
        private BreakException() {
        }
    }
}

