/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SystemDarkThemeDetectorLookAndFeel;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.ThemesMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.GeneralSettingsParserKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.JsonKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/GeneralSettingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "file", "Ljava/io/File;", "processAutodetectTheme", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "processThemeAndScheme", "Companion", "intellij.ide.startup.importSettings"})
public final class GeneralSettingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private static final String COLOR_THEME = "workbench.colorTheme";
    @NotNull
    private static final String AUTODETECT_THEME = "window.autoDetectColorScheme";
    @NotNull
    private static final String PREFERRED_DARK_THEME = "workbench.preferredDarkColorTheme";
    @NotNull
    private static final String PREFERRED_LIGHT_THEME = "workbench.preferredLightColorTheme";

    public GeneralSettingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            GeneralSettingsParserKt.access$getLogger$p().info("Processing a general settings file: " + file);
            JsonNode jsonNode = JsonKt.getVsCodeJsonMapper().readTree(file);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
            }
            ObjectNode root = objectNode;
            this.processThemeAndScheme(root);
            this.processAutodetectTheme(root);
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processThemeAndScheme(ObjectNode root) {
        try {
            JsonNode jsonNode = root.get(COLOR_THEME);
            String string = jsonNode != null ? jsonNode.textValue() : null;
            if (string == null) {
                return;
            }
            String theme2 = string;
            BundledLookAndFeel laf = ThemesMappings.INSTANCE.themeMap(theme2);
            this.settings.setLaf(laf);
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processAutodetectTheme(ObjectNode root) {
        BundledLookAndFeel laf;
        ILookAndFeel lightLaf = null;
        ILookAndFeel darkLaf = null;
        try {
            JsonNode jsonNode = root.get(PREFERRED_DARK_THEME);
            String string = jsonNode != null ? jsonNode.textValue() : null;
            if (string == null) {
                return;
            }
            String preferredDarkTheme = string;
            laf = ThemesMappings.INSTANCE.themeMap(preferredDarkTheme);
            darkLaf = laf;
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
        try {
            JsonNode jsonNode = root.get(PREFERRED_LIGHT_THEME);
            String string = jsonNode != null ? jsonNode.textValue() : null;
            if (string == null) {
                return;
            }
            String preferredLightTheme = string;
            laf = ThemesMappings.INSTANCE.themeMap(preferredLightTheme);
            lightLaf = laf;
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
        try {
            JsonNode jsonNode = root.get(AUTODETECT_THEME);
            if (jsonNode == null) {
                return;
            }
            boolean autodetectTheme = jsonNode.booleanValue();
            if (autodetectTheme) {
                ILookAndFeel iLookAndFeel;
                ILookAndFeel iLookAndFeel2 = darkLaf;
                if (iLookAndFeel2 == null) {
                    iLookAndFeel2 = KnownLafs.INSTANCE.getDarcula();
                }
                if ((iLookAndFeel = lightLaf) == null) {
                    iLookAndFeel = KnownLafs.INSTANCE.getLight();
                }
                this.settings.setLaf(new SystemDarkThemeDetectorLookAndFeel(iLookAndFeel2, iLookAndFeel));
            }
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/GeneralSettingsParser$Companion;", "", "()V", "AUTODETECT_THEME", "", "COLOR_THEME", "PREFERRED_DARK_THEME", "PREFERRED_LIGHT_THEME", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

