/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.GeneralSettingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.KeyBindingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.PluginParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StateDatabaseParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParser;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getProcessedSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "isInstanceRecentEnough", "", "willDetectAtLeastSomething", "Companion", "intellij.ide.startup.importSettings"})
public final class VSCodeSettingsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    private static final String homeDirectory = System.getProperty("user.home");
    @NotNull
    private static final String vsCodeHome = SystemInfo.isMac ? homeDirectory + "/Library/Application Support/Code" : (SystemInfo.isWindows ? WindowsEnvVariables.INSTANCE.getApplicationData() + "/Code" : homeDirectory + "/.config/Code");
    @NotNull
    private static final File storageFile = new File(vsCodeHome + "/storage.json");
    @NotNull
    private static final File keyBindingsFile = new File(vsCodeHome + "/User/keybindings.json");
    @NotNull
    private static final File generalSettingsFile = new File(vsCodeHome + "/User/settings.json");
    @NotNull
    private static final File pluginsDirectory = new File(homeDirectory + "/.vscode/extensions");
    @NotNull
    private static final File database = new File(vsCodeHome + "/User/globalStorage/state.vscdb");
    private static final Duration timeAfterLastModificationToConsiderTheInstanceRecent = Duration.ofHours(8760L);

    public VSCodeSettingsProcessor(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    public final boolean willDetectAtLeastSomething() {
        return generalSettingsFile.exists();
    }

    public final boolean isInstanceRecentEnough() {
        try {
            File fileToCheck = database;
            if (fileToCheck.exists()) {
                FileTime time = Files.getLastModifiedTime(fileToCheck.toPath(), new LinkOption[0]);
                return time.toInstant().compareTo(Instant.now().minus(timeAfterLastModificationToConsiderTheInstanceRecent)) > 0;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    public final Settings getProcessedSettings() {
        Settings settings = Companion.getDefaultSettings();
        if (keyBindingsFile.exists()) {
            new KeyBindingsParser(settings).process(keyBindingsFile);
        }
        if (pluginsDirectory.exists()) {
            new PluginParser(settings).process(pluginsDirectory);
        }
        if (storageFile.exists()) {
            new StorageParser(settings).process(storageFile);
        }
        if (generalSettingsFile.exists()) {
            new GeneralSettingsParser(settings).process(generalSettingsFile);
        }
        if (database.exists()) {
            new StateDatabaseParser(this.scope, settings).process(database);
        }
        return settings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0016\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor$Companion;", "", "()V", "database", "Ljava/io/File;", "getDatabase$intellij_ide_startup_importSettings", "()Ljava/io/File;", "generalSettingsFile", "getGeneralSettingsFile$intellij_ide_startup_importSettings", "homeDirectory", "", "kotlin.jvm.PlatformType", "keyBindingsFile", "getKeyBindingsFile$intellij_ide_startup_importSettings", "pluginsDirectory", "getPluginsDirectory$intellij_ide_startup_importSettings", "storageFile", "getStorageFile$intellij_ide_startup_importSettings", "timeAfterLastModificationToConsiderTheInstanceRecent", "Ljava/time/Duration;", "vsCodeHome", "getVsCodeHome$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "getDefaultSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVsCodeHome$intellij_ide_startup_importSettings() {
            return vsCodeHome;
        }

        @NotNull
        public final File getStorageFile$intellij_ide_startup_importSettings() {
            return storageFile;
        }

        @NotNull
        public final File getKeyBindingsFile$intellij_ide_startup_importSettings() {
            return keyBindingsFile;
        }

        @NotNull
        public final File getGeneralSettingsFile$intellij_ide_startup_importSettings() {
            return generalSettingsFile;
        }

        @NotNull
        public final File getPluginsDirectory$intellij_ide_startup_importSettings() {
            return pluginsDirectory;
        }

        @NotNull
        public final File getDatabase$intellij_ide_startup_importSettings() {
            return database;
        }

        @NotNull
        public final Settings getDefaultSettings() {
            return new Settings(null, KnownLafs.INSTANCE.getDarcula(), KnownColorSchemes.INSTANCE.getDarcula(), SystemInfoRt.isMac ? KnownKeymaps.INSTANCE.getVSCodeMac() : KnownKeymaps.INSTANCE.getVSCode(), null, 17, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

