/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataSuitesManager;
import com.intellij.coverage.CoverageDataSuitesManagerKt;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\b\b\u0001\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\b\u0010\u001f\u001a\u00020\u0002H\u0016J\u0011\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0002H\u0016J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\b\u0010&\u001a\u00020\u0017H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a(\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n \f*\u0012\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "suites", "", "Lcom/intellij/coverage/CoverageSuite;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "addExternalCoverageSuite", "fileName", "", "runner", "Lcom/intellij/coverage/CoverageRunner;", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timestamp", "", "addSuite", "", "suite", "suiteToMergeWith", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "createCoverageSuite", "name", "deleteSuite", "getState", "getSuites", "", "()[Lcom/intellij/coverage/CoverageSuite;", "loadState", "element", "removeSuite", "setUpEngineEPRemovedCallback", "setUpRunnerEPRemovedCallback", "Companion", "intellij.platform.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1#2:142\n37#3,2:143\n766#4:145\n857#4,2:146\n766#4:148\n857#4,2:149\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n*L\n71#1:143,2\n78#1:145\n78#1:146,2\n119#1:148\n119#1:149,2\n*E\n"})
public final class CoverageDataSuitesManager
implements PersistentStateComponent<Element>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<CoverageSuite> suites;

    public CoverageDataSuitesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.suites = set;
        this.setUpRunnerEPRemovedCallback();
        this.setUpEngineEPRemovedCallback();
    }

    public final void addSuite(@NotNull CoverageSuite suite2, @Nullable String suiteToMergeWith) {
        Intrinsics.checkNotNullParameter((Object)suite2, (String)"suite");
        if (suiteToMergeWith == null || !Intrinsics.areEqual((Object)suite2.getPresentableName(), (Object)suiteToMergeWith)) {
            this.deleteSuite(suite2);
        }
        this.suites.remove(suite2);
        this.suites.add(suite2);
    }

    @Nullable
    public final CoverageSuite addExternalCoverageSuite(@NotNull String fileName, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        CoverageSuite coverageSuite;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        CoverageSuite coverageSuite2 = this.createCoverageSuite(fileName, runner, fileProvider, timestamp);
        if (coverageSuite2 != null) {
            CoverageSuite coverageSuite3;
            CoverageSuite it = coverageSuite3 = coverageSuite2;
            boolean bl = false;
            this.suites.add(it);
            coverageSuite = coverageSuite3;
        } else {
            coverageSuite = null;
        }
        return coverageSuite;
    }

    @Nullable
    public final CoverageSuite addSuite(@NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoverageSuite suite2 = this.createCoverageSuite(config);
        if (suite2 != null) {
            this.deleteSuite(suite2);
            this.suites.add(suite2);
        }
        return suite2;
    }

    public final void deleteSuite(@NotNull CoverageSuite suite2) {
        Intrinsics.checkNotNullParameter((Object)suite2, (String)"suite");
        suite2.deleteCachedCoverageData();
        this.removeSuite(suite2);
    }

    public final void removeSuite(@NotNull CoverageSuite suite2) {
        Intrinsics.checkNotNullParameter((Object)suite2, (String)"suite");
        this.suites.remove(suite2);
    }

    @NotNull
    public final CoverageSuite[] getSuites() {
        Collection $this$toTypedArray$iv = this.suites;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CoverageSuite[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CoverageSuite createCoverageSuite(@NotNull String name, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        Object object;
        Iterable iterable;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
            Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
            iterable = CoverageEngine.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CoverageEngine p0 = (CoverageEngine)element$iv$iv;
                boolean bl = false;
                if (!runner.acceptsCoverageEngine(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                if ((it = ((CoverageEngine)it).createCoverageSuite(name, this.project, runner, fileProvider, timestamp)) == null) continue;
                object = it;
                break block3;
            }
            object = null;
        }
        Iterable it = iterable = object;
        boolean bl = false;
        if (it == null) {
            CoverageDataSuitesManagerKt.access$getLOG$p().error("Cannot create coverage suite for runner: " + runner.getPresentableName());
        }
        return iterable;
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (Element suiteElement : element.getChildren("SUITE")) {
            CoverageSuite coverageSuite;
            block5: {
                CoverageRunner coverageRunner;
                if (BaseCoverageSuite.readRunnerAttribute(suiteElement) == null) continue;
                for (CoverageEngine it : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CoverageEngine.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<CoverageEngine, Boolean>(coverageRunner){
                    final /* synthetic */ CoverageRunner $coverageRunner;
                    {
                        this.$coverageRunner = $coverageRunner;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(CoverageEngine it) {
                        return this.$coverageRunner.acceptsCoverageEngine(it);
                    }
                }))) {
                    boolean bl = false;
                    CoverageSuite coverageSuite2 = it.createEmptyCoverageSuite(coverageRunner);
                    if (coverageSuite2 == null) continue;
                    coverageSuite = coverageSuite2;
                    break block5;
                }
                coverageSuite = null;
            }
            if (coverageSuite == null) continue;
            CoverageSuite coverageSuite3 = coverageSuite;
            CoverageSuite suite2 = coverageSuite3;
            if (suite2 instanceof BaseCoverageSuite) {
                ((BaseCoverageSuite)suite2).setProject(this.project);
            }
            try {
                suite2.readExternal(suiteElement);
                this.suites.add(suite2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (CoverageSuite coverageSuite : this.suites) {
            Element suiteElement = new Element("SUITE");
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private final CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config) {
        Object object;
        Object object2;
        block2: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CoverageEngine.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CoverageEngine it = (CoverageEngine)element$iv$iv;
                boolean bl = false;
                if (!it.isApplicableTo(config.getConfiguration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                if ((it = ((CoverageEngine)it).createCoverageSuite(config)) == null) continue;
                object2 = it;
                break block2;
            }
            object2 = null;
        }
        Object it = object = object2;
        boolean bl = false;
        CoverageDataSuitesManagerKt.access$getLOG$p().assertTrue(it != null, (Object)("Cannot create coverage suite for run config: " + config.getClass().getName()));
        return object;
    }

    private final void setUpRunnerEPRemovedCallback() {
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(@NotNull CoverageRunner extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                CoverageDataSuitesManager.access$getSuites$p(this.this$0).removeIf(arg_0 -> setUpRunnerEPRemovedCallback.1.extensionRemoved$lambda$0((Function1)new Function1<CoverageSuite, Boolean>(extension){
                    final /* synthetic */ CoverageRunner $extension;
                    {
                        this.$extension = $extension;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull CoverageSuite suite2) {
                        Intrinsics.checkNotNullParameter((Object)suite2, (String)"suite");
                        return suite2.getRunner() == this.$extension;
                    }
                }, arg_0));
            }

            private static final boolean extensionRemoved$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, (Disposable)this);
    }

    private final void setUpEngineEPRemovedCallback() {
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(@NotNull CoverageEngine extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                CoverageDataSuitesManager.access$getSuites$p(this.this$0).removeIf(arg_0 -> setUpEngineEPRemovedCallback.1.extensionRemoved$lambda$0((Function1)new Function1<CoverageSuite, Boolean>(extension){
                    final /* synthetic */ CoverageEngine $extension;
                    {
                        this.$extension = $extension;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull CoverageSuite suite2) {
                        Intrinsics.checkNotNullParameter((Object)suite2, (String)"suite");
                        return suite2.getCoverageEngine() == this.$extension;
                    }
                }, arg_0));
            }

            private static final boolean extensionRemoved$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, (Disposable)this);
    }

    @JvmStatic
    @NotNull
    public static final CoverageDataSuitesManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Set access$getSuites$p(CoverageDataSuitesManager $this) {
        return $this.suites;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/coverage/CoverageDataSuitesManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n31#2,2:142\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n*L\n34#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CoverageDataSuitesManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CoverageDataSuitesManager> serviceClass$iv = CoverageDataSuitesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CoverageDataSuitesManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

