/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config.mappings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.WarningIconCellRenderer;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.mappings.MappingsConfigurableTabProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingsConfigurableForm {
    private JPanel myContentPane;
    private TableView<DeploymentPathMapping> myPathsTable;
    private JLabel myMessageLabel;
    private HyperlinkLabel myFixLink;
    private JLabel myLegendLabel;
    private JPanel myComplexViewPanel;
    private JPanel mySimpleViewPanel;
    private JTextField myWebPathField;
    private TextFieldWithBrowseButton myLocalPathField;
    private TextFieldWithBrowseButton myDeployPathField;
    private JLabel myDeployPathLabel;
    private JButton myAddAnotherMappingButton;
    private JPanel myTablePanel;
    private List<DeploymentPathMapping> myPathMappings;
    private final Project myProject;
    private final Map<DeploymentPathMapping, @Nls String> myWarnings;
    @Nullable
    private Runnable myFixRunnable;
    private final DeploymentConfigurableTabProvider.ServerStateProvider myServerStateProvider;
    private final UserDataHolder mySharedData;

    @NotNull
    private static Comparator<DeploymentPathMapping> createComparator(ColumnInfo<DeploymentPathMapping, String> column) {
        Comparator comparator = (o1, o2) -> StringUtil.compare((String)((String)column.valueOf(o1)), (String)((String)column.valueOf(o2)), (boolean)false);
        if (comparator == null) {
            MappingsConfigurableForm.$$$reportNull$$$0(0);
        }
        return comparator;
    }

    private void createUIComponents() {
        this.myPathsTable = new ChangesTrackingTableView<DeploymentPathMapping>(){

            protected void onCellValueChanged(int row, int column, Object value) {
                DeploymentPathMapping mapping = MappingsConfigurableForm.this.myPathMappings.get(row);
                DeploymentPathMapping override = mapping.clone();
                ColumnInfo columnInfo = ((ListTableModel)MappingsConfigurableForm.this.myPathsTable.getModel()).getColumnInfos()[column];
                ((SetterColumn)columnInfo).doSetValue(override, (String)value);
                MappingsConfigurableForm.this.updateMessage(mapping, override);
            }

            protected void onEditingStopped() {
                MappingsConfigurableForm.this.updateMessage(null, null);
            }
        };
        this.myPathsTable.setShowGrid(false);
        this.myPathsTable.setRowHeight(Math.max(UIUtil.getBalloonWarningIcon().getIconHeight() + 2, new JTextField().getPreferredSize().height));
        this.myTablePanel = ToolbarDecorator.createDecorator(this.myPathsTable).setAddAction(button -> this.addMapping()).setRemoveAction(button -> {
            this.myPathsTable.stopEditing();
            int minSelectedIndex = this.myPathsTable.getSelectionModel().getMinSelectionIndex();
            if (minSelectedIndex == -1) {
                return;
            }
            int[] selectedIndices = this.myPathsTable.getSelectedRows();
            NavigableSet<Integer> modelIndices = new TreeSet();
            for (int selectedIndex : selectedIndices) {
                int modelIndex = this.myPathsTable.convertRowIndexToModel(selectedIndex);
                modelIndices.add(modelIndex);
            }
            modelIndices = modelIndices.descendingSet();
            ListTableModel model = this.myPathsTable.getListTableModel();
            for (Integer entry : modelIndices) {
                model.removeRow(entry.intValue());
            }
            this.updateUi();
            int index = Math.min(minSelectedIndex, this.myPathsTable.getRowCount() - 1);
            if (index != -1) {
                this.myPathsTable.setRowSelectionInterval(index, index);
            }
        }).disableUpDownActions().createPanel();
        this.myLegendLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
    }

    public MappingsConfigurableForm(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, UserDataHolder sharedData) {
        this.$$$setupUI$$$();
        this.myWarnings = new HashMap<DeploymentPathMapping, String>();
        this.myProject = project;
        this.myServerStateProvider = serverStateProvider;
        this.mySharedData = sharedData;
        project.getMessageBus().connect().subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (MappingsConfigurableForm.this.myPathMappings == null) {
                    return;
                }
                MappingsConfigurableForm.this.updateMessage(null, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$2", "rootsChanged"));
            }
        });
        this.myFixLink.setHyperlinkText(WDBundle.message("fix", new Object[0]));
        this.myFixLink.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.myFixRunnable != null) {
                this.myFixRunnable.run();
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myLocalPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                MappingsConfigurableForm.this.myPathMappings.get(0).setLocalPath(MappingsConfigurableForm.this.myLocalPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$3", "textChanged"));
            }
        });
        this.myDeployPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                MappingsConfigurableForm.this.myPathMappings.get(0).setDeployPath(MappingsConfigurableForm.this.myDeployPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$4", "textChanged"));
            }
        });
        this.myWebPathField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                MappingsConfigurableForm.this.myPathMappings.get(0).setWebPath(MappingsConfigurableForm.this.myWebPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$5", "textChanged"));
            }
        });
        this.myAddAnotherMappingButton.addActionListener(e -> this.addMapping());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocalPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(null, "", (ComponentWithBrowseButton)this.myLocalPathField, this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myDeployPathField.addActionListener(e -> MappingsConfigurableForm.chooseRemotePath(this.myDeployPathField.getTextField(), true, WDBundle.message("choose.deployment.path", new Object[0]), this.myServerStateProvider, this.myProject, this.myContentPane));
    }

    private void addMapping() {
        this.myPathMappings.add(new DeploymentPathMapping());
        if (this.myPathMappings.size() == 1) {
            this.myPathMappings.add(new DeploymentPathMapping());
        }
        this.updateUi();
        if (this.myPathMappings.size() >= 2) {
            int row = this.myPathMappings.size() - 1;
            this.myPathsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myPathsTable.scrollRectToVisible(this.myPathsTable.getCellRect(row, 0, true));
            if (StringUtil.isEmpty((String)this.myPathMappings.get(0).getLocalPath())) {
                this.myPathsTable.editCellAt(0, 1);
            } else {
                this.myPathsTable.editCellAt(row, 1);
            }
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myPathsTable.getEditorComponent(), true);
        }
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getDescription(@Nullable SettingsDeployable server) {
        String text = WDBundle.message("mappings.local.path.is.absolute", new Object[0]) + " ";
        if (server == null) {
            text = text + WDBundle.message("mappings.description.no.server", new Object[0]) + " ";
        } else {
            if (server.needsTransfer()) {
                String rootPath = server.getAccessType().isProtocolBased() ? MappingsConfigurableForm.getPresentableText(server.getRootFolder()) : MappingsConfigurableForm.getPresentableText(server.getMountedFolder());
                text = text + WDBundle.message("mappings.description.deployment.path", rootPath);
            }
            String url = MappingsConfigurableForm.getPresentableText(server.getUrl());
            String urlPart = WDBundle.message("mappings.description.web.path", url);
            text = text + urlPart;
        }
        String string = text;
        if (string == null) {
            MappingsConfigurableForm.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String getPresentableText(String text) {
        return StringUtil.isEmptyOrSpaces((String)text) ? WDBundle.message("mappings.not.provided", new Object[0]) : text;
    }

    private void updateUi() {
        SettingsDeployable server = (SettingsDeployable)this.myServerStateProvider.compute();
        if (this.myPathMappings.size() < 2) {
            this.mySimpleViewPanel.setVisible(true);
            this.myComplexViewPanel.setVisible(false);
            boolean hasDeployPath = server != null && server.needsTransfer();
            this.myDeployPathLabel.setVisible(hasDeployPath);
            this.myDeployPathField.setVisible(hasDeployPath);
            this.myLocalPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getLocalPath());
            this.myDeployPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getDeployPath());
            this.myWebPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getWebPath());
            this.myAddAnotherMappingButton.setVisible(true);
        } else {
            if (this.myPathsTable.isEditing()) {
                this.myPathsTable.stopEditing();
            }
            this.mySimpleViewPanel.setVisible(false);
            this.myComplexViewPanel.setVisible(true);
            ColumnInfo[] columns = server != null && !server.needsTransfer() ? new ColumnInfo[]{new IconColumn(), new LocalPathColumn(), new WebPathColumn()} : new ColumnInfo[]{new IconColumn(), new LocalPathColumn(), new DeployPathColumn(), new WebPathColumn()};
            this.myPathsTable.setModelAndUpdateColumns(new ListTableModel(columns, this.myPathMappings, -1));
            this.myAddAnotherMappingButton.setVisible(false);
        }
        this.updateMessage(null, null);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public boolean isModified() {
        List<DeploymentPathMapping> configMappings;
        if (this.myPathsTable.getCellEditor() != null) {
            DeploymentPathMapping original = this.myPathMappings.get(this.myPathsTable.getEditingRow());
            DeploymentPathMapping override = original.clone();
            ColumnInfo columnInfo = ((ListTableModel)this.myPathsTable.getModel()).getColumnInfos()[this.myPathsTable.getEditingColumn()];
            if (columnInfo instanceof SetterColumn) {
                ((SetterColumn)columnInfo).doSetValue(override, (String)this.myPathsTable.getCellEditor().getCellEditorValue());
                if (!original.equals(override)) {
                    return true;
                }
            }
        }
        if ((configMappings = MappingsConfigurableTabProvider.getMappings(this.mySharedData, this.myServerStateProvider.getServerId())).size() != this.myPathMappings.size()) {
            return true;
        }
        for (int i = 0; i < this.myPathMappings.size(); ++i) {
            if (this.myPathMappings.get(i).equals(configMappings.get(i))) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.applyTo(this.myServerStateProvider.getServerId());
    }

    public void applyTo(SettingsDeployable server) {
        this.applyTo(server.getId());
    }

    public void applyTo(String serverId) {
        this.myPathsTable.stopEditing();
        MappingsConfigurableTabProvider.putMappings(serverId, PublishConfig.cloneMappings(this.myPathMappings, false), this.mySharedData);
    }

    public void reset() {
        this.myPathsTable.stopEditing();
        List<DeploymentPathMapping> mappings = MappingsConfigurableTabProvider.getMappings(this.mySharedData, this.myServerStateProvider.getServerId());
        this.myPathMappings = PublishConfig.cloneMappings(mappings, false);
        this.updateUi();
        this.updateLegend((SettingsDeployable)this.myServerStateProvider.compute());
    }

    private void updateLegend(@Nullable SettingsDeployable server) {
        this.myLegendLabel.setText(MappingsConfigurableForm.getDescription(server));
    }

    private void updateMessage(@Nullable DeploymentPathMapping mapping, @Nullable DeploymentPathMapping override) {
        Pair<@Nls(capitalization=Nls.Capitalization.Sentence) String, Runnable> messageAndFix = this.validate(mapping, override);
        if (messageAndFix != null) {
            this.myMessageLabel.setText((String)messageAndFix.first);
            this.myMessageLabel.setVisible(true);
            this.myFixRunnable = (Runnable)messageAndFix.second;
            this.myFixLink.setVisible(this.myFixRunnable != null);
        } else {
            this.myMessageLabel.setVisible(false);
            this.myFixLink.setVisible(false);
            this.myFixRunnable = null;
        }
        this.myPathsTable.repaint();
    }

    private @Nullable Pair<@Nls(capitalization=Nls.Capitalization.Sentence) String, Runnable> validate(@Nullable DeploymentPathMapping original, @Nullable DeploymentPathMapping override) {
        if (this.myPathMappings == null || this.myProject.isDisposed()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        HashSet<String> unmappedContentRoots = new HashSet<String>();
        for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            unmappedContentRoots.add(contentRoot.getPresentableUrl());
        }
        SettingsDeployable server = (SettingsDeployable)this.myServerStateProvider.compute();
        HashMap<String, DeploymentPathMapping> existing = new HashMap<String, DeploymentPathMapping>();
        String mappingsMessage = null;
        List<DeploymentPathMapping> mappingsToValidate = this.myPathMappings.isEmpty() ? Collections.singletonList(new DeploymentPathMapping()) : this.myPathMappings;
        for (DeploymentPathMapping pathMapping : mappingsToValidate) {
            DeploymentPathMapping existingMapping;
            DeploymentPathMapping effective = pathMapping == original ? override : pathMapping;
            String s = MappingsConfigurableForm.validate(server, effective, index, unmappedContentRoots, mappingsToValidate.size() == 1);
            this.myWarnings.put(pathMapping, s);
            if (mappingsMessage == null) {
                mappingsMessage = s;
            }
            if (!StringUtil.isNotEmpty((String)effective.getLocalPath())) continue;
            String localPath = effective.getPresentableLocalPath();
            if (!SystemInfo.isFileSystemCaseSensitive) {
                localPath = StringUtil.toLowerCase((String)localPath);
            }
            if ((existingMapping = existing.put(localPath, pathMapping)) == null) continue;
            if (this.myWarnings.get(existingMapping) == null) {
                this.myWarnings.put(existingMapping, WDBundle.message("duplicate.local.path", new Object[0]));
            }
            if (this.myWarnings.get(pathMapping) != null) continue;
            this.myWarnings.put(pathMapping, WDBundle.message("duplicate.local.path", new Object[0]));
        }
        if (mappingsMessage != null) {
            return Pair.create(mappingsMessage, null);
        }
        if (!unmappedContentRoots.isEmpty()) {
            Runnable fix = () -> {
                if (this.myPathsTable.isEditing()) {
                    this.myPathsTable.stopEditing();
                }
                ArrayList<DeploymentPathMapping> missingMappings = new ArrayList<DeploymentPathMapping>(unmappedContentRoots.size());
                for (String contentRoot : unmappedContentRoots) {
                    DeploymentPathMapping mapping = new DeploymentPathMapping();
                    mapping.setLocalPath(contentRoot);
                    missingMappings.add(mapping);
                }
                this.myPathMappings.addAll(missingMappings);
                this.updateUi();
            };
            String message = unmappedContentRoots.size() == 1 ? WDBundle.message("content.root.is.not.mapped", unmappedContentRoots.iterator().next()) : WDBundle.message("content.roots.are.not.mapped", new Object[0]);
            return Pair.create((Object)message, (Object)fix);
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    private static String validate(SettingsDeployable server, DeploymentPathMapping pathMapping, @NotNull ProjectFileIndex index, @Nullable Set<String> unmappedContentRoots, boolean single) {
        VirtualFile contentRoot;
        if (index == null) {
            MappingsConfigurableForm.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)pathMapping.getLocalPath())) {
            return WDBundle.message("local.path.is.empty", new Object[0]);
        }
        if (PublishUtils.needsTransfer(server.getAccessType())) {
            if (StringUtil.isEmpty((String)pathMapping.getDeployPath())) {
                if (single) {
                    return WDBundle.message("deploy.path.is.empty", new Object[0]);
                }
                return WDBundle.message("deploy.path.is.empty.for", pathMapping.getPresentableLocalPath());
            }
            String s = DeploymentPathMapping.validateDeployPath(pathMapping.getDeployPath(), server.getAccessType().isProtocolBased());
            if (s != null) {
                return s;
            }
        }
        if (!StringUtil.isEmpty((String)server.getUrl()) && StringUtil.isEmpty((String)pathMapping.getWebPath())) {
            if (single) {
                return WDBundle.message("web.path.is.empty", new Object[0]);
            }
            return WDBundle.message("web.path.is.empty.for", pathMapping.getPresentableLocalPath());
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathMapping.getPresentableLocalPath());
        if (file == null) {
            return WDBundle.message("local.item.not.found", pathMapping.getPresentableLocalPath());
        }
        try {
            contentRoot = (VirtualFile)ApplicationManager.getApplication().executeOnPooledThread(() -> (VirtualFile)ReadAction.compute(() -> index.getContentRootForFile(file))).get(300L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        if (contentRoot == null) {
            return WDBundle.message("item.is.out.of.project", pathMapping.getPresentableLocalPath());
        }
        if (unmappedContentRoots != null) {
            unmappedContentRoots.remove(contentRoot.getPresentableUrl());
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myPathMappings.size() > 1) {
            return this.myPathsTable;
        }
        if (StringUtil.isEmpty((String)this.myLocalPathField.getText())) {
            return this.myLocalPathField.getTextField();
        }
        if (StringUtil.isEmpty((String)this.myDeployPathField.getText())) {
            return this.myDeployPathField.getTextField();
        }
        if (StringUtil.isEmpty((String)this.myWebPathField.getText())) {
            return this.myWebPathField;
        }
        return this.myLocalPathField.getTextField();
    }

    public static void chooseRemotePath(JTextField textField, boolean foldersOnly, @NlsContexts.DialogTitle String title, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, Project project, JPanel contentPane) {
        SettingsDeployable server = (SettingsDeployable)serverStateProvider.compute();
        String error = server.validateFast();
        if (error != null) {
            Messages.showErrorDialog((Component)contentPane, (String)WDBundle.message("server.invalid", serverStateProvider.getServerName(), error));
            return;
        }
        if (!AuthHelper.ensureAuthSpecified(project, server, false, ConnectionOwnerFactory.createConnectionOwner((Component)contentPane))) {
            return;
        }
        if (server.getAccessType().isProtocolBased()) {
            WebServerConfig.RemotePath path;
            WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(textField.getText());
            ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)server, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
            d.show();
            serverStateProvider.updateAuth(server);
            if (d.isOK() && (path = d.getPath()) != null) {
                textField.setText(path.path);
            }
        } else {
            VirtualFile file;
            final Ref mountedRoot = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> mountedRoot.set((Object)LocalFileSystem.getInstance().findFileByPath(server.getMountedFolder())), WDBundle.message("resolving.mounted.root", new Object[0]), false, project);
            if (mountedRoot.isNull() || !((VirtualFile)mountedRoot.get()).isValid()) {
                Messages.showErrorDialog((Component)contentPane, (String)WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)server.getMountedFolder())));
                return;
            }
            FileChooserDescriptor d = new FileChooserDescriptor(false, true, false, true, false, false){

                public boolean isFileSelectable(@Nullable VirtualFile file) {
                    return file != null && VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)mountedRoot.get()), (VirtualFile)file, (boolean)false);
                }
            };
            d.setTitle(title);
            String relativePath = textField.getText();
            VirtualFile initialFile = VirtualFileManager.getInstance().findFileByUrl(((VirtualFile)mountedRoot.get()).getUrl() + "/" + relativePath);
            if (initialFile == null) {
                initialFile = (VirtualFile)mountedRoot.get();
            }
            if ((file = FileChooser.chooseFile((FileChooserDescriptor)d, (Component)textField, (Project)project, (VirtualFile)initialFile)) != null) {
                if (!d.isFileSelectable(file)) {
                    Messages.showWarningDialog((Project)project, (String)WDBundle.message("deployment.path.0.is.out.of.root.folder.1", file.getPath(), ((VirtualFile)mountedRoot.get()).getPath()), (String)WDBundle.message("deploy.path.column.name", new Object[0]));
                    return;
                }
                String newRelativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)((VirtualFile)mountedRoot.get()), (char)File.separatorChar);
                if (StringUtil.isEmpty((String)newRelativePath)) {
                    newRelativePath = File.separator;
                }
                textField.setText(newRelativePath);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myComplexViewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel4 = this.myTablePanel;
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(-1, 100), null));
        this.mySimpleViewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 8, 0, 8), 0, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeployPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", MappingsConfigurableForm.class).getString("mappings.deployment.path"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WDBundle", MappingsConfigurableForm.class).getString("mappings.web.path"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WDBundle", MappingsConfigurableForm.class).getString("mappings.local.path"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        this.myDeployPathField = noPathCompletion;
        jPanel.add((Component)noPathCompletion, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myWebPathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(5, 8, 5, 8), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel5 = this.myLegendLabel;
        jLabel5.setText("-----");
        jPanel5.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("---");
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFixLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel6.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myAddAnotherMappingButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/WDBundle", MappingsConfigurableForm.class).getString("mappings.add.new.mapping"));
        jPanel5.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private final class IconColumn
    extends ColumnInfo<DeploymentPathMapping, Object> {
        private IconColumn() {
            super(" ");
        }

        public String valueOf(DeploymentPathMapping item) {
            return null;
        }

        public int getWidth(JTable table) {
            return UIUtil.getBalloonWarningIcon().getIconWidth() + 2;
        }

        public TableCellRenderer getRenderer(DeploymentPathMapping pathMapping) {
            return new WarningIconCellRenderer((NullableComputable<String>)((NullableComputable)() -> MappingsConfigurableForm.this.myWarnings.get(pathMapping)));
        }
    }

    private final class LocalPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        private LocalPathColumn() {
            super(WDBundle.message("local.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator(this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getLocalPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setLocalPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new LocalPathCellEditor(WDBundle.message("mappings.choose.local.path.title", new Object[0]), MappingsConfigurableForm.this.myProject);
        }

        @NotNull
        public Comparator<DeploymentPathMapping> getComparator() {
            Comparator<DeploymentPathMapping> comparator = this.COMPARATOR;
            if (comparator == null) {
                LocalPathColumn.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$LocalPathColumn", "getComparator"));
        }
    }

    private final class WebPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        private WebPathColumn() {
            super(WDBundle.message("web.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator(this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getWebPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setWebPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new AbstractTableCellEditor(){
                JTextField myComponent;

                public Object getCellEditorValue() {
                    return this.myComponent.getText();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myComponent = new JTextField();
                    this.myComponent.setText((String)value);
                    return this.myComponent;
                }
            };
        }

        @Nullable
        public Comparator<DeploymentPathMapping> getComparator() {
            return this.COMPARATOR;
        }
    }

    private final class DeployPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        private DeployPathColumn() {
            super(WDBundle.message("deploy.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator(this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getDeployPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setDeployPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new LocalPathCellEditor(MappingsConfigurableForm.this.myProject){

                protected ActionListener createActionListener(JTable table) {
                    return e -> MappingsConfigurableForm.chooseRemotePath((JTextField)this.myComponent.getChildComponent(), true, WDBundle.message("choose.deployment.path", new Object[0]), MappingsConfigurableForm.this.myServerStateProvider, MappingsConfigurableForm.this.myProject, MappingsConfigurableForm.this.myContentPane);
                }
            };
        }

        @NotNull
        public Comparator<DeploymentPathMapping> getComparator() {
            Comparator<DeploymentPathMapping> comparator = this.COMPARATOR;
            if (comparator == null) {
                DeployPathColumn.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm$DeployPathColumn", "getComparator"));
        }
    }

    private static interface SetterColumn {
        public void doSetValue(DeploymentPathMapping var1, String var2);
    }
}

