/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.notification;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesRefreshService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesUploadingService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoteEditEditorDecorator
extends EditorNotificationPanel {
    private static final Logger LOG = Logger.getInstance(RemoteEditEditorDecorator.class);
    private static final Key<RemoteEditEditorDecorator> PANEL_KEY = Key.create((String)"remoteFilesEditPanel");
    private final List<ActionButton> myActions;
    private boolean myChanged;

    public static void updateDecorators(@NotNull RemoteVirtualFile file) {
        Project[] projects;
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(0);
        }
        boolean changed = file.isChanged();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            RemoteEditEditorDecorator.updateDecorators(file, FileEditorManager.getInstance((Project)project), changed);
        }
    }

    public static void updateDecorators(@NotNull FileEditorManager manager, @NotNull RemoteVirtualFile file) {
        if (manager == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(2);
        }
        boolean changed = file.isChanged();
        RemoteEditEditorDecorator.updateDecorators(file, manager, changed);
    }

    private static void updateDecorators(@NotNull RemoteVirtualFile file, @NotNull FileEditorManager manager, boolean changed) {
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(4);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!manager.getProject().isDisposed()) {
                for (FileEditor editor : manager.getAllEditors((VirtualFile)file)) {
                    RemoteEditEditorDecorator.updateDecorator(file, manager, editor, changed);
                }
            }
        });
    }

    private static void updateDecorator(@NotNull RemoteVirtualFile file, @NotNull FileEditorManager manager, @NotNull FileEditor editor, boolean changed) {
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(7);
        }
        RemoteEditEditorDecorator decorator = RemoteEditEditorDecorator.getOrCreatePanelForTheEditor(manager, editor, file);
        decorator.update(changed);
    }

    private static RemoteEditEditorDecorator getOrCreatePanelForTheEditor(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull RemoteVirtualFile file) {
        RemoteEditEditorDecorator old;
        if (manager == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(9);
        }
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(10);
        }
        if ((old = (RemoteEditEditorDecorator)((Object)editor.getUserData(PANEL_KEY))) != null) {
            return old;
        }
        RemoteEditEditorDecorator.tryToListenToEditorUpdates(editor);
        RemoteEditEditorDecorator newPanel = new RemoteEditEditorDecorator(file, editor);
        manager.addTopComponent(editor, (JComponent)((Object)newPanel));
        editor.putUserData(PANEL_KEY, (Object)newPanel);
        return newPanel;
    }

    private static void tryToListenToEditorUpdates(FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new UpdateNotificationsDocumentAdapter());
    }

    public RemoteEditEditorDecorator(@NotNull RemoteVirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(11);
        }
        if (fileEditor == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(12);
        }
        super(fileEditor, EditorNotificationPanel.getToolbarBackground(), null, EditorNotificationPanel.Status.Info);
        this.myActions = new ArrayList<ActionButton>();
        this.initializeActions(file, fileEditor instanceof TextEditor);
        this.myChanged = true;
        this.update(false);
    }

    private void initializeActions(@NotNull RemoteVirtualFile file, boolean isTextFile) {
        if (file == null) {
            RemoteEditEditorDecorator.$$$reportNull$$$0(13);
        }
        RefreshAction refreshAction = new RefreshAction(file);
        this.myActions.add(RemoteEditEditorDecorator.createButton((AnAction)refreshAction));
        DiffAction diffAction = new DiffAction(file);
        this.myActions.add(RemoteEditEditorDecorator.createButton((AnAction)diffAction));
        RevertAction revertAction = new RevertAction(file);
        ActionButton button = RemoteEditEditorDecorator.createButton((AnAction)revertAction);
        button.setEnabled(isTextFile);
        this.myActions.add(button);
        UploadAction uploadAction = new UploadAction(file);
        this.myActions.add(RemoteEditEditorDecorator.createButton((AnAction)uploadAction));
        this.myLinksPanel.setLayout(new FlowLayout());
        for (ActionButton action : this.myActions) {
            this.myLinksPanel.add((Component)action);
        }
    }

    private static ActionButton createButton(AnAction action) {
        Icon icon = action.getTemplatePresentation().getIcon();
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        ActionButton button = new ActionButton(action, null, "unknown", new Dimension(width, height));
        button.setIconInsets((Insets)JBUI.insets((int)0, (int)3));
        return button;
    }

    private void update(boolean changed) {
        if (this.myChanged == changed) {
            return;
        }
        this.setText(changed ? WDBundle.message("remote.edit.the.file.is.changed.upload", new Object[0]) : WDBundle.message("remote.edit.the.file.is.identical.to.remote.one", new Object[0]));
        this.myChanged = changed;
        for (ActionButton action : this.myActions) {
            if (!(action.getAction() instanceof RevertAction)) continue;
            action.setEnabled(changed);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDecorators";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDecorator";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreatePanelForTheEditor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UpdateNotificationsDocumentAdapter
    implements DocumentListener {
        private UpdateNotificationsDocumentAdapter() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile virtualFile;
            if (event == null) {
                UpdateNotificationsDocumentAdapter.$$$reportNull$$$0(0);
            }
            if (!((virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument())) instanceof RemoteVirtualFile)) {
                return;
            }
            RemoteEditEditorDecorator.updateDecorators((RemoteVirtualFile)virtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$UpdateNotificationsDocumentAdapter", "documentChanged"));
        }
    }

    private static final class RefreshAction
    extends DumbAwareAction {
        private final RemoteVirtualFile myFile;

        private RefreshAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            ActionUtil.copyFrom((AnAction)this, (String)"WD.RefreshCurrentRemoteFileAction");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            RemoteEditedFilesRefreshService.getInstance(project).queueRefresh(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DiffAction
    extends DumbAwareAction {
        private final RemoteVirtualFile myFile;

        private DiffAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                DiffAction.$$$reportNull$$$0(0);
            }
            super(WDBundle.message("remote.edit.diff.action.title", new Object[0]), WDBundle.message("remote.edit.diff.action.description", new Object[0]), AllIcons.Actions.Diff);
            this.myFile = file;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                DiffAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            try {
                DiffContent docContent = DiffContentFactory.getInstance().create(project, (VirtualFile)this.myFile);
                DiffContent savedContent = DiffContentFactory.getInstance().createFromBytes(project, this.myFile.getLastSyncedContent(), (VirtualFile)this.myFile);
                MutableDiffRequestChain diffData = new MutableDiffRequestChain(savedContent, docContent);
                diffData.setWindowTitle(this.myFile.getName());
                diffData.setTitle1(WDBundle.message("remote.edit.last.uploaded", new Object[0]));
                diffData.setTitle2(WDBundle.message("remote.edit.current.content", new Object[0]));
                DiffManager.getInstance().showDiff(project, (DiffRequestChain)diffData, DiffDialogHints.DEFAULT);
            }
            catch (IOException err) {
                LOG.error((Throwable)err);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$DiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RevertAction
    extends DumbAwareAction {
        private final RemoteVirtualFile myFile;

        private RevertAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                RevertAction.$$$reportNull$$$0(0);
            }
            super(WDBundle.messagePointer("remote.edit.revert.action.title", new Object[0]), WDBundle.messagePointer("remote.edit.revert.action.description", new Object[0]), AllIcons.Actions.Rollback);
            this.myFile = file;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                RevertAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.myFile);
            if (document == null) {
                return;
            }
            Runnable action = () -> {
                FileDocumentManager.getInstance().saveDocument(document);
                this.myFile.revert(document);
                FileDocumentManager.getInstance().saveDocument(document);
            };
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(action), WDBundle.message("remote.edit.revert.edited.remote.file", new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)document), document);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$RevertAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UploadAction
    extends DumbAwareAction {
        private final RemoteVirtualFile myFile;

        private UploadAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                UploadAction.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            ActionUtil.copyFrom((AnAction)this, (String)"WD.UploadCurrentRemoteFileAction");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                UploadAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            FileDocumentManager instance = FileDocumentManager.getInstance();
            Document document = instance.getDocument((VirtualFile)this.myFile);
            if (document != null) {
                instance.saveDocument(document);
            }
            RemoteEditedFilesUploadingService.getInstance(project).queueUpload(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$UploadAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

