/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WebServersAuthStorage
implements PersistentStateComponent<AuthState> {
    private static final Logger LOG = Logger.getInstance(WebServersAuthStorage.class);
    private static final AuthState EMPTY_STATE = new AuthState();
    @NonNls
    private static final String USERNAME = "username";
    @NonNls
    private static final String PASSWORD = "password";
    @NonNls
    private static final String PASSPHRASE = "passphrase";
    @NonNls
    private final transient PropertiesEncryptionSupport myEncryptionSupport = new PropertiesEncryptionSupport((Key)new SecretKeySpec(new byte[]{77, -93, -111, -34, -17, 87, 23, 91, 98, 77, -128, 42, -32, 26, 75, 46}, "AES"));
    @Nullable
    private AuthState myState;

    WebServersAuthStorage() {
    }

    void initServerAuthIfNeeded(@NotNull List<WebServerConfig> servers) {
        Properties properties;
        if (servers == null) {
            WebServersAuthStorage.$$$reportNull$$$0(0);
        }
        if ((properties = this.loadProperties(this.myState)) != null && !properties.isEmpty()) {
            WebDeploymentCredentialHelper.syncWithPasswordSafe(servers, new OldStorageCredentialProvider(){

                @Override
                @Nullable
                public String getUser(@NotNull WebServerConfig server) {
                    if (server == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return properties.getProperty(WebServersAuthStorage.getUsernameKey(server.getId()));
                }

                @Override
                @Nullable
                public String getPassword(@NotNull WebServerConfig server) {
                    if (server == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return properties.getProperty(WebServersAuthStorage.getPasswordKey(server.getId()));
                }

                @Override
                @Nullable
                public String getPassphrase(@NotNull WebServerConfig server) {
                    if (server == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return properties.getProperty(WebServersAuthStorage.getPassphraseKey(server.getId()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "server";
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getUser";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getPassword";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getPassphrase";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.myState = EMPTY_STATE;
    }

    @Nullable
    private Properties loadProperties(AuthState state) {
        if (state == null) {
            return null;
        }
        String text = state.getValue();
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        Properties properties = new Properties();
        byte[] encodedBytes = Base64.getDecoder().decode(text);
        try {
            byte[] decrypted = this.myEncryptionSupport.decrypt(encodedBytes);
            properties.load(new ByteArrayInputStream(decrypted));
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        return properties;
    }

    @NotNull
    private static String getUsernameKey(String id) {
        String string = "username." + id;
        if (string == null) {
            WebServersAuthStorage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getPasswordKey(String id) {
        String string = "password." + id;
        if (string == null) {
            WebServersAuthStorage.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getPassphraseKey(String id) {
        String string = "passphrase." + id;
        if (string == null) {
            WebServersAuthStorage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public AuthState getState() {
        return this.myState;
    }

    public void loadState(@NotNull AuthState state) {
        if (state == null) {
            WebServersAuthStorage.$$$reportNull$$$0(4);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsernameKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasswordKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassphraseKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initServerAuthIfNeeded";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class AuthState {
        String value;

        @Tag(value="data")
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @State(name="webServersAuthStorage", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="webServers.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="webServersAuth.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
    public static class AppInstance
    extends WebServersAuthStorage {
        public static WebServersAuthStorage getInstance() {
            return (WebServersAuthStorage)ApplicationManager.getApplication().getService(AppInstance.class);
        }
    }

    @State(name="webServersAuthStorage", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
    public static class ProjectInstance
    extends WebServersAuthStorage {
        public static WebServersAuthStorage getInstance(@NotNull Project project) {
            if (project == null) {
                ProjectInstance.$$$reportNull$$$0(0);
            }
            return (WebServersAuthStorage)project.getService(ProjectInstance.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$ProjectInstance", "getInstance"));
        }
    }
}

