/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.liveEdit.InSingleFileBasedSynchronizer;
import com.jetbrains.liveEdit.JavaScriptSynchronizer;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.update.ApplicationUpdater;
import com.jetbrains.liveEdit.update.ApplicationUpdaterKt;
import com.jetbrains.liveEdit.update.EffectiveFileScriptProcessor;
import com.jetbrains.liveEdit.update.FileScriptProcessor;
import com.jetbrains.liveEdit.update.RestartRequiredNotificationItem;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateResult;
import com.jetbrains.liveEdit.update.UpdateScriptResult;
import com.jetbrains.liveEdit.update.UpdateState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJD\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0017J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ@\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J \u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0015\u0010%\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b&J\u001c\u0010'\u001a\u00020\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013JC\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002\u00a2\u0006\u0002\u0010-R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater;", "", "()V", "processToState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/jetbrains/liveEdit/update/UpdateState;", "autoTriggeredUpdate", "Lorg/jetbrains/concurrency/Promise;", "result", "Lcom/jetbrains/liveEdit/update/EffectiveFileScriptProcessor;", "vm", "Lorg/jetbrains/debugger/Vm;", "synchronizer", "Lcom/jetbrains/liveEdit/InSingleFileBasedSynchronizer;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "setSourceExecutor", "Lcom/jetbrains/liveEdit/update/SetSourceExecutor;", "checkIsBlackListed", "", "notify", "clearUpdateState", "", "remove", "collectPendingFiles", "", "doUpdate", "Lcom/jetbrains/liveEdit/update/UpdateResult;", "getState", "markAsRestartRequired", "Lcom/jetbrains/liveEdit/update/RestartRequiredNotificationItem;", "notifyIfHasIncorrectFiles", "incorrectFiles", "restartOrNotify", "restartOrNotify$intellij_js_liveEdit", "schedule", "scheduleUpdateScripts", "updateScripts", "sources", "", "", "(Ljava/util/List;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;[Ljava/lang/CharSequence;)Lorg/jetbrains/concurrency/Promise;", "MyFileScriptProcessor", "intellij.js.liveEdit"})
public final class ApplicationUpdater {
    @NotNull
    private final ConcurrentHashMap<XDebugProcess, UpdateState> processToState = new ConcurrentHashMap();

    @NotNull
    public final Promise<UpdateResult> updateScripts(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (this.checkIsBlackListed((XDebugProcess)debugProcess, true)) {
            return Promises.rejectedPromise((String)"blacklisted");
        }
        Vm vm = debugProcess.getMainVm();
        if (vm == null) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        Vm vm2 = vm;
        Object object = PsiSynchronizer.EP_NAME.findExtension(JavaScriptSynchronizer.class);
        Intrinsics.checkNotNull((Object)object);
        JavaScriptSynchronizer javaScriptSynchronizer = (JavaScriptSynchronizer)object;
        List<VirtualFile> list = EffectiveFileScriptProcessor.getEffectiveFiles((Collection<? extends VirtualFile>)javaScriptSynchronizer.getIncorrectFiles(), debugProcess, vm2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
        if (this.notifyIfHasIncorrectFiles(list, debugProcess)) {
            return Promises.rejectedPromise((String)"incorrect files");
        }
        List<VirtualFile> files = this.collectPendingFiles(null, (XDebugProcess)debugProcess, javaScriptSynchronizer);
        if (files.isEmpty()) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        return this.doUpdate(files, debugProcess, vm2, javaScriptSynchronizer, null);
    }

    public final boolean notifyIfHasIncorrectFiles(@NotNull List<? extends VirtualFile> incorrectFiles, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(incorrectFiles, (String)"incorrectFiles");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (incorrectFiles.isEmpty()) {
            return false;
        }
        for (VirtualFile virtualFile : incorrectFiles) {
            ApplicationUpdaterKt.access$notifyFileHasErrors(virtualFile, (XDebugProcess)debugProcess);
        }
        return true;
    }

    @NotNull
    public final Promise<?> autoTriggeredUpdate(@NotNull EffectiveFileScriptProcessor result, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            return this.autoTriggeredUpdate(list, javaScriptDebugProcess, vm, synchronizer, null);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
        Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
        this.restartOrNotify$intellij_js_liveEdit((XDebugProcess)javaScriptDebugProcess);
        return Promises.rejectedPromise();
    }

    @NotNull
    public final Promise<? extends Object> autoTriggeredUpdate(@NotNull List<VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        this.collectPendingFiles(files, (XDebugProcess)debugProcess, synchronizer);
        if (!files.isEmpty()) {
            Promise<UpdateResult> updateResult = this.doUpdate(files, debugProcess, vm, synchronizer, setSourceExecutor);
            updateResult.onSuccess(arg_0 -> ApplicationUpdater.autoTriggeredUpdate$lambda$0((Function1)new Function1<UpdateResult, Unit>(debugProcess){
                final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                {
                    this.$debugProcess = $debugProcess;
                    super(1);
                }

                public final void invoke(UpdateResult it) {
                    Set set = SetsKt.emptySet();
                    Intrinsics.checkNotNull((Object)it);
                    ApplicationUpdaterKt.notifyAboutUpdates(this.$debugProcess, set, it, UpdateResult.Companion.getEMPTY(), true);
                }
            }, arg_0));
            return updateResult;
        }
        return Promises.resolvedPromise();
    }

    @NotNull
    public final List<VirtualFile> collectPendingFiles(@Nullable List<VirtualFile> result, @NotNull XDebugProcess debugProcess, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        List list;
        Set<VirtualFile> pendingFiles;
        UpdateState updateState;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        List newResult = result;
        UpdateState updateState2 = updateState = this.processToState.get(debugProcess);
        Set<Object> set = pendingFiles = updateState2 != null ? updateState2.getModifiedFiles() : null;
        if (!ContainerUtil.isEmpty((Collection)pendingFiles)) {
            Set<VirtualFile> set2 = pendingFiles;
            Intrinsics.checkNotNull(set2);
            Iterator<VirtualFile> iterator = set2.iterator();
            while (iterator.hasNext()) {
                VirtualFile pendingFile = iterator.next();
                if (!synchronizer.canHandle(pendingFile.getFileType(), debugProcess.getSession().getProject())) continue;
                iterator.remove();
                if (newResult == null) {
                    newResult = (List)new SmartList();
                }
                newResult.add(pendingFile);
            }
        }
        if ((list = newResult) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<UpdateResult> doUpdate(@NotNull List<? extends VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        boolean bl2 = bl = !((Collection)files).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        CharSequence[] sources2 = ApplicationUpdaterKt.access$collectSources((XDebugProcess)debugProcess, synchronizer, files);
        if (sources2 == null) {
            this.getState((XDebugProcess)debugProcess).getModifiedFiles().addAll((Collection<VirtualFile>)files);
            return Promises.rejectedPromise();
        }
        if (setSourceExecutor == null) {
            return this.updateScripts(files, debugProcess, vm, sources2);
        }
        SmartList totalResult = new SmartList();
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            totalResult.addAll((Collection)setSourceExecutor.execute(files.get(i), sources2[i]));
        }
        Promise promise2 = Promises.all((Collection)((Collection)totalResult)).then(arg_0 -> ApplicationUpdater.doUpdate$lambda$1(files, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final UpdateState getState(XDebugProcess debugProcess) {
        UpdateState updateState = this.processToState.get(debugProcess);
        if (updateState == null) {
            updateState = new UpdateState();
            UpdateState prevState = this.processToState.putIfAbsent(debugProcess, updateState);
            if (prevState != null) {
                return prevState;
            }
            Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
            Disposer.register((Disposable)((Disposable)debugProcess), () -> ApplicationUpdater.getState$lambda$2(this, debugProcess));
        }
        return updateState;
    }

    private final Promise<UpdateResult> updateScripts(List<? extends VirtualFile> files, JavaScriptDebugProcess<?> debugProcess, Vm vm, CharSequence[] sources2) {
        MyFileScriptProcessor processor = new MyFileScriptProcessor(debugProcess, vm);
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            processor.reset(files.get(i));
            processor.setSource(sources2[i]);
            vm.getScriptManager().forEachScript((Function1)new Function1<Script, Boolean>(processor){
                final /* synthetic */ MyFileScriptProcessor $processor;
                {
                    this.$processor = $processor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Script it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$processor.process(it);
                }
            });
        }
        if (processor.getTotalResult().isEmpty()) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        Promise promise2 = Promises.collectResults$default((Collection)((Collection)processor.getTotalResult()), (boolean)false, (int)1, null).then(arg_0 -> ApplicationUpdater.updateScripts$lambda$3(updateScripts.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    public final void restartOrNotify$intellij_js_liveEdit(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (LiveEditOptions.getInstance().isRestartIfHotSwapFailed()) {
            ApplicationUpdaterKt.restart(debugProcess);
            UpdateState state = this.getState(debugProcess);
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification();
            if (lastRestartedOnHotSwapFailedNotification == null) {
                String string = LiveEditBundle.message("settings.notifications.hotswap.failed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                lastRestartedOnHotSwapFailedNotification = new SingletonNotificationManager(string, NotificationType.INFORMATION);
                state.setLastRestartedOnHotSwapFailedNotification(lastRestartedOnHotSwapFailedNotification);
            }
            XDebugSession session = debugProcess.getSession();
            String content = session.getSessionName() + ": " + LiveEditBundle.message("disable.restart.if.hotswap.failed", new Object[0]);
            lastRestartedOnHotSwapFailedNotification.notify("", content, session.getProject(), ApplicationUpdater::restartOrNotify$lambda$4);
        } else {
            RestartRequiredNotificationItem restartNotificationItem = this.markAsRestartRequired(debugProcess);
            if (!restartNotificationItem.hasActiveNotification()) {
                restartNotificationItem.notify(LiveEditBundle.message("restart.required", new Object[0]) + LiveEditBundle.message("enable.restart.if.hotswap.failed", new Object[0]));
            }
        }
    }

    private final RestartRequiredNotificationItem markAsRestartRequired(XDebugProcess debugProcess) {
        UpdateState state = this.getState(debugProcess);
        RestartRequiredNotificationItem restartNotificationItem = state.getNotificationItem();
        if (restartNotificationItem == null) {
            restartNotificationItem = new RestartRequiredNotificationItem(debugProcess);
            state.setNotificationItem(restartNotificationItem);
            state.getModifiedFiles().clear();
        }
        return restartNotificationItem;
    }

    public final boolean checkIsBlackListed(@NotNull XDebugProcess debugProcess, boolean notify) {
        RestartRequiredNotificationItem restartNotificationItem;
        UpdateState state;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        UpdateState updateState = state = this.processToState.get(debugProcess);
        RestartRequiredNotificationItem restartRequiredNotificationItem = restartNotificationItem = updateState != null ? updateState.getNotificationItem() : null;
        if (restartNotificationItem != null) {
            if (notify && !restartNotificationItem.hasActiveNotification()) {
                this.restartOrNotify$intellij_js_liveEdit(debugProcess);
            }
            return true;
        }
        return false;
    }

    public final void scheduleUpdateScripts(@NotNull EffectiveFileScriptProcessor result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            this.schedule(list, (XDebugProcess)javaScriptDebugProcess);
        } else {
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            this.markAsRestartRequired((XDebugProcess)javaScriptDebugProcess);
        }
    }

    public final void schedule(@NotNull List<? extends VirtualFile> files, @NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.getState(debugProcess).getModifiedFiles().addAll((Collection<VirtualFile>)files);
    }

    public final void clearUpdateState(@NotNull XDebugProcess debugProcess, boolean remove) {
        block2: {
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification;
            RestartRequiredNotificationItem notificationItem;
            UpdateState state;
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            UpdateState updateState = state = remove ? this.processToState.remove(debugProcess) : this.processToState.get(debugProcess);
            if (state == null) break block2;
            RestartRequiredNotificationItem restartRequiredNotificationItem = notificationItem = state.getNotificationItem();
            if (restartRequiredNotificationItem != null) {
                restartRequiredNotificationItem.clear();
            }
            SingletonNotificationManager singletonNotificationManager = lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification();
            if (singletonNotificationManager != null) {
                singletonNotificationManager.clear();
            }
        }
    }

    private static final void autoTriggeredUpdate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final UpdateResult doUpdate$lambda$1(List $files, Object it) {
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        return new UpdateResult(new HashSet($files));
    }

    private static final void getState$lambda$2(ApplicationUpdater this$0, XDebugProcess $debugProcess) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
        this$0.clearUpdateState($debugProcess, true);
    }

    private static final UpdateResult updateScripts$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UpdateResult)$tmp0.invoke(p0);
    }

    private static final void restartOrNotify$lambda$4(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setListener((NotificationListener)ApplicationUpdaterKt.access$getDISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER$p());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater$MyFileScriptProcessor;", "Lcom/jetbrains/liveEdit/update/FileScriptProcessor;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "vm", "Lorg/jetbrains/debugger/Vm;", "(Lcom/jetbrains/liveEdit/update/ApplicationUpdater;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;)V", "source", "", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "state", "Lcom/jetbrains/liveEdit/update/UpdateState;", "getState", "()Lcom/jetbrains/liveEdit/update/UpdateState;", "totalResult", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/liveEdit/update/UpdateScriptResult;", "getTotalResult", "()Lcom/intellij/util/SmartList;", "updateConfiguration", "Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "getUpdateConfiguration", "()Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "process", "", "script", "Lorg/jetbrains/debugger/Script;", "intellij.js.liveEdit"})
    private final class MyFileScriptProcessor
    extends FileScriptProcessor {
        @NotNull
        private final Vm vm;
        @Nullable
        private final UpdateConfiguration updateConfiguration;
        @NotNull
        private final SmartList<Promise<UpdateScriptResult>> totalResult;
        @NotNull
        private final UpdateState state;
        @Nullable
        private CharSequence source;

        public MyFileScriptProcessor(@NotNull JavaScriptDebugProcess<?> debugProcess, Vm vm) {
            Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            super(debugProcess);
            this.vm = vm;
            this.updateConfiguration = ApplicationUpdaterKt.getUpdateConfiguration((XDebugProcess)debugProcess);
            this.totalResult = new SmartList();
            this.state = ApplicationUpdater.this.getState((XDebugProcess)debugProcess);
        }

        @Nullable
        public final UpdateConfiguration getUpdateConfiguration() {
            return this.updateConfiguration;
        }

        @NotNull
        public final SmartList<Promise<UpdateScriptResult>> getTotalResult() {
            return this.totalResult;
        }

        @NotNull
        public final UpdateState getState() {
            return this.state;
        }

        @Nullable
        public final CharSequence getSource() {
            return this.source;
        }

        public final void setSource(@Nullable CharSequence charSequence) {
            this.source = charSequence;
        }

        public boolean process(@NotNull Script script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            if (this.isScriptFile(script.getUrl())) {
                CharSequence text = this.source;
                if (this.updateConfiguration != null) {
                    CharSequence charSequence = text;
                    Intrinsics.checkNotNull((Object)charSequence);
                    text = this.updateConfiguration.preprocessSource(charSequence);
                }
                CharSequence charSequence = text;
                Intrinsics.checkNotNull((Object)charSequence);
                VirtualFile virtualFile = this.file;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                JavaScriptDebugProcess javaScriptDebugProcess = this.debugProcess;
                Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
                this.totalResult.add((Object)ApplicationUpdaterKt.access$setScriptSource(charSequence, script, this.vm, virtualFile, (XDebugProcess)javaScriptDebugProcess, this.state));
                return false;
            }
            return true;
        }
    }
}

