/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.elementsInspector.ElementsView;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewState;
import com.jetbrains.liveEdit.elementsInspector.UpdateQueueKt;
import com.jetbrains.liveEdit.elementsInspector.UpdateTagTask;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.NodeIdentifiable;
import org.jetbrains.wip.protocol.dom.AttributeModifiedEventData;
import org.jetbrains.wip.protocol.dom.AttributeRemovedEventData;
import org.jetbrains.wip.protocol.dom.CharacterDataModifiedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeCountUpdatedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeInsertedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeRemovedEventData;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.dom.GetAttributesResult;
import org.jetbrains.wip.protocol.dom.NodeValue;
import org.jetbrains.wip.protocol.dom.SetChildNodesEventData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0003XYZB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ6\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020'J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020)J\u0006\u0010*\u001a\u00020\u001aJ\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020-2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0/H\u0002J \u00100\u001a\u00020\u001a2\b\u00101\u001a\u0004\u0018\u0001022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\u0016\u00103\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J/\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u0002062\u0006\u0010 \u001a\u00020!2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H508H\u0002\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020;2\u0006\u0010 \u001a\u00020!H\u0004J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010 \u001a\u00020!H\u0004J\u0012\u0010>\u001a\u0004\u0018\u0001062\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020AJ\u0018\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020EH\u0002J&\u0010F\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010D\u001a\u00020E2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\f\u0010G\u001a\u00060\u0013j\u0002`\u0014H\u0002J\n\u0010H\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010I\u001a\u0004\u0018\u00010\r2\b\u0010J\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010K\u001a\u00020\u001aH\u0002J&\u0010L\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020N2\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\u001e\u0010O\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\u0010\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020#H\u0002J\b\u0010R\u001a\u00020\u001aH\u0016J&\u0010S\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020T2\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\u0010\u0010U\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020#H\u0002J\b\u0010W\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006["}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;", "Ljava/lang/Runnable;", "elementsInspector", "Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "document", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "getDocument", "()Lcom/intellij/openapi/editor/impl/DocumentImpl;", "eventsQueue", "Ljava/util/LinkedList;", "Lorg/jetbrains/wip/protocol/NodeIdentifiable;", "nodeIdsInlineStyleInvalid", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "queueLock", "Ljava/lang/Object;", "sharedStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "state", "Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "getState", "()Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "add", "", "event", "addChildNodes", "nodes", "", "Lorg/jetbrains/wip/protocol/dom/NodeValue;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "previousNodeId", "", "unformatted", "", "childNodeInserted", "Lorg/jetbrains/wip/protocol/dom/ChildNodeInsertedEventData;", "childNodesSet", "Lorg/jetbrains/wip/protocol/dom/SetChildNodesEventData;", "clear", "doAdd", "forceRun", "", "doProcessTasks", "Lcom/intellij/util/SmartList;", "doRemoveAttribute", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "formatChanged", "getElement", "T", "Lcom/intellij/psi/xml/XmlTagChild;", "aClass", "Ljava/lang/Class;", "(Lcom/intellij/openapi/editor/RangeMarker;Ljava/lang/Class;)Lcom/intellij/psi/xml/XmlTagChild;", "getTag", "Lcom/intellij/psi/xml/XmlTag;", "getText", "Lcom/intellij/psi/xml/XmlText;", "getXmlTagOrText", "inlineStyleInvalidated", "nodeIds", "", "insertString", "offset", "text", "", "insertText", "newStringBuilder", "peekNextTask", "pollNextTask", "peeked", "prepareAndProcessTasks", "removeAttribute", "data", "Lorg/jetbrains/wip/protocol/dom/AttributeRemovedEventData;", "removeChild", "rescheduleAlarm", "delay", "run", "updateAttributeValue", "Lorg/jetbrains/wip/protocol/dom/AttributeModifiedEventData;", "updateStyleAttribute", "nodeId", "validateRangeMarkers", "ChildNodeInsertedUpdateTask", "SetChildNodesUpdateTask", "UpdateStyleAttributeTask", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nUpdateQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateQueue.kt\ncom/jetbrains/liveEdit/elementsInspector/UpdateQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,445:1\n1#2:446\n*E\n"})
public final class UpdateQueue
implements Runnable {
    @NotNull
    private final ElementsView elementsInspector;
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private final StringBuilder sharedStringBuilder;
    @NotNull
    private final Object queueLock;
    @NotNull
    private final LinkedList<NodeIdentifiable> eventsQueue;
    @NotNull
    private final IntOpenHashSet nodeIdsInlineStyleInvalid;

    public UpdateQueue(@NotNull ElementsView elementsInspector) {
        Intrinsics.checkNotNullParameter((Object)elementsInspector, (String)"elementsInspector");
        this.elementsInspector = elementsInspector;
        this.alarm = new SingleAlarm((Runnable)this, 500, (Disposable)this.elementsInspector, Alarm.ThreadToUse.SWING_THREAD, null, 16, null);
        this.sharedStringBuilder = new StringBuilder();
        this.queueLock = new Object();
        this.eventsQueue = new LinkedList();
        this.nodeIdsInlineStyleInvalid = new IntOpenHashSet();
    }

    private final ElementsViewState getState() {
        ElementsViewState elementsViewState = this.elementsInspector.getState$intellij_js_liveEdit();
        Intrinsics.checkNotNull((Object)elementsViewState);
        return elementsViewState;
    }

    private final DocumentImpl getDocument() {
        return this.getState().getDocument$intellij_js_liveEdit();
    }

    public final void childNodeInserted(@NotNull ChildNodeInsertedEventData event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.doAdd(new ChildNodeInsertedUpdateTask(event), false);
    }

    public final void add(@NotNull NodeIdentifiable event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.doAdd(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAdd(NodeIdentifiable event, boolean forceRun) {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.eventsQueue.add(event);
        }
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)forceRun, (int)0, (int)2, null);
    }

    public final void childNodesSet(@NotNull SetChildNodesEventData event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.nodes().isEmpty()) {
            return;
        }
        this.doAdd(new SetChildNodesUpdateTask(event), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void inlineStyleInvalidated(@NotNull int[] nodeIds) {
        Intrinsics.checkNotNullParameter((Object)nodeIds, (String)"nodeIds");
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.nodeIdsInlineStyleInvalid.addAll((IntCollection)new IntArrayList(nodeIds));
        }
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.getState().isReformatInProgress$intellij_js_liveEdit()) {
            Integer n2 = UpdateQueueKt.access$getWAIT_FOR_COMMIT_MS$p();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"access$getWAIT_FOR_COMMIT_MS$p(...)");
            this.rescheduleAlarm(((Number)n2).intValue());
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            n = 0;
            n = this.eventsQueue.size();
        }
        int queueSize = n;
        Integer n3 = UpdateQueueKt.access$getMAX_TASKS_WITHOUT_RELOAD$p();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"access$getMAX_TASKS_WITHOUT_RELOAD$p(...)");
        if (queueSize >= ((Number)n3).intValue()) {
            this.elementsInspector.reloadDocument();
            return;
        }
        if (queueSize > 0) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> UpdateQueue.run$lambda$3(this));
        }
        object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            IntIterator intIterator = this.nodeIdsInlineStyleInvalid.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
            IntIterator iterator = intIterator;
            while (iterator.hasNext()) {
                int nodeId = iterator.nextInt();
                Integer n4 = nodeId;
                if (!((Map)this.getState().getNodeIdToRangeMarker$intellij_js_liveEdit()).containsKey(n4)) continue;
                this.updateStyleAttribute(nodeId);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void prepareAndProcessTasks() {
        SmartList unformatted = new SmartList();
        boolean rangeMarkersDisposed = false;
        boolean needToValidateRangeMarkers = false;
        try {
            this.getDocument().setAcceptSlashR(true);
            needToValidateRangeMarkers = this.doProcessTasks((SmartList<RangeMarker>)unformatted);
            rangeMarkersDisposed = true;
        }
        catch (Throwable throwable) {
            this.getDocument().setAcceptSlashR(false);
            if (needToValidateRangeMarkers) {
                this.validateRangeMarkers();
            }
            if (!unformatted.isEmpty()) {
                for (RangeMarker rangeMarker : unformatted) {
                    rangeMarker.dispose();
                }
            }
            throw throwable;
        }
        this.getDocument().setAcceptSlashR(false);
        if (needToValidateRangeMarkers) {
            this.validateRangeMarkers();
        }
    }

    private final void rescheduleAlarm(int delay) {
        ApplicationManager.getApplication().invokeLater(() -> UpdateQueue.rescheduleAlarm$lambda$5(this, delay));
    }

    private final boolean doProcessTasks(SmartList<RangeMarker> unformatted) {
        Ref.BooleanRef needToValidateRangeMarkers = new Ref.BooleanRef();
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this, unformatted, needToValidateRangeMarkers){
            final /* synthetic */ UpdateQueue this$0;
            final /* synthetic */ SmartList<RangeMarker> $unformatted;
            final /* synthetic */ Ref.BooleanRef $needToValidateRangeMarkers;
            {
                this.this$0 = $receiver;
                this.$unformatted = $unformatted;
                this.$needToValidateRangeMarkers = $needToValidateRangeMarkers;
                super(0);
            }

            public final void invoke() {
                Int2ObjectOpenHashMap<RangeMarker> nodeIdToRangeMarker = UpdateQueue.access$getState(this.this$0).getNodeIdToRangeMarker$intellij_js_liveEdit();
                while (true) {
                    ChildNodeInsertedEventData inserted;
                    NodeIdentifiable nextTask;
                    RangeMarker rangeMarker;
                    NodeIdentifiable task;
                    boolean requiresCommitted;
                    boolean bl = requiresCommitted = (task = UpdateQueue.access$peekNextTask(this.this$0)) instanceof CharacterDataModifiedEventData || task instanceof AttributeModifiedEventData || task instanceof AttributeRemovedEventData || task instanceof ChildNodeRemovedEventData || task instanceof UpdateStyleAttributeTask;
                    if (requiresCommitted && !UpdateQueue.access$getState(this.this$0).requestCommitted$intellij_js_liveEdit()) {
                        Integer n = UpdateQueueKt.access$getWAIT_FOR_COMMIT_MS$p();
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"access$getWAIT_FOR_COMMIT_MS$p(...)");
                        UpdateQueue.access$rescheduleAlarm(this.this$0, ((Number)n).intValue());
                        break;
                    }
                    UpdateQueue.access$pollNextTask(this.this$0, task);
                    if (task == null) break;
                    RangeMarker rangeMarker2 = rangeMarker = task instanceof ChildNodeRemovedEventData ? (RangeMarker)nodeIdToRangeMarker.remove(((ChildNodeRemovedEventData)task).nodeId()) : (RangeMarker)nodeIdToRangeMarker.get(task.nodeId());
                    if (rangeMarker2 == null ? task.nodeId() != UpdateQueue.access$getElementsInspector$p(this.this$0).getDocumentId$intellij_js_liveEdit() : !rangeMarker2.isValid()) continue;
                    if (task instanceof CharacterDataModifiedEventData) {
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        XmlText xmlText = this.this$0.getText(rangeMarker);
                        String value = ((CharacterDataModifiedEventData)task).characterData();
                        if (xmlText == null) {
                            StringBuilder builder = UpdateQueue.access$newStringBuilder(this.this$0);
                            ElementsViewKt.convertLineSeparators(value, builder);
                            UpdateQueue.access$insertText(this.this$0, rangeMarker, builder, (List)this.$unformatted);
                            nodeIdToRangeMarker.put(((CharacterDataModifiedEventData)task).nodeId(), (Object)UpdateQueue.access$getDocument(this.this$0).createRangeMarker(rangeMarker.getStartOffset(), rangeMarker.getStartOffset() + value.length()));
                            rangeMarker.dispose();
                            continue;
                        }
                        xmlText.setValue(value);
                        continue;
                    }
                    if (task instanceof AttributeModifiedEventData) {
                        AttributeModifiedEventData attributeModifiedEventData = (AttributeModifiedEventData)task;
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        UpdateQueue.access$updateAttributeValue(this.this$0, attributeModifiedEventData, rangeMarker, (List)this.$unformatted);
                        continue;
                    }
                    if (task instanceof AttributeRemovedEventData) {
                        AttributeRemovedEventData attributeRemovedEventData = (AttributeRemovedEventData)task;
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        UpdateQueue.access$removeAttribute(this.this$0, attributeRemovedEventData, rangeMarker, (List)this.$unformatted);
                        continue;
                    }
                    if (task instanceof ChildNodeCountUpdatedEventData) {
                        UpdateQueue.access$getElementsInspector$p(this.this$0).requestChildNodes$intellij_js_liveEdit(((ChildNodeCountUpdatedEventData)task).nodeId());
                        continue;
                    }
                    if (task instanceof ChildNodeRemovedEventData) {
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        UpdateQueue.access$removeChild(this.this$0, rangeMarker, (List)this.$unformatted);
                        this.$needToValidateRangeMarkers.element = true;
                        continue;
                    }
                    if (task instanceof ChildNodeInsertedUpdateTask && (nextTask = UpdateQueue.access$peekNextTask(this.this$0)) instanceof ChildNodeRemovedEventData && (inserted = ((ChildNodeInsertedUpdateTask)task).getData()).node().getNodeId() == ((ChildNodeRemovedEventData)nextTask).nodeId() && inserted.getParentNodeId() == ((ChildNodeRemovedEventData)nextTask).getParentNodeId()) {
                        UpdateQueue.access$pollNextTask(this.this$0, nextTask);
                        continue;
                    }
                    ((UpdateTagTask)task).update(rangeMarker, (List)this.$unformatted);
                }
            }
        }));
        this.formatChanged((List)unformatted);
        return needToValidateRangeMarkers.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NodeIdentifiable peekNextTask() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            NodeIdentifiable nodeIdentifiable = this.eventsQueue.peek();
            return nodeIdentifiable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NodeIdentifiable pollNextTask(NodeIdentifiable peeked) {
        NodeIdentifiable nodeIdentifiable;
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            nodeIdentifiable = this.eventsQueue.poll();
        }
        NodeIdentifiable poll = nodeIdentifiable;
        if (peeked != null && !Intrinsics.areEqual((Object)peeked, (Object)poll)) {
            ApplicationInspectorImplKt.getLOG().error("Concurrent modification");
        }
        return poll;
    }

    private final void validateRangeMarkers() {
        ObjectIterator iterator = this.getState().getNodeIdToRangeMarker$intellij_js_liveEdit().int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            RangeMarker rangeMarker = (RangeMarker)entry.getValue();
            if (rangeMarker.isValid()) continue;
            rangeMarker.dispose();
            iterator.remove();
        }
    }

    private final void formatChanged(List<? extends RangeMarker> unformatted) {
        if (unformatted.isEmpty()) {
            return;
        }
        List ranges = new ArrayList();
        for (RangeMarker rangeMarker : unformatted) {
            if (!rangeMarker.isValid()) continue;
            ranges.add(new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
            rangeMarker.dispose();
        }
        this.getState().scheduleReformat$intellij_js_liveEdit(ranges);
    }

    private final void removeChild(RangeMarker rangeMarker, List<RangeMarker> unformatted) {
        XmlTagChild element = this.getXmlTagOrText(rangeMarker);
        rangeMarker.dispose();
        if (element == null) {
            return;
        }
        int startOffsetToFormat = element.getNode().getStartOffset();
        element.delete();
        RangeMarker rangeMarker2 = this.getDocument().createRangeMarker(startOffsetToFormat, Math.min(this.getDocument().getTextLength(), startOffsetToFormat + 1));
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
        unformatted.add(rangeMarker2);
    }

    private final void updateStyleAttribute(int nodeId) {
        WipCommandProcessor wipCommandProcessor = this.elementsInspector.getCommandProcessor$intellij_js_liveEdit();
        Intrinsics.checkNotNull((Object)wipCommandProcessor);
        wipCommandProcessor.send((Request)DOMKt.GetAttributes((int)nodeId)).onSuccess(arg_0 -> UpdateQueue.updateStyleAttribute$lambda$8((Function1)new Function1<GetAttributesResult, Unit>(this, nodeId){
            final /* synthetic */ UpdateQueue this$0;
            final /* synthetic */ int $nodeId;
            {
                this.this$0 = $receiver;
                this.$nodeId = $nodeId;
                super(1);
            }

            public final void invoke(GetAttributesResult it) {
                List attributes = it.attributes();
                if (attributes.isEmpty()) {
                    return;
                }
                this.this$0.add(this.this$0.new UpdateStyleAttributeTask(this.$nodeId, attributes));
            }
        }, arg_0));
    }

    private final void removeAttribute(AttributeRemovedEventData data, RangeMarker rangeMarker, List<RangeMarker> unformatted) {
        this.doRemoveAttribute(this.getTag(rangeMarker).getAttribute(data.name()), unformatted);
    }

    private final void doRemoveAttribute(XmlAttribute attribute, List<RangeMarker> unformatted) {
        if (attribute != null) {
            int startOffset = attribute.getNode().getStartOffset();
            attribute.delete();
            RangeMarker rangeMarker = this.getDocument().createRangeMarker(startOffset, startOffset);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
            unformatted.add(rangeMarker);
        }
    }

    @NotNull
    protected final XmlTag getTag(@NotNull RangeMarker rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        XmlTag xmlTag = this.getElement(rangeMarker, XmlTag.class);
        Intrinsics.checkNotNull((Object)xmlTag);
        return xmlTag;
    }

    @Nullable
    protected final XmlText getText(@NotNull RangeMarker rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        XmlText xmlText = this.getElement(rangeMarker, XmlText.class);
        if (xmlText == null) {
            ApplicationInspectorImplKt.getLOG().assertTrue(rangeMarker.getStartOffset() == rangeMarker.getEndOffset(), (Object)"empty text, doesn't relates to any XmlText element");
        }
        return xmlText;
    }

    private final XmlTagChild getXmlTagOrText(RangeMarker rangeMarker) {
        if (rangeMarker.getStartOffset() == rangeMarker.getEndOffset()) {
            return (XmlTagChild)this.getText(rangeMarker);
        }
        Class[] classArray = new Class[]{XmlTag.class, XmlText.class};
        XmlTagChild element = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.getState().getPsiFile$intellij_js_liveEdit().findElementAt(rangeMarker.getStartOffset()), (Class[])classArray);
        ApplicationInspectorImplKt.getLOG().assertTrue(element != null);
        return element;
    }

    private final <T extends XmlTagChild> T getElement(RangeMarker rangeMarker, Class<T> aClass) {
        return (T)((XmlTagChild)PsiTreeUtil.getParentOfType((PsiElement)this.getState().getPsiFile$intellij_js_liveEdit().findElementAt(rangeMarker.getStartOffset()), aClass, (boolean)false));
    }

    private final void insertString(int offset, CharSequence text) {
        this.getDocument().insertString(offset, text);
    }

    private final void updateAttributeValue(AttributeModifiedEventData data, RangeMarker rangeMarker, List<RangeMarker> unformatted) {
        String name;
        XmlTag tag = this.getTag(rangeMarker);
        XmlAttribute attribute = tag.getAttribute(name = data.name());
        if (attribute == null) {
            StringBuilder builder = this.newStringBuilder();
            builder.append(' ').append(name);
            ElementsViewKt.appendAttributeValue(data.value(), builder);
            this.insertText(rangeMarker, builder, unformatted);
        } else {
            attribute.setValue(data.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            this.alarm.cancelAllRequests();
            this.eventsQueue.clear();
            this.nodeIdsInlineStyleInvalid.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void insertText(RangeMarker rangeMarker, CharSequence text, List<RangeMarker> unformatted) {
        int elementAttributesOffset = rangeMarker.getStartOffset();
        this.insertString(elementAttributesOffset, text);
        RangeMarker rangeMarker2 = this.getDocument().createRangeMarker(elementAttributesOffset, elementAttributesOffset + text.length());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
        unformatted.add(rangeMarker2);
    }

    private final void addChildNodes(List<? extends NodeValue> nodes, RangeMarker rangeMarker, int previousNodeId, List<RangeMarker> unformatted) {
        int insertionOffset = 0;
        StringBuilder builder = this.newStringBuilder();
        if (previousNodeId == 0) {
            insertionOffset = rangeMarker == null ? this.getDocument().getTextLength() : rangeMarker.getStartOffset() + 1;
        } else {
            RangeMarker prevElementRangeMarker = (RangeMarker)this.getState().getNodeIdToRangeMarker$intellij_js_liveEdit().get(previousNodeId);
            if (prevElementRangeMarker == null) {
                return;
            }
            insertionOffset = prevElementRangeMarker.getEndOffset();
        }
        Int2ObjectOpenHashMap nodeIdToOffset = new Int2ObjectOpenHashMap();
        this.elementsInspector.buildStringRepresentation$intellij_js_liveEdit(nodes, builder, (Int2ObjectMap<Segment>)((Int2ObjectMap)nodeIdToOffset), true);
        this.insertString(insertionOffset, builder);
        this.getState().createPointers$intellij_js_liveEdit((Int2ObjectMap<Segment>)((Int2ObjectMap)nodeIdToOffset), insertionOffset);
        RangeMarker rangeMarker2 = this.getDocument().createRangeMarker(insertionOffset, Math.min(this.getDocument().getTextLength(), insertionOffset + builder.length() + 3));
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
        unformatted.add(rangeMarker2);
    }

    private final StringBuilder newStringBuilder() {
        this.sharedStringBuilder.setLength(0);
        return this.sharedStringBuilder;
    }

    private static final void run$lambda$3(UpdateQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.prepareAndProcessTasks();
    }

    private static final void rescheduleAlarm$lambda$5(UpdateQueue this$0, int $delay) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alarm.request(false, $delay);
    }

    private static final void updateStyleAttribute$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ElementsViewState access$getState(UpdateQueue $this) {
        return $this.getState();
    }

    public static final /* synthetic */ NodeIdentifiable access$peekNextTask(UpdateQueue $this) {
        return $this.peekNextTask();
    }

    public static final /* synthetic */ void access$rescheduleAlarm(UpdateQueue $this, int delay) {
        $this.rescheduleAlarm(delay);
    }

    public static final /* synthetic */ NodeIdentifiable access$pollNextTask(UpdateQueue $this, NodeIdentifiable peeked) {
        return $this.pollNextTask(peeked);
    }

    public static final /* synthetic */ ElementsView access$getElementsInspector$p(UpdateQueue $this) {
        return $this.elementsInspector;
    }

    public static final /* synthetic */ StringBuilder access$newStringBuilder(UpdateQueue $this) {
        return $this.newStringBuilder();
    }

    public static final /* synthetic */ DocumentImpl access$getDocument(UpdateQueue $this) {
        return $this.getDocument();
    }

    public static final /* synthetic */ void access$updateAttributeValue(UpdateQueue $this, AttributeModifiedEventData data, RangeMarker rangeMarker, List unformatted) {
        $this.updateAttributeValue(data, rangeMarker, unformatted);
    }

    public static final /* synthetic */ void access$removeAttribute(UpdateQueue $this, AttributeRemovedEventData data, RangeMarker rangeMarker, List unformatted) {
        $this.removeAttribute(data, rangeMarker, unformatted);
    }

    public static final /* synthetic */ void access$removeChild(UpdateQueue $this, RangeMarker rangeMarker, List unformatted) {
        $this.removeChild(rangeMarker, unformatted);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue$ChildNodeInsertedUpdateTask;", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateTagTask;", "data", "Lorg/jetbrains/wip/protocol/dom/ChildNodeInsertedEventData;", "(Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;Lorg/jetbrains/wip/protocol/dom/ChildNodeInsertedEventData;)V", "getData", "()Lorg/jetbrains/wip/protocol/dom/ChildNodeInsertedEventData;", "update", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "unformatted", "", "intellij.js.liveEdit"})
    private final class ChildNodeInsertedUpdateTask
    extends UpdateTagTask {
        @NotNull
        private final ChildNodeInsertedEventData data;

        public ChildNodeInsertedUpdateTask(ChildNodeInsertedEventData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(data.getParentNodeId());
            this.data = data;
        }

        @NotNull
        public final ChildNodeInsertedEventData getData() {
            return this.data;
        }

        @Override
        public void update(@Nullable RangeMarker rangeMarker, @NotNull List<RangeMarker> unformatted) {
            Intrinsics.checkNotNullParameter(unformatted, (String)"unformatted");
            UpdateQueue.this.addChildNodes(CollectionsKt.listOf((Object)this.data.node()), rangeMarker, this.data.getPreviousNodeId(), unformatted);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue$SetChildNodesUpdateTask;", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateTagTask;", "data", "Lorg/jetbrains/wip/protocol/dom/SetChildNodesEventData;", "(Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;Lorg/jetbrains/wip/protocol/dom/SetChildNodesEventData;)V", "update", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "unformatted", "", "intellij.js.liveEdit"})
    private final class SetChildNodesUpdateTask
    extends UpdateTagTask {
        @NotNull
        private final SetChildNodesEventData data;

        public SetChildNodesUpdateTask(SetChildNodesEventData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(data.getParentId());
            this.data = data;
        }

        @Override
        public void update(@Nullable RangeMarker rangeMarker, @NotNull List<RangeMarker> unformatted) {
            Intrinsics.checkNotNullParameter(unformatted, (String)"unformatted");
            UpdateQueue.this.addChildNodes(this.data.nodes(), rangeMarker, 0, unformatted);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue$UpdateStyleAttributeTask;", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateTagTask;", "nodeId", "", "attributes", "", "", "(Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;ILjava/util/List;)V", "update", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "unformatted", "", "intellij.js.liveEdit"})
    private final class UpdateStyleAttributeTask
    extends UpdateTagTask {
        @NotNull
        private final List<String> attributes;

        public UpdateStyleAttributeTask(@NotNull int nodeId, List<String> attributes) {
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            super(nodeId);
            this.attributes = attributes;
        }

        @Override
        public void update(@NotNull RangeMarker rangeMarker, @NotNull List<RangeMarker> unformatted) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            Intrinsics.checkNotNullParameter(unformatted, (String)"unformatted");
            String value = null;
            for (int i = 0; i < this.attributes.size(); i += 2) {
                if (!StringsKt.equals((String)"style", (String)this.attributes.get(i), (boolean)true)) continue;
                value = this.attributes.get(i + 1);
                break;
            }
            XmlTag tag = UpdateQueue.this.getTag(rangeMarker);
            XmlAttribute styleAttribute = tag.getAttribute("style");
            if (value == null) {
                UpdateQueue.this.doRemoveAttribute(styleAttribute, unformatted);
            } else if (styleAttribute == null) {
                if (!StringUtil.isEmpty(value)) {
                    UpdateQueue.this.insertText(rangeMarker, "style=\"" + value + "\"", unformatted);
                }
            } else {
                styleAttribute.setValue(value);
            }
        }
    }
}

