/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.liveEdit.elementsInspector.ElementsView;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewState;
import com.jetbrains.liveEdit.elementsInspector.InspectorElementHighlightExecutorKt;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.overlay.HighlightConfig;
import org.jetbrains.wip.protocol.overlay.OverlayKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "Lcom/jetbrains/liveEdit/highlighting/ElementHighlightExecutor;", "view", "Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;)V", "doHideHighlight", "", "project", "Lcom/intellij/openapi/project/Project;", "ifElement", "Lcom/intellij/psi/xml/XmlTag;", "doHighlight", "tag", "isHighlightingNeed", "", "intellij.js.liveEdit"})
public final class InspectorElementHighlightExecutor
extends ElementHighlightExecutor {
    @NotNull
    private final ElementsView view;

    public InspectorElementHighlightExecutor(@NotNull ElementsView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    @Override
    protected void doHighlight(@NotNull Project project, @NotNull XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.lastHighlightedTagRef = new WeakReference<XmlTag>(tag);
        int endOffset = tag.getNode().getStartOffset() + tag.getTextLength();
        ElementsViewState elementsViewState = this.view.getState$intellij_js_liveEdit();
        Intrinsics.checkNotNull((Object)elementsViewState);
        ObjectIterator objectIterator = elementsViewState.getNodeIdToRangeMarker$intellij_js_liveEdit().int2ObjectEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            if (((RangeMarker)entry.getValue()).getEndOffset() != endOffset) continue;
            WipCommandProcessor wipCommandProcessor = this.view.getCommandProcessor$intellij_js_liveEdit();
            Intrinsics.checkNotNull((Object)wipCommandProcessor);
            wipCommandProcessor.send((Request)OverlayKt.HighlightNode$default((HighlightConfig)InspectorElementHighlightExecutorKt.DefaultHighlightConfig(), (Integer)entry.getIntKey(), null, null, null, (int)28, null));
            break;
        }
    }

    @Override
    public boolean isHighlightingNeed() {
        return super.isHighlightingNeed() && this.view.getConnection$intellij_js_liveEdit() instanceof ChromeLocalVmConnection;
    }

    @Override
    protected void doHideHighlight(@NotNull Project project, @Nullable XmlTag ifElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WipCommandProcessor wipCommandProcessor = this.view.getCommandProcessor$intellij_js_liveEdit();
        Intrinsics.checkNotNull((Object)wipCommandProcessor);
        wipCommandProcessor.send((Request)DOMKt.HideHighlight());
    }
}

