/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J#\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b)J \u0010*\u001a\u00020$2\n\u0010+\u001a\u00060,j\u0002`-2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\r\u0010.\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b/J\u001b\u00100\u001a\u00020$2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0000\u00a2\u0006\u0002\b4R\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "", "initialText", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/project/Project;)V", "document", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "getDocument$intellij_js_liveEdit", "()Lcom/intellij/openapi/editor/impl/DocumentImpl;", "<set-?>", "", "isReformatInProgress", "isReformatInProgress$intellij_js_liveEdit", "()Z", "nodeIdToRangeMarker", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "getNodeIdToRangeMarker$intellij_js_liveEdit", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "getPsiFile$intellij_js_liveEdit", "()Lcom/intellij/psi/xml/XmlFile;", "viewProvider", "Lcom/intellij/psi/SingleRootFileViewProvider;", "virtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getVirtualFile$intellij_js_liveEdit", "()Lcom/intellij/testFramework/LightVirtualFile;", "buildItemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "nodeId", "", "createPointers", "", "nodeIdToOffset", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/openapi/util/Segment;", "insertionOffset", "createPointers$intellij_js_liveEdit", "loadDocument", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "requestCommitted", "requestCommitted$intellij_js_liveEdit", "scheduleReformat", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "scheduleReformat$intellij_js_liveEdit", "Companion", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nElementsViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsViewState.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsViewState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1855#2,2:144\n*S KotlinDebug\n*F\n+ 1 ElementsViewState.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsViewState\n*L\n65#1:144,2\n*E\n"})
public final class ElementsViewState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LightVirtualFile virtualFile;
    @NotNull
    private final SingleRootFileViewProvider viewProvider;
    @NotNull
    private final Int2ObjectOpenHashMap<RangeMarker> nodeIdToRangeMarker;
    private volatile boolean isReformatInProgress;
    @NotNull
    private static final Key<Boolean> ELEMENTS_VIEW_FILE;

    public ElementsViewState(@NotNull CharSequence initialText, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.nodeIdToRangeMarker = new Int2ObjectOpenHashMap();
        LightVirtualFile virtualFile = new LightVirtualFile("", (Language)HTMLLanguage.INSTANCE, initialText);
        virtualFile.putUserData(ELEMENTS_VIEW_FILE, (Object)true);
        this.virtualFile = virtualFile;
        this.viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)this.project), (VirtualFile)virtualFile, true);
    }

    @NotNull
    public final LightVirtualFile getVirtualFile$intellij_js_liveEdit() {
        return this.virtualFile;
    }

    @NotNull
    public final DocumentImpl getDocument$intellij_js_liveEdit() {
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.virtualFile);
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        return (DocumentImpl)document;
    }

    @NotNull
    public final XmlFile getPsiFile$intellij_js_liveEdit() {
        PsiFile psiFile = this.viewProvider.getPsi(this.viewProvider.getBaseLanguage());
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        return (XmlFile)psiFile;
    }

    @NotNull
    public final Int2ObjectOpenHashMap<RangeMarker> getNodeIdToRangeMarker$intellij_js_liveEdit() {
        return this.nodeIdToRangeMarker;
    }

    public final boolean isReformatInProgress$intellij_js_liveEdit() {
        return this.isReformatInProgress;
    }

    public final void scheduleReformat$intellij_js_liveEdit(@NotNull List<TextRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.isReformatInProgress = true;
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> ElementsViewState.scheduleReformat$lambda$4(this, ranges));
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"nonBlocking(...)");
        NonBlockingReadAction reformatTask = nonBlockingReadAction;
        reformatTask.submit((Executor)AppExecutorUtil.getAppExecutorService()).onError(arg_0 -> ElementsViewState.scheduleReformat$lambda$5((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ ElementsViewState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                ApplicationInspectorImplKt.getLOG().warn(it);
                ElementsViewState.access$setReformatInProgress$p(this.this$0, false);
            }
        }, arg_0));
    }

    @Nullable
    public final ItemPresentation buildItemPresentation(int nodeId) {
        HtmlTagTreeElement htmlTagTreeElement;
        RangeMarker rangeMarker = (RangeMarker)this.nodeIdToRangeMarker.get(nodeId);
        if (rangeMarker != null) {
            RangeMarker rangeMarker2 = rangeMarker;
            boolean bl = false;
            XmlTag xmlTag = (XmlTag)ActionsKt.runReadAction((Function0)((Function0)new Function0<XmlTag>(this, rangeMarker2){
                final /* synthetic */ ElementsViewState this$0;
                final /* synthetic */ RangeMarker $rangeMarker;
                {
                    this.this$0 = $receiver;
                    this.$rangeMarker = $rangeMarker;
                    super(0);
                }

                @Nullable
                public final XmlTag invoke() {
                    PsiElement psiElement = this.this$0.getPsiFile$intellij_js_liveEdit().findElementAt(this.$rangeMarker.getStartOffset());
                    PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
                    return psiElement2 instanceof XmlTag ? (XmlTag)psiElement2 : null;
                }
            }));
            if (xmlTag != null) {
                XmlTag tag = xmlTag;
                boolean bl2 = false;
                htmlTagTreeElement = new HtmlTagTreeElement(tag);
            } else {
                htmlTagTreeElement = null;
            }
        } else {
            htmlTagTreeElement = null;
        }
        return (ItemPresentation)htmlTagTreeElement;
    }

    public final void loadDocument(@NotNull StringBuilder builder, @NotNull Int2ObjectMap<Segment> nodeIdToOffset) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(nodeIdToOffset, (String)"nodeIdToOffset");
        ApplicationManager.getApplication().invokeLater(() -> ElementsViewState.loadDocument$lambda$9(this, nodeIdToOffset, builder));
    }

    public final void createPointers$intellij_js_liveEdit(@NotNull Int2ObjectMap<Segment> nodeIdToOffset, int insertionOffset) {
        Intrinsics.checkNotNullParameter(nodeIdToOffset, (String)"nodeIdToOffset");
        ObjectIterator objectIterator = nodeIdToOffset.int2ObjectEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            Segment range = (Segment)entry.getValue();
            ((Map)this.nodeIdToRangeMarker).put(entry.getIntKey(), this.getDocument$intellij_js_liveEdit().createRangeMarker(insertionOffset + range.getStartOffset(), insertionOffset + range.getEndOffset()));
        }
    }

    public final boolean requestCommitted$intellij_js_liveEdit() {
        return PsiDocumentManager.getInstance((Project)this.project).isCommitted((Document)this.getDocument$intellij_js_liveEdit());
    }

    private static final void scheduleReformat$lambda$4$lambda$3$lambda$2$lambda$1(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$copiedDocument, (String)"$copiedDocument");
        Intrinsics.checkNotNullParameter((Object)$copiedMarkers, (String)"$copiedMarkers");
        for (RangeMarker v : (ObjectCollection)this$0.nodeIdToRangeMarker.values()) {
            v.dispose();
        }
        this$0.nodeIdToRangeMarker.clear();
        this$0.getDocument$intellij_js_liveEdit().setText((CharSequence)$copiedDocument.getText());
        ObjectIterator objectIterator = $copiedMarkers.int2ObjectEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            ((Map)this$0.nodeIdToRangeMarker).put(entry.getIntKey(), this$0.getDocument$intellij_js_liveEdit().createRangeMarker(((RangeMarker)entry.getValue()).getTextRange()));
        }
        for (RangeMarker v : (ObjectCollection)$copiedMarkers.values()) {
            v.dispose();
        }
        this$0.isReformatInProgress = false;
    }

    private static final void scheduleReformat$lambda$4$lambda$3$lambda$2(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$copiedDocument, (String)"$copiedDocument");
        Intrinsics.checkNotNullParameter((Object)$copiedMarkers, (String)"$copiedMarkers");
        ApplicationManager.getApplication().runWriteAction(() -> ElementsViewState.scheduleReformat$lambda$4$lambda$3$lambda$2$lambda$1(this$0, $copiedDocument, $copiedMarkers));
    }

    private static final void scheduleReformat$lambda$4$lambda$3(ElementsViewState this$0, Document $copiedDocument, Int2ObjectOpenHashMap $copiedMarkers) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$copiedDocument, (String)"$copiedDocument");
        Intrinsics.checkNotNullParameter((Object)$copiedMarkers, (String)"$copiedMarkers");
        ApplicationManager.getApplication().invokeLater(() -> ElementsViewState.scheduleReformat$lambda$4$lambda$3$lambda$2(this$0, $copiedDocument, $copiedMarkers));
    }

    private static final void scheduleReformat$lambda$4(ElementsViewState this$0, List $ranges) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ranges, (String)"$ranges");
        if (this$0.getDocument$intellij_js_liveEdit().getTextLength() > ElementsViewKt.getMAX_SIZE_FOR_HIGHLIGHTING() * 1024) {
            this$0.isReformatInProgress = false;
            return;
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        Iterable $this$forEach$iv = $ranges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range = (TextRange)element$iv;
            boolean bl = false;
            formatRanges.add(range, true);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this$0.project).createFileFromText("", (Language)HTMLLanguage.INSTANCE, this$0.getDocument$intellij_js_liveEdit().getCharsSequence(), false, false);
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)((PsiFile)this$0.getPsiFile$intellij_js_liveEdit()));
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
        Intrinsics.checkNotNull((Object)formattingModelBuilder);
        FormattingModelBuilder builder = formattingModelBuilder;
        FormattingModel formattingModel = CoreFormatterUtil.buildModel((FormattingModelBuilder)builder, (PsiElement)((PsiElement)psiFile), (CodeStyleSettings)settings, (FormattingMode)FormattingMode.REFORMAT);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"buildModel(...)");
        FormattingModel model = formattingModel;
        Document document = model.getDocumentModel().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document copiedDocument = document;
        Int2ObjectOpenHashMap copiedMarkers = new Int2ObjectOpenHashMap(this$0.nodeIdToRangeMarker.size());
        ObjectIterator objectIterator = this$0.nodeIdToRangeMarker.int2ObjectEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            ((Map)copiedMarkers).put(entry.getIntKey(), copiedDocument.createRangeMarker(((RangeMarker)entry.getValue()).getTextRange()));
        }
        FormatterEx.getInstance().format(model, settings, settings.getIndentOptions(), formatRanges);
        PsiDocumentManager.getInstance((Project)this$0.project).performForCommittedDocument(copiedDocument, () -> ElementsViewState.scheduleReformat$lambda$4$lambda$3(this$0, copiedDocument, copiedMarkers));
    }

    private static final void scheduleReformat$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void loadDocument$lambda$9$lambda$8(ElementsViewState this$0, StringBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        this$0.getDocument$intellij_js_liveEdit().setText((CharSequence)$builder);
    }

    private static final void loadDocument$lambda$9(ElementsViewState this$0, Int2ObjectMap $nodeIdToOffset, StringBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nodeIdToOffset, (String)"$nodeIdToOffset");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        ApplicationManager.getApplication().runWriteAction(() -> ElementsViewState.loadDocument$lambda$9$lambda$8(this$0, $builder));
        this$0.createPointers$intellij_js_liveEdit((Int2ObjectMap<Segment>)$nodeIdToOffset, 0);
        Object[] objectArray = new TextRange[1];
        Intrinsics.checkNotNullExpressionValue((Object)this$0.getPsiFile$intellij_js_liveEdit().getTextRange(), (String)"getTextRange(...)");
        this$0.scheduleReformat$intellij_js_liveEdit(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public static final /* synthetic */ void access$setReformatInProgress$p(ElementsViewState $this, boolean bl) {
        $this.isReformatInProgress = bl;
    }

    static {
        Key key = Key.create((String)"web.debugger.elements.view.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ELEMENTS_VIEW_FILE = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState$Companion;", "", "()V", "ELEMENTS_VIEW_FILE", "Lcom/intellij/openapi/util/Key;", "", "isElementsViewFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.js.liveEdit"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isElementsViewFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Boolean bl = (Boolean)file.getUserData(ELEMENTS_VIEW_FILE);
            return bl == null ? false : bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

