/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.HtmlSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssSelectorCreator {
    private static final String CHILD_OF = " > ";
    private static final String DESCENDANT = " ";
    private static final String IMMEDIATELY_PRECEDED_BY = " + ";
    private static final String FIRST_CHILD = ":first-child";
    private static final String LAST_CHILD = ":last-child";
    public static final String EMPTY_BODY = "body";
    static final String[] REF_ATTRIBUTES = new String[]{"id", "class"};
    private static CssSelectorCreator TITLE_SELECTOR;
    private static final int EMPTY_REF = -1;
    private static final int ID_REF = 2;
    private static final int CLASS_REF = 1;
    private String selector;
    private ApplicationInspector.SelectorSubject selectorSubject = ApplicationInspector.SelectorSubject.AS_IS;

    @Nullable
    public String getSelector() {
        return this.selector;
    }

    public ApplicationInspector.SelectorSubject selectorSubject() {
        return this.selectorSubject;
    }

    public static CssSelectorCreator createForTitle() {
        if (TITLE_SELECTOR == null) {
            TITLE_SELECTOR = new CssSelectorCreator();
            CssSelectorCreator.TITLE_SELECTOR.selector = "@title";
        }
        return TITLE_SELECTOR;
    }

    public CssSelectorCreator create(XmlTag tag) {
        StringBuilder sb = new StringBuilder();
        this.create(sb, tag);
        this.selector = sb.toString();
        return this;
    }

    private void create(StringBuilder builder, XmlTag tag) {
        if (tag.getName().equals("html")) {
            if ((tag = tag.findFirstSubTag(EMPTY_BODY)) == null) {
                builder.append(EMPTY_BODY);
                return;
            }
            this.selectorSubject = ApplicationInspector.SelectorSubject.HTML;
        } else {
            String id = CssSelectorCreator.getNotEmptyAndNotChangedAttributeValue(tag, "id");
            if (id != null) {
                CssSelectorCreator.appendIdValue(builder, id);
                return;
            }
        }
        if (!tag.getName().equals(EMPTY_BODY)) {
            CssSelectorCreator.appendParents(builder, tag);
            CssSelectorCreator.appendSelectors(tag, builder);
            return;
        }
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length == 0) {
            builder.setLength(0);
            builder.append(EMPTY_BODY);
            return;
        }
        if (this.selectorSubject == ApplicationInspector.SelectorSubject.AS_IS) {
            this.selectorSubject = ApplicationInspector.SelectorSubject.PARENT;
        }
        CssSelectorCreator.appendNameWithRefQualifiers(tag, builder);
        builder.append(CHILD_OF);
        int domTagIndex = 0;
        int lastI = subTags.length - 1;
        for (int i = 0; i < subTags.length; ++i) {
            XmlTag subTag = subTags[i];
            CssSelectorCreator.appendNameWithRefQualifiers(subTag, builder);
            if (i == lastI) {
                if (domTagIndex == 0) {
                    builder.append(":only-child");
                } else {
                    builder.append(LAST_CHILD);
                }
            } else {
                if (domTagIndex == 0) {
                    builder.append(FIRST_CHILD);
                }
                builder.append(IMMEDIATELY_PRECEDED_BY);
            }
            ++domTagIndex;
        }
        if (domTagIndex == 0) {
            builder.setLength(0);
            builder.append(EMPTY_BODY);
        }
    }

    private static void appendIdValue(StringBuilder builder, String id) {
        builder.append('#');
        CssSelectorCreator.escape(builder, id);
    }

    private static boolean appendSelectors(XmlTag tag, StringBuilder builder) {
        CssSelectorCreator.escape(builder, tag.getName());
        if (tag.getName().equalsIgnoreCase("html") || tag.getName().equalsIgnoreCase(EMPTY_BODY) || tag.getName().equalsIgnoreCase("head") || CssSelectorCreator.addRefQualifiers(tag, builder) == 2) {
            return true;
        }
        int index = 1;
        boolean firstIsScript = false;
        for (PsiElement prevSibling = tag.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (!(prevSibling instanceof XmlTag)) continue;
            XmlTag sibling = (XmlTag)prevSibling;
            if (HtmlUtil.isScriptTag((XmlTag)sibling)) {
                if (tag.getParentTag() == null || "html".equals(tag.getParentTag().getName())) {
                    firstIsScript = true;
                }
            } else {
                if (sibling.getName().equalsIgnoreCase("head")) break;
                firstIsScript = false;
            }
            ++index;
        }
        if (firstIsScript) {
            --index;
        }
        builder.append(":nth-child(").append(index).append(')');
        return false;
    }

    private static void appendParents(StringBuilder sb, XmlTag tag) {
        SmartList parents = new SmartList();
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null && !parentTag.getName().equals("html"); parentTag = parentTag.getParentTag()) {
            parents.add(parentTag);
            if (CssSelectorCreator.getNotEmptyAndNotChangedAttributeValue(parentTag, "id") != null) break;
        }
        int i = parents.size();
        while (i-- > 0) {
            XmlTag parent = (XmlTag)parents.get(i);
            CssSelectorCreator.appendSelectors(parent, sb);
            sb.append(parent.getName().equalsIgnoreCase("table") ? DESCENDANT : CHILD_OF);
        }
    }

    public CssSelectorCreator create(XmlAttribute attribute, XmlTag base) {
        StringBuilder sb = new StringBuilder();
        this.createSelector(sb, attribute, base);
        this.selector = sb.toString();
        return this;
    }

    private StringBuilder createSelector(StringBuilder sb, XmlAttribute attribute, XmlTag base) {
        boolean isExistingAttribute;
        this.create(sb, base);
        boolean bl = isExistingAttribute = HtmlSynchronizer.ELEMENT_STATE_KEY.get((UserDataHolder)attribute) != HtmlSynchronizer.ElementState.NEW;
        if (!isExistingAttribute) {
            HtmlSynchronizer.clearElementState((XmlElement)attribute);
            sb.append(":not(");
        }
        sb.append('[');
        CssSelectorCreator.escape(sb, attribute.getName());
        sb.append(']');
        if (!isExistingAttribute) {
            sb.append(')');
        }
        return sb;
    }

    @Nullable
    private static String getNotEmptyAndNotChangedAttributeValue(XmlTag tag, String attributeName) {
        XmlAttribute attribute = tag.getAttribute(attributeName);
        if (attribute != null && HtmlSynchronizer.isElementNotChanged((XmlElement)attribute) && attribute.getValueElement() != null) {
            return StringUtil.nullize((String)tag.getAttributeValue(attributeName));
        }
        return null;
    }

    private static int appendNameWithRefQualifiers(XmlTag tag, StringBuilder sb) {
        CssSelectorCreator.escape(sb, tag.getName());
        return CssSelectorCreator.addRefQualifiers(tag, sb);
    }

    private static void escape(StringBuilder sb, String string) {
        CssSelectorCreator.escape(sb, string, string.length());
    }

    private static void escape(@NotNull StringBuilder sb, @NotNull String string, int length) {
        int i;
        if (sb == null) {
            CssSelectorCreator.$$$reportNull$$$0(0);
        }
        if (string == null) {
            CssSelectorCreator.$$$reportNull$$$0(1);
        }
        if (string.isEmpty()) {
            return;
        }
        if (string.startsWith("&#x") && string.endsWith(";")) {
            sb.append('\\').append(string, 3, string.length() - 1);
            return;
        }
        char firstChar = string.charAt(0);
        if (Character.isDigit(firstChar)) {
            sb.append("\\3").append(firstChar).append(' ');
            i = 1;
        } else if (firstChar == '-') {
            sb.append('\\').append(firstChar);
            i = 1;
        } else {
            i = 0;
        }
        while (i < length) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~') {
                if (Character.isHighSurrogate(c)) {
                    char extra = string.charAt(i);
                    if ((extra & 0xFC00) == 56320) {
                        c = (char)(((c & 0x3FF) << 10) + (extra & 0x3FF) + 65536);
                    } else {
                        --i;
                    }
                }
                sb.append('\\').append(StringUtil.toUpperCase((String)Integer.toString(c, 16))).append(' ');
            } else {
                if (c == '\\' || c == ':' || c == ' ' || c == '!' || c >= '#' && c <= '&' || c >= '(' && c <= ',' || c == '.' || c == '/' || c >= ';' && c <= '@' || c == '[' || c == ']' || c == '^' || c == '`' || c >= '{') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            ++i;
        }
    }

    private static int addRefQualifiers(XmlTag tag, StringBuilder sb) {
        for (String attributeName : REF_ATTRIBUTES) {
            String value = CssSelectorCreator.getNotEmptyAndNotChangedAttributeValue(tag, attributeName);
            if (value == null) continue;
            if (attributeName.equals("id")) {
                CssSelectorCreator.appendIdValue(sb, value);
                return 2;
            }
            int spaceIndex = value.indexOf(32);
            sb.append('.');
            if (spaceIndex == -1) {
                CssSelectorCreator.escape(sb, value);
            } else {
                CssSelectorCreator.escape(sb, value, spaceIndex);
            }
            return 1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sb";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "string";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/liveEdit/CssSelectorCreator";
        objectArray[2] = "escape";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

